/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.jpeg;

import com.sun.media.imageioimpl.common.PackageUtil;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.wms.WMS;
import org.geotools.image.ImageWorker;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.wms.responses.DefaultRasterMapProducer;

public final class JPEGMapProducer
extends DefaultRasterMapProducer {
    private static final Logger LOGGER = Logging.getLogger((String)JPEGMapProducer.class.toString());
    static final String MIME_TYPE = "image/jpeg";
    private boolean JPEGNativeAcc;

    public JPEGMapProducer(WMS wms) {
        super(MIME_TYPE, wms);
        this.JPEGNativeAcc = wms.getJPEGNativeAcceleration() != false && PackageUtil.isCodecLibAvailable();
    }

    protected RenderedImage prepareImage(int width, int height, IndexColorModel palette, boolean transparent) {
        transparent = false;
        palette = null;
        return super.prepareImage(width, height, palette, transparent);
    }

    protected long getDrawingSurfaceMemoryUse(int width, int height, IndexColorModel palette, boolean transparent) {
        transparent = false;
        palette = null;
        return super.getDrawingSurfaceMemoryUse(width, height, palette, transparent);
    }

    public void formatImageOutputStream(RenderedImage image, OutputStream outStream) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("About to write a JPEG image.");
        }
        float quality = (float)(100 - this.wms.getJpegCompression()) / 100.0f;
        new ImageWorker(image).writeJPEG((Object)outStream, "JPEG", quality, this.JPEGNativeAcc);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing a JPEG done!!!");
        }
    }

    public String getContentDisposition() {
        return null;
    }
}

