/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.util.IOUtils;
import org.geoserver.kml.KMLRasterTransformer;
import org.geoserver.kml.KMLSuperOverlayTransformer;
import org.geoserver.kml.KMLTransformer;
import org.geoserver.kml.KMLVectorTransformer;
import org.geoserver.kml.KMZMapOutputFormat;
import org.geoserver.kml.KMZMapResponse;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.xml.transform.TransformerBase;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KMLTransformerTest
extends WMSTestSupport {
    WMSMapContext mapContext;
    MapLayer mapLayer;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new KMLTransformerTest());
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.mapLayer = this.createMapLayer(MockData.BASIC_POLYGONS);
        this.mapContext = new WMSMapContext(this.createGetMapRequest(MockData.BASIC_POLYGONS));
        this.mapContext.addLayer(this.mapLayer);
    }

    protected void tearDownInternal() {
        this.mapContext.dispose();
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addStyle("allsymbolizers", ((Object)((Object)this)).getClass().getResource("allsymbolizers.sld"));
        dataDirectory.addStyle("SingleFeature", ((Object)((Object)this)).getClass().getResource("singlefeature.sld"));
        dataDirectory.addStyle("Bridge", ((Object)((Object)this)).getClass().getResource("bridge.sld"));
        dataDirectory.addStyle("BridgeSubdir", ((Object)((Object)this)).getClass().getResource("bridgesubdir.sld"));
        dataDirectory.addStyle("dynamicsymbolizer", ((Object)((Object)this)).getClass().getResource("dynamicsymbolizer.sld"));
        dataDirectory.copyTo(((Object)((Object)this)).getClass().getResourceAsStream("bridge.png"), "styles/bridge.png");
        new File(dataDirectory.getDataDirectoryRoot(), "styles/graphics").mkdir();
        dataDirectory.copyTo(((Object)((Object)this)).getClass().getResourceAsStream("bridge.png"), "styles/graphics/bridgesubdir.png");
    }

    public void testVectorTransformer() throws Exception {
        KMLVectorTransformer transformer = new KMLVectorTransformer(this.getWMS(), this.mapContext, this.mapLayer);
        transformer.setIndentation(2);
        SimpleFeatureSource featureSource = DataUtilities.simple((FeatureSource)this.mapLayer.getFeatureSource());
        int nfeatures = featureSource.getFeatures().size();
        Document document = WMSTestSupport.transform(featureSource.getFeatures(), (TransformerBase)transformer);
        Element element = document.getDocumentElement();
        KMLTransformerTest.assertEquals((String)"kml", (String)element.getNodeName());
        KMLTransformerTest.assertEquals((int)nfeatures, (int)element.getElementsByTagName("Style").getLength());
        KMLTransformerTest.assertEquals((int)nfeatures, (int)element.getElementsByTagName("Placemark").getLength());
    }

    public void testExternalGraphicBackround() throws Exception {
        Document document;
        MapLayer mapLayer = this.createMapLayer(MockData.POINTS, "Bridge");
        SimpleFeatureSource featureSource = (SimpleFeatureSource)mapLayer.getFeatureSource();
        int nfeatures = featureSource.getFeatures().size();
        WMSMapContext mapContext = new WMSMapContext(this.createGetMapRequest(MockData.POINTS));
        try {
            mapContext.addLayer(mapLayer);
            KMLVectorTransformer transformer = new KMLVectorTransformer(this.getWMS(), mapContext, mapLayer);
            transformer.setIndentation(2);
            document = WMSTestSupport.transform(featureSource.getFeatures(), (TransformerBase)transformer);
        }
        finally {
            mapContext.dispose();
        }
        XMLAssert.assertXpathEvaluatesTo((String)("" + nfeatures), (String)"count(//Style/IconStyle/Icon/href)", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//Style/IconStyle/Icon/color)", (Document)document);
    }

    public void testExternalGraphicSubdir() throws Exception {
        Document document;
        MapLayer mapLayer = this.createMapLayer(MockData.POINTS, "BridgeSubdir");
        SimpleFeatureSource featureSource = (SimpleFeatureSource)mapLayer.getFeatureSource();
        WMSMapContext mapContext = new WMSMapContext(this.createGetMapRequest(MockData.POINTS));
        try {
            mapContext.addLayer(mapLayer);
            KMLVectorTransformer transformer = new KMLVectorTransformer(this.getWMS(), mapContext, mapLayer);
            transformer.setIndentation(2);
            document = WMSTestSupport.transform(featureSource.getFeatures(), (TransformerBase)transformer);
        }
        finally {
            mapContext.dispose();
        }
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/styles/graphics/bridgesubdir.png", (String)"//Style/IconStyle/Icon/href", (Document)document);
    }

    public void testProxyBaseURL() throws Exception {
        GeoServer gs = this.getGeoServer();
        try {
            Document document;
            GeoServerInfo info = gs.getGlobal();
            info.setProxyBaseUrl("http://myhost:9999/gs");
            gs.save(info);
            MapLayer mapLayer = this.createMapLayer(MockData.POINTS, "Bridge");
            FeatureSource featureSource = mapLayer.getFeatureSource();
            int nfeatures = featureSource.getFeatures().size();
            WMSMapContext mapContext = new WMSMapContext(this.createGetMapRequest(MockData.POINTS));
            try {
                mapContext.addLayer(mapLayer);
                KMLVectorTransformer transformer = new KMLVectorTransformer(this.getWMS(), mapContext, mapLayer);
                transformer.setIndentation(2);
                document = WMSTestSupport.transform(featureSource.getFeatures(), (TransformerBase)transformer);
            }
            finally {
                mapContext.dispose();
            }
            XMLAssert.assertXpathEvaluatesTo((String)"http://myhost:9999/gs/styles/bridge.png", (String)"//Style/IconStyle/Icon/href", (Document)document);
        }
        finally {
            GeoServerInfo info = gs.getGlobal();
            info.setProxyBaseUrl(null);
            gs.save(info);
        }
    }

    public void testFilteredData() throws Exception {
        Document document;
        MapLayer mapLayer = this.createMapLayer(MockData.BASIC_POLYGONS, "SingleFeature");
        SimpleFeatureSource featureSource = (SimpleFeatureSource)mapLayer.getFeatureSource();
        WMSMapContext mapContext = new WMSMapContext(this.createGetMapRequest(MockData.BASIC_POLYGONS));
        try {
            mapContext.addLayer(mapLayer);
            KMLVectorTransformer transformer = new KMLVectorTransformer(this.getWMS(), mapContext, mapLayer);
            transformer.setIndentation(2);
            document = WMSTestSupport.transform(featureSource.getFeatures(), (TransformerBase)transformer);
        }
        finally {
            mapContext.dispose();
        }
        Element element = document.getDocumentElement();
        KMLTransformerTest.assertEquals((String)"kml", (String)element.getNodeName());
        KMLTransformerTest.assertEquals((int)1, (int)element.getElementsByTagName("Placemark").getLength());
        KMLTransformerTest.assertEquals((int)1, (int)element.getElementsByTagName("Style").getLength());
    }

    public void testRasterTransformerInline() throws Exception {
        KMLRasterTransformer transformer = new KMLRasterTransformer(this.getWMS(), this.mapContext);
        transformer.setInline(true);
        Document document = WMSTestSupport.transform(this.mapLayer, (TransformerBase)transformer);
        KMLTransformerTest.assertEquals((String)"kml", (String)document.getDocumentElement().getNodeName());
        KMLTransformerTest.assertEquals((int)this.mapContext.getLayerCount(), (int)document.getElementsByTagName("Folder").getLength());
        KMLTransformerTest.assertEquals((int)this.mapContext.getLayerCount(), (int)document.getElementsByTagName("GroundOverlay").getLength());
        KMLTransformerTest.assertEquals((int)this.mapContext.getLayerCount(), (int)document.getElementsByTagName("href").getLength());
        Element href = (Element)document.getElementsByTagName("href").item(0);
        KMLTransformerTest.assertEquals((String)"images/layer_0.png", (String)href.getFirstChild().getNodeValue());
    }

    public void testRasterTransformerNotInline() throws Exception {
        KMLRasterTransformer transformer = new KMLRasterTransformer(this.getWMS(), this.mapContext);
        transformer.setInline(false);
        Document document = WMSTestSupport.transform(this.mapLayer, (TransformerBase)transformer);
        KMLTransformerTest.assertEquals((String)"kml", (String)document.getDocumentElement().getNodeName());
        KMLTransformerTest.assertEquals((int)this.mapContext.getLayerCount(), (int)document.getElementsByTagName("Folder").getLength());
        KMLTransformerTest.assertEquals((int)this.mapContext.getLayerCount(), (int)document.getElementsByTagName("GroundOverlay").getLength());
        KMLTransformerTest.assertEquals((int)this.mapContext.getLayerCount(), (int)document.getElementsByTagName("href").getLength());
        Element href = (Element)document.getElementsByTagName("href").item(0);
        KMLTransformerTest.assertTrue((boolean)href.getFirstChild().getNodeValue().startsWith("http://localhost"));
    }

    public void testRasterPlacemarkTrue() throws Exception {
        this.doTestRasterPlacemark(true);
    }

    public void testRasterPlacemarkFalse() throws Exception {
        this.doTestRasterPlacemark(false);
    }

    protected void doTestRasterPlacemark(boolean doPlacemarks) throws Exception {
        GetMapRequest getMapRequest = this.createGetMapRequest(MockData.BASIC_POLYGONS);
        HashMap<String, Comparable<Boolean>> formatOptions = new HashMap<String, Comparable<Boolean>>();
        formatOptions.put("kmplacemark", new Boolean(doPlacemarks));
        formatOptions.put("kmscore", new Integer(0));
        getMapRequest.setFormatOptions(formatOptions);
        WMSMapContext mapContext = new WMSMapContext(getMapRequest);
        mapContext.addLayer(this.mapLayer);
        mapContext.setMapHeight(1024);
        mapContext.setMapWidth(1024);
        KMZMapOutputFormat mapProducer = new KMZMapOutputFormat(this.getWMS());
        KMZMapResponse mapEncoder = new KMZMapResponse(this.getWMS());
        KMZMapResponse.KMZMap kmzMap = mapProducer.produceMap(mapContext);
        try {
            int len;
            File tempDir = IOUtils.createRandomDirectory((String)"./target", (String)"kmplacemark", (String)"test");
            tempDir.deleteOnExit();
            File zip = new File(tempDir, "kmz.zip");
            zip.deleteOnExit();
            FileOutputStream output = new FileOutputStream(zip);
            mapEncoder.write((Object)kmzMap, (OutputStream)output, null);
            output.flush();
            output.close();
            KMLTransformerTest.assertTrue((boolean)zip.exists());
            ZipFile zipFile = new ZipFile(zip);
            ZipEntry entry = zipFile.getEntry("wms.kml");
            KMLTransformerTest.assertNotNull((Object)entry);
            KMLTransformerTest.assertNotNull((Object)zipFile.getEntry("images/layer_0.png"));
            byte[] buffer = new byte[1024];
            InputStream inStream = zipFile.getInputStream(entry);
            File temp = File.createTempFile("test_out", "kmz", tempDir);
            temp.deleteOnExit();
            BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(temp));
            while ((len = inStream.read(buffer)) >= 0) {
                outStream.write(buffer, 0, len);
            }
            inStream.close();
            outStream.close();
            Document document = this.dom(new BufferedInputStream(new FileInputStream(temp)));
            KMLTransformerTest.assertEquals((String)"kml", (String)document.getDocumentElement().getNodeName());
            if (doPlacemarks) {
                KMLTransformerTest.assertEquals((int)this.getFeatureSource(MockData.BASIC_POLYGONS).getFeatures().size(), (int)document.getElementsByTagName("Placemark").getLength());
            } else {
                KMLTransformerTest.assertEquals((int)0, (int)document.getElementsByTagName("Placemark").getLength());
            }
            zipFile.close();
        }
        finally {
            kmzMap.dispose();
        }
    }

    public void testSuperOverlayTransformer() throws Exception {
        KMLSuperOverlayTransformer transformer = new KMLSuperOverlayTransformer(this.getWMS(), this.mapContext);
        transformer.setIndentation(2);
        this.mapContext.setAreaOfInterest(new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        transformer.transform((Object)this.mapLayer, (OutputStream)output);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        KMLTransformerTest.assertEquals((String)"kml", (String)document.getDocumentElement().getNodeName());
        KMLTransformerTest.assertEquals((int)5, (int)document.getElementsByTagName("Region").getLength());
        KMLTransformerTest.assertEquals((int)4, (int)document.getElementsByTagName("NetworkLink").getLength());
    }

    public void testStyleConverter() throws Exception {
        KMLTransformer transformer = new KMLTransformer(this.getWMS());
        this.mapContext.removeLayer(this.mapContext.getLayer(0));
        this.mapContext.addLayer(this.createMapLayer(MockData.BASIC_POLYGONS, "allsymbolizers"));
        this.mapContext.setAreaOfInterest(new ReferencedEnvelope(-180.0, 0.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        this.mapContext.setMapHeight(256);
        this.mapContext.setMapWidth(256);
        Document document = WMSTestSupport.transform(this.mapContext, (TransformerBase)transformer, false);
        KMLTransformerTest.assertEquals((String)"kml", (String)document.getDocumentElement().getNodeName());
        KMLTransformerTest.assertEquals((int)3, (int)document.getElementsByTagName("Style").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//Style[1]/IconStyle/Icon/color)", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"http://maps.google.com/mapfiles/kml/pal4/icon25.png", (String)"//Style[1]/IconStyle/Icon/href", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"b24d4dff", (String)"//Style[1]/PolyStyle/color", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//Style[1]/PolyStyle/outline", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"ffba3e00", (String)"//Style[1]/LineStyle/color", (Document)document);
    }

    public void testDynamicSymbolizer() throws Exception {
        KMLTransformer transformer = new KMLTransformer(this.getWMS());
        this.mapContext.removeLayer(this.mapContext.getLayer(0));
        this.mapContext.addLayer(this.createMapLayer(MockData.STREAMS, "dynamicsymbolizer"));
        this.mapContext.setAreaOfInterest(new ReferencedEnvelope(-180.0, 0.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        this.mapContext.setMapHeight(256);
        this.mapContext.setMapWidth(256);
        Document document = WMSTestSupport.transform(this.mapContext, (TransformerBase)transformer, false);
        KMLTransformerTest.assertEquals((String)"kml", (String)document.getDocumentElement().getNodeName());
        KMLTransformerTest.assertEquals((int)1, (int)document.getElementsByTagName("Style").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"http://example.com/Cam Stream", (String)"//Style[1]/IconStyle/Icon/href", (Document)document);
    }

    public void testTransformer() throws Exception {
        KMLTransformer transformer = new KMLTransformer(this.getWMS());
        Document document = WMSTestSupport.transform(this.mapContext, (TransformerBase)transformer);
        KMLTransformerTest.assertEquals((String)"kml", (String)document.getDocumentElement().getNodeName());
    }
}

