/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.kml.KMZMapOutputFormat;
import org.geoserver.kml.KMZMapResponse;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.WMSTestSupport;

public class KMZMapProducerTest
extends WMSTestSupport {
    KMZMapOutputFormat mapProducer;
    KMZMapResponse mapEncoder;
    KMZMapResponse.KMZMap producedMap;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new KMZMapProducerTest());
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        WMSMapContext mapContext = new WMSMapContext();
        mapContext.addLayer(this.createMapLayer(MockData.BASIC_POLYGONS));
        mapContext.addLayer(this.createMapLayer(MockData.BUILDINGS));
        mapContext.setMapHeight(256);
        mapContext.setMapWidth(256);
        GetMapRequest getMapRequest = this.createGetMapRequest(new QName[]{MockData.BASIC_POLYGONS, MockData.BUILDINGS});
        mapContext.setRequest(getMapRequest);
        this.mapProducer = new KMZMapOutputFormat(this.getWMS());
        this.mapEncoder = new KMZMapResponse(this.getWMS());
        this.producedMap = this.mapProducer.produceMap(mapContext);
    }

    public void test() throws Exception {
        File temp = File.createTempFile("test", "kmz");
        temp.delete();
        temp.mkdir();
        temp.deleteOnExit();
        File zip = new File(temp, "kmz.zip");
        zip.deleteOnExit();
        FileOutputStream output = new FileOutputStream(zip);
        this.mapEncoder.write((Object)this.producedMap, (OutputStream)output, null);
        output.flush();
        output.close();
        KMZMapProducerTest.assertTrue((boolean)zip.exists());
        ZipFile zipFile = new ZipFile(zip);
        KMZMapProducerTest.assertNotNull((Object)zipFile.getEntry("wms.kml"));
        KMZMapProducerTest.assertNotNull((Object)zipFile.getEntry("images/layer_0.png"));
        KMZMapProducerTest.assertNotNull((Object)zipFile.getEntry("images/layer_1.png"));
        zipFile.close();
    }

    public void testContentDisposition() {
        String[][] responseHeaders = this.producedMap.getResponseHeaders();
        KMZMapProducerTest.assertNotNull((Object)responseHeaders);
        KMZMapProducerTest.assertEquals((int)1, (int)responseHeaders.length);
        KMZMapProducerTest.assertEquals((String)"Content-Disposition", (String)responseHeaders[0][0]);
        String contentDisposition = responseHeaders[0][1];
        KMZMapProducerTest.assertTrue((boolean)contentDisposition.startsWith("attachment; filename="));
        KMZMapProducerTest.assertTrue((boolean)contentDisposition.endsWith(".kmz"));
    }
}

