/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Collections;
import javax.imageio.ImageIO;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSTestSupport;
import org.w3c.dom.Document;

public class RenderingBufferTest
extends WMSTestSupport {
    static final QName LINE_WIDTH_LAYER = new QName(MockData.CITE_URI, "LineWidth", MockData.CITE_PREFIX);
    static final String LINE_WIDTH_STYLE = "linewidth";

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addStyle(LINE_WIDTH_STYLE, ((Object)((Object)this)).getClass().getResource("linewidth.sld"));
        dataDirectory.addPropertiesType(LINE_WIDTH_LAYER, ((Object)((Object)this)).getClass().getResource("LineWidth.properties"), Collections.singletonMap("style", LINE_WIDTH_STYLE));
    }

    public void testGetMapNoBuffer() throws Exception {
        String request = "cite/wms?request=getmap&service=wms&layers=" + this.getLayerId(LINE_WIDTH_LAYER) + "&styles=" + LINE_WIDTH_STYLE + "&width=50&height=50&format=image/png" + "&srs=epsg:4326&bbox=-6,0,-1,5";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        RenderingBufferTest.assertEquals((String)"image/png", (String)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        this.showImage("testGetMap", image);
        RenderingBufferTest.assertEquals((int)0, (int)this.countNonBlankPixels("testGetMap", image, BG_COLOR));
    }

    public void testGetFeatureInfoNoBuffer() throws Exception {
        String layerName = this.getLayerId(LINE_WIDTH_LAYER);
        String request = "cite/wms?request=getfeatureinfo&service=wms&layers=" + layerName + "&styles=" + LINE_WIDTH_STYLE + "&width=50&height=50&format=image/png" + "&srs=epsg:4326&bbox=-6,0,-1,5&x=49&y=49&query_layers=" + layerName + "&info_format=application/vnd.ogc.gml";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//gml:featureMember)", (Document)dom);
    }

    public void testGetMapExplicitBuffer() throws Exception {
        String request = "cite/wms?request=getmap&service=wms&layers=" + this.getLayerId(LINE_WIDTH_LAYER) + "&styles=" + LINE_WIDTH_STYLE + "&width=50&height=50&format=image/png" + "&srs=epsg:4326&bbox=-6,0,-1,5&buffer=30";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        RenderingBufferTest.assertEquals((String)"image/png", (String)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        this.showImage("testGetMap", image);
        RenderingBufferTest.assertTrue((this.countNonBlankPixels("testGetMap", image, BG_COLOR) > 0 ? 1 : 0) != 0);
    }

    public void testGetFeatureInfoExplicitBuffer() throws Exception {
        String layerName = this.getLayerId(LINE_WIDTH_LAYER);
        String request = "cite/wms?version=1.1.1&request=getfeatureinfo&service=wms&layers=" + layerName + "&styles=" + LINE_WIDTH_STYLE + "&width=50&height=50&format=image/png" + "&srs=epsg:4326&bbox=-6,0,-1,5&x=49&y=49&query_layers=" + layerName + "&info_format=application/vnd.ogc.gml&buffer=30";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gml:featureMember)", (Document)dom);
    }

    public void testGetMapConfiguredBuffer() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerInfo layer = catalog.getLayerByName(this.getLayerId(LINE_WIDTH_LAYER));
        layer.getMetadata().put("buffer", (Serializable)Integer.valueOf(30));
        catalog.save(layer);
        String request = "cite/wms?request=getmap&service=wms&layers=" + this.getLayerId(LINE_WIDTH_LAYER) + "&styles=" + LINE_WIDTH_STYLE + "&width=50&height=50&format=image/png" + "&srs=epsg:4326&bbox=-6,0,-1,5";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        RenderingBufferTest.assertEquals((String)"image/png", (String)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        this.showImage("testGetMap", image);
        RenderingBufferTest.assertTrue((this.countNonBlankPixels("testGetMap", image, BG_COLOR) > 0 ? 1 : 0) != 0);
    }

    public void testGetFeatureInfoConfiguredBuffer() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerInfo layer = catalog.getLayerByName(this.getLayerId(LINE_WIDTH_LAYER));
        layer.getMetadata().put("buffer", (Serializable)Integer.valueOf(30));
        catalog.save(layer);
        String layerName = this.getLayerId(LINE_WIDTH_LAYER);
        String request = "cite/wms?version=1.1.1&request=getfeatureinfo&service=wms&layers=" + layerName + "&styles=" + LINE_WIDTH_STYLE + "&width=50&height=50&format=image/png" + "&srs=epsg:4326&bbox=-6,0,-1,5&x=49&y=49&query_layers=" + layerName + "&info_format=application/vnd.ogc.gml";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gml:featureMember)", (Document)dom);
    }
}

