/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.geoserver.platform.ExtensionFilter;
import org.geoserver.platform.ExtensionProvider;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.WMSExtensions;
import org.springframework.context.ApplicationContext;

public class WMSExtensionsTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testFindMapProducers() {
        GetMapOutputFormat mockProducer1 = (GetMapOutputFormat)EasyMock.createMock(GetMapOutputFormat.class);
        GetMapOutputFormat mockProducer2 = (GetMapOutputFormat)EasyMock.createMock(GetMapOutputFormat.class);
        ApplicationContext mockContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        EasyMock.expect((Object)mockContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)mockContext.getBeanNamesForType(GetMapOutputFormat.class)).andReturn((Object)new String[]{"producer1", "producer2"});
        EasyMock.expect((Object)mockContext.getBeanNamesForType(ExtensionProvider.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)mockContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)mockContext.getBean("producer1")).andReturn((Object)mockProducer1);
        EasyMock.expect((Object)mockContext.getBean("producer2")).andReturn((Object)mockProducer2);
        EasyMock.replay((Object[])new Object[]{mockContext});
        List mapProducers = WMSExtensions.findMapProducers((ApplicationContext)mockContext);
        WMSExtensionsTest.assertNotNull((Object)mapProducers);
        WMSExtensionsTest.assertEquals((int)2, (int)mapProducers.size());
        WMSExtensionsTest.assertTrue((boolean)mapProducers.contains(mockProducer1));
        WMSExtensionsTest.assertTrue((boolean)mapProducers.contains(mockProducer2));
    }

    public void testFindMapProducersEmpty() {
        ApplicationContext mockContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        EasyMock.expect((Object)mockContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)mockContext.getBeanNamesForType(GetMapOutputFormat.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)mockContext.getBeanNamesForType(ExtensionProvider.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)mockContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[0]);
        EasyMock.replay((Object[])new Object[]{mockContext});
        List mapProducers = WMSExtensions.findMapProducers((ApplicationContext)mockContext);
        WMSExtensionsTest.assertNotNull((Object)mapProducers);
        WMSExtensionsTest.assertEquals((int)0, (int)mapProducers.size());
    }

    public void testFindMapProducer() {
        GetMapOutputFormat mockProducer = (GetMapOutputFormat)EasyMock.createMock(GetMapOutputFormat.class);
        ApplicationContext mockContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        EasyMock.expect((Object)mockContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)mockContext.getBeanNamesForType(GetMapOutputFormat.class)).andReturn((Object)new String[]{"producer1"});
        EasyMock.expect((Object)mockContext.getBeanNamesForType(ExtensionProvider.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)mockContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)mockContext.getBean("producer1")).andReturn((Object)mockProducer);
        EasyMock.expect((Object)mockContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)mockContext.getBeanNamesForType(GetMapOutputFormat.class)).andReturn((Object)new String[]{"producer1"});
        EasyMock.expect((Object)mockContext.getBeanNamesForType(ExtensionProvider.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)mockContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[0]);
        EasyMock.expect((Object)mockContext.getBean("producer1")).andReturn((Object)mockProducer);
        HashSet<String> testFormatNames = new HashSet<String>();
        testFormatNames.add("image/fakeformat");
        testFormatNames.add("image/dummy");
        EasyMock.expect((Object)mockProducer.getOutputFormatNames()).andReturn(testFormatNames).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockContext});
        EasyMock.replay((Object[])new Object[]{mockProducer});
        GetMapOutputFormat producer = WMSExtensions.findMapProducer((String)"ImaGe/FaKeForMat", (ApplicationContext)mockContext);
        WMSExtensionsTest.assertSame((Object)mockProducer, (Object)producer);
        producer = WMSExtensions.findMapProducer((String)"notARegisteredFormat", (ApplicationContext)mockContext);
        WMSExtensionsTest.assertNull((Object)producer);
        EasyMock.verify((Object[])new Object[]{mockProducer});
        EasyMock.verify((Object[])new Object[]{mockContext});
    }
}

