/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.util.Iterator;
import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.featureinfo.FeatureTemplate;
import org.geoserver.wms.featureinfo.dummy.Dummy;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.opengis.feature.simple.SimpleFeature;

public class FeatureTemplateTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new FeatureTemplateTest());
    }

    public void testWithDateAndBoolean() throws Exception {
        SimpleFeatureSource source = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        SimpleFeatureCollection fc = source.getFeatures();
        Iterator i = fc.iterator();
        try {
            SimpleFeature f = (SimpleFeature)i.next();
            FeatureTemplate template = new FeatureTemplate();
            try {
                template.description(f);
            }
            catch (Exception e) {
                e.printStackTrace();
                FeatureTemplateTest.fail((String)"template threw exception on null value");
            }
        }
        finally {
            fc.close(i);
        }
    }

    public void testRawValue() throws Exception {
        SimpleFeatureSource source = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        SimpleFeatureCollection fc = source.getFeatures();
        Iterator i = fc.iterator();
        try {
            SimpleFeature f = (SimpleFeature)i.next();
            FeatureTemplate template = new FeatureTemplate();
            try {
                template.template(f, "rawValues.ftl", FeatureTemplateTest.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            fc.close(i);
        }
    }

    public void testWithNull() throws Exception {
        SimpleFeatureSource source = this.getFeatureSource(MockData.BASIC_POLYGONS);
        SimpleFeatureCollection fc = source.getFeatures();
        Iterator i = fc.iterator();
        try {
            SimpleFeature f = (SimpleFeature)i.next();
            FeatureTemplate template = new FeatureTemplate();
            template.description(f);
            f.setAttribute(1, null);
            try {
                template.description(f);
            }
            catch (Exception e) {
                e.printStackTrace();
                FeatureTemplateTest.fail((String)"template threw exception on null value");
            }
        }
        finally {
            fc.close(i);
        }
    }

    public void testAlternateLookup() throws Exception {
        SimpleFeatureSource source = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        SimpleFeatureCollection fc = source.getFeatures();
        SimpleFeature f = (SimpleFeature)fc.features().next();
        FeatureTemplate template = new FeatureTemplate();
        String result = template.template(f, "dummy.ftl", Dummy.class);
        FeatureTemplateTest.assertEquals((String)"dummy", (String)result);
    }
}

