/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.georss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.georss.GeoRSSTransformerBase;
import org.geoserver.wms.georss.RSSGeoRSSTransformer;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.map.MapLayer;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RSSGeoRSSTransformerTest
extends WMSTestSupport {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new RSSGeoRSSTransformerTest());
    }

    public void testLatLongInternal() throws Exception {
        Document document;
        WMSMapContext map = new WMSMapContext(this.createGetMapRequest(MockData.BASIC_POLYGONS));
        map.addLayer(this.createMapLayer(MockData.BASIC_POLYGONS));
        try {
            document = this.getRSSResponse(map, GeoRSSTransformerBase.GeometryEncoding.LATLONG);
        }
        finally {
            map.dispose();
        }
        Element element = document.getDocumentElement();
        RSSGeoRSSTransformerTest.assertEquals((String)"rss", (String)element.getNodeName());
        NodeList items = element.getElementsByTagName("item");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        RSSGeoRSSTransformerTest.assertEquals((int)n, (int)items.getLength());
        int i = 0;
        while (i < items.getLength()) {
            Element item = (Element)items.item(i);
            RSSGeoRSSTransformerTest.assertEquals((int)1, (int)item.getElementsByTagName("geo:lat").getLength());
            RSSGeoRSSTransformerTest.assertEquals((int)1, (int)item.getElementsByTagName("geo:long").getLength());
            ++i;
        }
    }

    public void testLatLongWMS() throws Exception {
        Document document = this.getAsDOM("wms/reflect?format_options=encoding:latlong&format=application/rss+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Element element = document.getDocumentElement();
        RSSGeoRSSTransformerTest.assertEquals((String)"rss", (String)element.getNodeName());
        NodeList items = element.getElementsByTagName("item");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        RSSGeoRSSTransformerTest.assertEquals((int)n, (int)items.getLength());
        int i = 0;
        while (i < items.getLength()) {
            Element item = (Element)items.item(i);
            RSSGeoRSSTransformerTest.assertEquals((int)1, (int)item.getElementsByTagName("geo:lat").getLength());
            RSSGeoRSSTransformerTest.assertEquals((int)1, (int)item.getElementsByTagName("geo:long").getLength());
            ++i;
        }
    }

    public void testSimpleInternal() throws Exception {
        Document document;
        WMSMapContext map = new WMSMapContext(this.createGetMapRequest(MockData.BASIC_POLYGONS));
        map.addLayer(this.createMapLayer(MockData.BASIC_POLYGONS));
        try {
            document = this.getRSSResponse(map, GeoRSSTransformerBase.GeometryEncoding.SIMPLE);
        }
        finally {
            map.dispose();
        }
        Element element = document.getDocumentElement();
        RSSGeoRSSTransformerTest.assertEquals((String)"rss", (String)element.getNodeName());
        NodeList entries = element.getElementsByTagName("item");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        RSSGeoRSSTransformerTest.assertEquals((int)n, (int)entries.getLength());
        int i = 0;
        while (i < entries.getLength()) {
            Element entry = (Element)entries.item(i);
            RSSGeoRSSTransformerTest.assertEquals((int)1, (int)entry.getElementsByTagName("georss:polygon").getLength());
            ++i;
        }
    }

    public void testSimpleWMS() throws Exception {
        Document document = this.getAsDOM("wms/reflect?format_options=encoding:simple&format=application/rss+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Element element = document.getDocumentElement();
        RSSGeoRSSTransformerTest.assertEquals((String)"rss", (String)element.getNodeName());
        NodeList entries = element.getElementsByTagName("item");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        RSSGeoRSSTransformerTest.assertEquals((int)n, (int)entries.getLength());
        int i = 0;
        while (i < entries.getLength()) {
            Element entry = (Element)entries.item(i);
            RSSGeoRSSTransformerTest.assertEquals((int)1, (int)entry.getElementsByTagName("georss:polygon").getLength());
            ++i;
        }
    }

    public void testGmlWMS() throws Exception {
        Document document = this.getAsDOM("wms/reflect?format_options=encoding:gml&format=application/rss+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Element element = document.getDocumentElement();
        RSSGeoRSSTransformerTest.assertEquals((String)"rss", (String)element.getNodeName());
        NodeList entries = element.getElementsByTagName("item");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        RSSGeoRSSTransformerTest.assertEquals((int)n, (int)entries.getLength());
        int i = 0;
        while (i < entries.getLength()) {
            Element entry = (Element)entries.item(i);
            RSSGeoRSSTransformerTest.assertEquals((int)1, (int)entry.getElementsByTagName("gml:Polygon").getLength());
            ++i;
        }
    }

    public void testFilter() throws Exception {
        Document document;
        WMSMapContext map = new WMSMapContext(this.createGetMapRequest(MockData.BUILDINGS));
        try {
            MapLayer layer = this.createMapLayer(MockData.BUILDINGS);
            PropertyIsEqualTo f = this.ff.equals((Expression)this.ff.property("ADDRESS"), (Expression)this.ff.literal((Object)"215 Main Street"));
            layer.setQuery(new Query(MockData.BUILDINGS.getLocalPart(), (Filter)f));
            map.addLayer(layer);
            document = this.getRSSResponse(map, GeoRSSTransformerBase.GeometryEncoding.LATLONG);
        }
        finally {
            map.dispose();
        }
        NodeList items = document.getDocumentElement().getElementsByTagName("item");
        RSSGeoRSSTransformerTest.assertEquals((int)1, (int)items.getLength());
    }

    public void testReproject() throws Exception {
        Document document;
        WMSMapContext map = new WMSMapContext(this.createGetMapRequest(MockData.LINES));
        map.addLayer(this.createMapLayer(MockData.LINES));
        try {
            document = this.getRSSResponse(map, GeoRSSTransformerBase.GeometryEncoding.LATLONG);
        }
        finally {
            map.dispose();
        }
        NodeList items = document.getDocumentElement().getElementsByTagName("item");
        RSSGeoRSSTransformerTest.assertEquals((int)1, (int)items.getLength());
        int i = 0;
        while (i < items.getLength()) {
            Element item = (Element)items.item(i);
            double lat = Double.parseDouble(this.getOrdinate(item, "geo:lat"));
            double lon = Double.parseDouble(this.getOrdinate(item, "geo:long"));
            RSSGeoRSSTransformerTest.assertTrue((String)("Expected valid latitude value: " + lat), (lat >= -90.0 && lat <= 90.0 ? 1 : 0) != 0);
            RSSGeoRSSTransformerTest.assertTrue((String)("Expected valid longitude value: " + lon), (lon >= -180.0 && lon <= 180.0 ? 1 : 0) != 0);
            ++i;
        }
    }

    String getOrdinate(Element item, String ordinate) {
        return item.getElementsByTagName(ordinate).item(0).getChildNodes().item(0).getNodeValue();
    }

    Document getRSSResponse(WMSMapContext map, GeoRSSTransformerBase.GeometryEncoding encoding) throws TransformerException, ParserConfigurationException, FactoryConfigurationError, SAXException, IOException {
        RSSGeoRSSTransformer tx = new RSSGeoRSSTransformer(this.getWMS());
        tx.setGeometryEncoding(encoding);
        tx.setIndentation(2);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        tx.transform((Object)map, (OutputStream)output);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        return document;
    }
}

