/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import junit.framework.Test;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.GetLegendGraphic;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.legendgraphic.BufferedImageLegendGraphicBuilder;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;

public class AbstractLegendGraphicOutputFormatTest
extends WMSTestSupport {
    private static final Logger LOGGER = Logging.getLogger(AbstractLegendGraphicOutputFormatTest.class);
    private BufferedImageLegendGraphicBuilder legendProducer;
    GetLegendGraphic service;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new AbstractLegendGraphicOutputFormatTest());
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addCoverage(new QName("http://www.geo-solutions.it", "world", "gs"), MockData.class.getResource("world.tiff"), "tiff", "raster");
        dataDirectory.addStyle("rainfall", MockData.class.getResource("rainfall.sld"));
        dataDirectory.addStyle("rainfall_ramp", MockData.class.getResource("rainfall_ramp.sld"));
        dataDirectory.addStyle("rainfall_classes", MockData.class.getResource("rainfall_classes.sld"));
    }

    public void setUpInternal() throws Exception {
        super.setUpInternal();
        this.legendProducer = new BufferedImageLegendGraphicBuilder(){

            public String getContentType() {
                return "image/png";
            }
        };
        this.service = new GetLegendGraphic(this.getWMS());
    }

    public void tearDownInternal() throws Exception {
        this.legendProducer = null;
        super.tearDownInternal();
    }

    public void testUserSpecifiedRule() throws Exception {
        Style multipleRulesStyle = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle();
        AbstractLegendGraphicOutputFormatTest.assertNotNull((Object)multipleRulesStyle);
        Rule rule = multipleRulesStyle.getFeatureTypeStyles()[0].getRules()[0];
        LOGGER.info("testing single rule " + rule.getName() + " from style " + multipleRulesStyle.getName());
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(multipleRulesStyle);
        req.setRule(rule);
        req.setLegendOptions(new HashMap());
        int HEIGHT_HINT = 30;
        req.setHeight(30);
        this.legendProducer.buildLegendGraphic(req);
        BufferedImage image = this.legendProducer.buildLegendGraphic(req);
        this.assertNotBlank("testUserSpecifiedRule", image, LegendUtils.DEFAULT_BG_COLOR);
        String errMsg = "expected just one legend of height 30, for the rule " + rule.getName();
        int resultLegendCount = image.getHeight() / 30;
        AbstractLegendGraphicOutputFormatTest.assertEquals((String)errMsg, (int)1, (int)resultLegendCount);
    }

    public void testRainfall() throws Exception {
        Style multipleRulesStyle = this.getCatalog().getStyleByName("rainfall").getStyle();
        AbstractLegendGraphicOutputFormatTest.assertNotNull((Object)multipleRulesStyle);
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        AbstractLegendGraphicOutputFormatTest.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
        req.setLayer(feature.getSchema());
        req.setStyle(multipleRulesStyle);
        req.setLegendOptions(new HashMap());
        int HEIGHT_HINT = 30;
        req.setHeight(30);
        this.legendProducer.buildLegendGraphic(req);
        BufferedImage image = this.legendProducer.buildLegendGraphic(req);
        this.assertNotBlank("testRainfall", image, LegendUtils.DEFAULT_BG_COLOR);
        this.assertNotBlank("testRainfall", image, LegendUtils.DEFAULT_BG_COLOR);
    }

    public void testNoLayerProvidedAndNonStrictRequest() throws Exception {
        Style style = this.getCatalog().getStyleByName("rainfall").getStyle();
        AbstractLegendGraphicOutputFormatTest.assertNotNull((Object)style);
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        req.setStrict(false);
        req.setLayer(null);
        req.setStyle(style);
        int HEIGHT_HINT = 30;
        req.setHeight(30);
        this.legendProducer.buildLegendGraphic(req);
        BufferedImage image = this.legendProducer.buildLegendGraphic(req);
        this.assertNotBlank("testRainfall", image, LegendUtils.DEFAULT_BG_COLOR);
        this.assertNotBlank("testRainfall", image, LegendUtils.DEFAULT_BG_COLOR);
    }
}

