/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import junit.framework.Test;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.security.AccessMode;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.DataAccessManager;
import org.geoserver.security.DataAccessManagerAdapter;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSTestSupport;
import org.springframework.security.Authentication;

public class GetFeatureInfoRestrictedTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetFeatureInfoRestrictedTest());
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        DataAccessManager mockManager = (DataAccessManager)EasyMock.createMock(DataAccessManager.class);
        EasyMock.expect((Object)mockManager.canAccess((Authentication)EasyMock.anyObject(), (WorkspaceInfo)EasyMock.anyObject(), (AccessMode)EasyMock.eq((Object)AccessMode.READ))).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)mockManager.canAccess((Authentication)EasyMock.anyObject(), (WorkspaceInfo)EasyMock.anyObject(), (AccessMode)EasyMock.eq((Object)AccessMode.WRITE))).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)mockManager.canAccess((Authentication)EasyMock.anyObject(), (ResourceInfo)EasyMock.anyObject(), (AccessMode)EasyMock.eq((Object)AccessMode.READ))).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)mockManager.canAccess((Authentication)EasyMock.anyObject(), (ResourceInfo)EasyMock.anyObject(), (AccessMode)EasyMock.eq((Object)AccessMode.WRITE))).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)mockManager.canAccess((Authentication)EasyMock.anyObject(), (LayerInfo)EasyMock.anyObject(), (AccessMode)EasyMock.eq((Object)AccessMode.READ))).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)mockManager.canAccess((Authentication)EasyMock.anyObject(), (LayerInfo)EasyMock.anyObject(), (AccessMode)EasyMock.eq((Object)AccessMode.WRITE))).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)mockManager.getMode()).andReturn((Object)CatalogMode.HIDE).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockManager});
        this.getGeoServer().setCatalog((Catalog)new TestableSecureCatalogImpl(this.getGeoServer().getCatalog(), mockManager));
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
    }

    public void testRestrictedReprojection() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?SERVICE=WMS&REQUEST=GetFeatureInfo&EXCEPTIONS=application/vnd.ogc.se_xml&VERSION=1.1.1&BBOX=-0.002,-0.002,0.002,0.002&X=109&Y=204&INFO_FORMAT=text/html&QUERY_LAYERS=" + layer + "&FEATURE_COUNT=50&SRS=EPSG:4326&LAYERS=" + layer + "&STYLES=&WIDTH=256&HEIGHT=256&FORMAT=image/png";
        String result = this.getAsString(request);
        GetFeatureInfoRestrictedTest.assertNotNull((Object)result);
        GetFeatureInfoRestrictedTest.assertTrue((result.indexOf("ServiceExceptionReport") < 0 ? 1 : 0) != 0);
        GetFeatureInfoRestrictedTest.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    class TestableSecureCatalogImpl
    extends SecureCatalogImpl {
        public TestableSecureCatalogImpl(Catalog catalog, DataAccessManager manager) {
            super(catalog, (ResourceAccessManager)new DataAccessManagerAdapter(manager));
        }
    }
}

