/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.io.InputStream;
import junit.framework.Test;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;

public class GetStylesIntegrationTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetStylesIntegrationTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        Catalog catalog = this.getCatalog();
        String lakes = MockData.LAKES.getLocalPart();
        String forests = MockData.FORESTS.getLocalPart();
        String bridges = MockData.BRIDGES.getLocalPart();
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        lg.setName("lakesGroup");
        lg.getLayers().add(catalog.getLayerByName(lakes));
        lg.getStyles().add(catalog.getStyleByName(lakes));
        lg.getLayers().add(catalog.getLayerByName(forests));
        lg.getStyles().add(catalog.getStyleByName(forests));
        lg.getLayers().add(catalog.getLayerByName(bridges));
        lg.getStyles().add(catalog.getStyleByName(bridges));
        CatalogBuilder builder = new CatalogBuilder(catalog);
        builder.calculateLayerGroupBounds(lg);
        catalog.add(lg);
        LayerInfo lakesLayer = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        lakesLayer.getStyles().add(catalog.getStyleByName(MockData.FORESTS.getLocalPart()));
        catalog.save(lakesLayer);
    }

    public void testSimple() throws Exception {
        InputStream stream = this.get("wms?service=WMS&version=1.1.1&&request=GetStyles&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&sldver=1.0.0");
        SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory(null));
        parser.setInput(stream);
        StyledLayerDescriptor sld = parser.parseSLD();
        GetStylesIntegrationTest.assertEquals((int)1, (int)sld.getStyledLayers().length);
        NamedLayer layer = (NamedLayer)sld.getStyledLayers()[0];
        GetStylesIntegrationTest.assertEquals((String)this.getLayerId(MockData.BASIC_POLYGONS), (String)layer.getName());
        GetStylesIntegrationTest.assertEquals((int)1, (int)layer.styles().size());
        Style style = (Style)layer.styles().get(0);
        GetStylesIntegrationTest.assertTrue((boolean)style.isDefault());
        GetStylesIntegrationTest.assertEquals((String)"BasicPolygons", (String)style.getName());
    }

    public void testGroup() throws Exception {
        InputStream stream = this.get("wms?service=WMS&version=1.1.1&request=GetStyles&layers=lakesGroup&sldver=1.0.0");
        SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory(null));
        parser.setInput(stream);
        StyledLayerDescriptor sld = parser.parseSLD();
        GetStylesIntegrationTest.assertEquals((int)1, (int)sld.getStyledLayers().length);
        NamedLayer layer = (NamedLayer)sld.getStyledLayers()[0];
        GetStylesIntegrationTest.assertEquals((String)"lakesGroup", (String)layer.getName());
        GetStylesIntegrationTest.assertEquals((int)0, (int)layer.styles().size());
    }

    public void testMultiStyle() throws Exception {
        InputStream stream = this.get("wms?service=WMS&version=1.1.1&request=GetStyles&layers=" + this.getLayerId(MockData.LAKES) + "&sldver=1.0.0");
        SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory(null));
        parser.setInput(stream);
        StyledLayerDescriptor sld = parser.parseSLD();
        GetStylesIntegrationTest.assertEquals((int)1, (int)sld.getStyledLayers().length);
        NamedLayer layer = (NamedLayer)sld.getStyledLayers()[0];
        GetStylesIntegrationTest.assertEquals((String)this.getLayerId(MockData.LAKES), (String)layer.getName());
        GetStylesIntegrationTest.assertEquals((int)2, (int)layer.styles().size());
        Style style = (Style)layer.styles().get(0);
        GetStylesIntegrationTest.assertTrue((boolean)style.isDefault());
        GetStylesIntegrationTest.assertEquals((String)"Lakes", (String)style.getName());
        style = (Style)layer.styles().get(1);
        GetStylesIntegrationTest.assertFalse((boolean)style.isDefault());
        GetStylesIntegrationTest.assertEquals((String)"Forests", (String)style.getName());
    }
}

