/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.mockrunner.mock.web.MockHttpServletResponse;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.io.WKTReader;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.TestResourceAccessManager;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.test.RemoteOWSTestSupport;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAccessManagerWMSTest
extends WMSTestSupport {
    static final Logger LOGGER = Logging.getLogger(ResourceAccessManagerWMSTest.class);
    static final String BASE = "wms?SERVICE=WMS&VERSION=1.1.1&HEIGHT=330&WIDTH=780&LAYERS=rstates&STYLES=&FORMAT=image%2Fpng&SRS=EPSG%3A4326&BBOX=-139.84813671875,18.549615234375,-51.85286328125,55.778384765625";
    static final String GET_MAP = "wms?SERVICE=WMS&VERSION=1.1.1&HEIGHT=330&WIDTH=780&LAYERS=rstates&STYLES=&FORMAT=image%2Fpng&SRS=EPSG%3A4326&BBOX=-139.84813671875,18.549615234375,-51.85286328125,55.778384765625&REQUEST=GetMap";
    static final String BASE_GET_FEATURE_INFO = "wms?SERVICE=WMS&VERSION=1.1.1&HEIGHT=330&WIDTH=780&LAYERS=rstates&STYLES=&FORMAT=image%2Fpng&SRS=EPSG%3A4326&BBOX=-139.84813671875,18.549615234375,-51.85286328125,55.778384765625&REQUEST=GetFeatureInfo&QUERY_LAYERS=rstates&INFO_FORMAT=text/plain";
    static final String GET_FEATURE_INFO_CALIFORNIA = "wms?SERVICE=WMS&VERSION=1.1.1&HEIGHT=330&WIDTH=780&LAYERS=rstates&STYLES=&FORMAT=image%2Fpng&SRS=EPSG%3A4326&BBOX=-139.84813671875,18.549615234375,-51.85286328125,55.778384765625&REQUEST=GetFeatureInfo&QUERY_LAYERS=rstates&INFO_FORMAT=text/plain&X=191&Y=178";
    static final String GET_FEATURE_INFO_TEXAS = "wms?SERVICE=WMS&VERSION=1.1.1&HEIGHT=330&WIDTH=780&LAYERS=rstates&STYLES=&FORMAT=image%2Fpng&SRS=EPSG%3A4326&BBOX=-139.84813671875,18.549615234375,-51.85286328125,55.778384765625&REQUEST=GetFeatureInfo&QUERY_LAYERS=rstates&INFO_FORMAT=text/plain&X=368&Y=227";

    protected String[] getSpringContextLocations() {
        String[] base = super.getSpringContextLocations();
        String[] extended = new String[base.length + 1];
        System.arraycopy(base, 0, extended, 0, base.length);
        extended[base.length] = "classpath:/org/geoserver/wms/ResourceAccessManagerContext.xml";
        return extended;
    }

    protected List<javax.servlet.Filter> getFilters() {
        return Collections.singletonList((javax.servlet.Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    @Override
    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        URL style = MockData.class.getResource("raster.sld");
        dataDirectory.addStyle("raster", style);
        dataDirectory.addCoverage(new QName(MockData.SF_URI, "mosaic", MockData.SF_PREFIX), ((Object)((Object)this)).getClass().getResource("raster-filter-test.zip"), null, "raster");
        File security = new File(dataDirectory.getDataDirectoryRoot(), "security");
        security.mkdir();
        File users = new File(security, "users.properties");
        Properties props = new Properties();
        props.put("admin", "geoserver,ROLE_ADMINISTRATOR");
        props.put("cite", "cite,ROLE_DUMMY");
        props.put("cite_nostates", "cite,ROLE_DUMMY");
        props.put("cite_noinfo", "cite,ROLE_DUMMY");
        props.put("cite_texas", "cite,ROLE_DUMMY");
        props.put("cite_mosaic1", "cite,ROLE_DUMMY");
        props.put("cite_mosaic2", "cite,ROLE_DUMMY");
        props.store(new FileOutputStream(users), "");
    }

    @Override
    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        Catalog catalog = this.getCatalog();
        TestResourceAccessManager tam = (TestResourceAccessManager)applicationContext.getBean("testResourceAccessManager");
        CoverageInfo coverage = catalog.getCoverageByName("sf:mosaic");
        Filter green = CQL.toFilter((String)"location like 'green%'");
        tam.putLimits("cite_mosaic1", (CatalogInfo)coverage, (AccessLimits)new CoverageAccessLimits(CatalogMode.HIDE, green, null, null));
        WKTReader wkt = new WKTReader();
        MultiPolygon cropper = (MultiPolygon)wkt.read("MULTIPOLYGON(((0 0, 0.5 0, 0.5 0.5, 0 0.5, 0 0)))");
        tam.putLimits("cite_mosaic2", (CatalogInfo)coverage, (AccessLimits)new CoverageAccessLimits(CatalogMode.HIDE, green, cropper, null));
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        CatalogBuilder cb = new CatalogBuilder(catalog);
        WMSStoreInfo wms = cb.buildWMSStore("demo");
        wms.setCapabilitiesURL("http://demo.opengeo.org/geoserver/wms?service=WMS&request=GetCapabilities");
        catalog.save((StoreInfo)wms);
        cb.setStore((StoreInfo)wms);
        WMSLayerInfo states = cb.buildWMSLayer("topp:states");
        states.setName("rstates");
        catalog.add((ResourceInfo)states);
        LayerInfo layer = cb.buildLayer(states);
        catalog.add(layer);
        tam.putLimits("cite_nostates", (CatalogInfo)states, (AccessLimits)new WMSAccessLimits(CatalogMode.HIDE, (Filter)Filter.EXCLUDE, null, false));
        tam.putLimits("cite_noinfo", (CatalogInfo)states, (AccessLimits)new WMSAccessLimits(CatalogMode.HIDE, (Filter)Filter.INCLUDE, null, false));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo texas = ff.equal((Expression)ff.property("STATE_NAME"), (Expression)ff.literal((Object)"Texas"), false);
        tam.putLimits("cite_texas", (CatalogInfo)states, (AccessLimits)new WMSAccessLimits(CatalogMode.HIDE, (Filter)texas, null, true));
    }

    public void testGetMapNoRestrictions() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testNoRestrictions");
            return;
        }
        this.authenticate("cite", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(GET_MAP);
        ResourceAccessManagerWMSTest.assertEquals((String)"image/png", (String)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        ResourceAccessManagerWMSTest.assertNotNull((Object)image);
        this.assertNotBlank("testNoRestrictions", image);
        int[] pixel = new int[4];
        image.getData().getPixel(368, 227, pixel);
        ResourceAccessManagerWMSTest.assertEquals((int)77, (int)pixel[0]);
        ResourceAccessManagerWMSTest.assertEquals((int)77, (int)pixel[1]);
        ResourceAccessManagerWMSTest.assertEquals((int)255, (int)pixel[2]);
        image.getData().getPixel(191, 178, pixel);
        ResourceAccessManagerWMSTest.assertEquals((int)77, (int)pixel[0]);
        ResourceAccessManagerWMSTest.assertEquals((int)77, (int)pixel[1]);
        ResourceAccessManagerWMSTest.assertEquals((int)255, (int)pixel[2]);
    }

    public void testGetMapDisallowed() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testGetMapDisallowed");
            return;
        }
        this.authenticate("cite_nostates", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(GET_MAP);
        ResourceAccessManagerWMSTest.assertEquals((String)"application/vnd.ogc.se_xml", (String)response.getContentType());
        Document dom = this.dom(this.getBinaryInputStream(response));
        XMLAssert.assertXpathEvaluatesTo((String)"LayerNotDefined", (String)"//ServiceException/@code", (Document)dom);
    }

    public void testGetMapFiltered() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testGetMapFiltered");
            return;
        }
        this.authenticate("cite_texas", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(GET_MAP);
        ResourceAccessManagerWMSTest.assertEquals((String)"image/png", (String)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        ResourceAccessManagerWMSTest.assertNotNull((Object)image);
        this.assertNotBlank("testGetMapFiltered", image);
        int[] pixel = new int[4];
        image.getData().getPixel(368, 227, pixel);
        ResourceAccessManagerWMSTest.assertEquals((int)77, (int)pixel[0]);
        ResourceAccessManagerWMSTest.assertEquals((int)77, (int)pixel[1]);
        ResourceAccessManagerWMSTest.assertEquals((int)255, (int)pixel[2]);
        image.getData().getPixel(191, 178, pixel);
        ResourceAccessManagerWMSTest.assertEquals((int)255, (int)pixel[0]);
        ResourceAccessManagerWMSTest.assertEquals((int)255, (int)pixel[1]);
        ResourceAccessManagerWMSTest.assertEquals((int)255, (int)pixel[2]);
    }

    public void testGetFeatureInfoNoRestrictions() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testNoRestrictions");
            return;
        }
        this.authenticate("cite", "cite");
        String texas = this.getAsString(GET_FEATURE_INFO_TEXAS);
        ResourceAccessManagerWMSTest.assertTrue((boolean)texas.contains("STATE_NAME = Texas"));
        String california = this.getAsString(GET_FEATURE_INFO_CALIFORNIA);
        ResourceAccessManagerWMSTest.assertTrue((boolean)california.contains("STATE_NAME = California"));
    }

    public void testGetFeatureInfoDisallowedLayer() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testNoRestrictions");
            return;
        }
        this.authenticate("cite_nostates", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(GET_FEATURE_INFO_TEXAS);
        ResourceAccessManagerWMSTest.assertEquals((String)"application/vnd.ogc.se_xml", (String)response.getContentType());
        Document dom = this.dom(this.getBinaryInputStream(response));
        XMLAssert.assertXpathEvaluatesTo((String)"LayerNotDefined", (String)"//ServiceException/@code", (Document)dom);
    }

    public void testGetFeatureInfoDisallowedInfo() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testNoRestrictions");
            return;
        }
        this.authenticate("cite_noinfo", "cite");
        MockHttpServletResponse response = this.getAsServletResponse(GET_FEATURE_INFO_TEXAS);
        ResourceAccessManagerWMSTest.assertEquals((String)"application/vnd.ogc.se_xml", (String)response.getContentType());
        Document dom = this.dom(this.getBinaryInputStream(response));
        XMLAssert.assertXpathEvaluatesTo((String)"OperationNotSupported", (String)"//ServiceException/@code", (Document)dom);
    }

    public void testGetFeatureInfoFiltered() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWMSStatesAvailable((Logger)LOGGER)) {
            LOGGER.log(Level.WARNING, "Skipping testNoRestrictions");
            return;
        }
        this.authenticate("cite_texas", "cite");
        String texas = this.getAsString(GET_FEATURE_INFO_TEXAS);
        ResourceAccessManagerWMSTest.assertTrue((boolean)texas.contains("STATE_NAME = Texas"));
        String california = this.getAsString(GET_FEATURE_INFO_CALIFORNIA);
        ResourceAccessManagerWMSTest.assertTrue((boolean)california.contains("no features were found"));
    }

    public void testDoubleMosaic() throws Exception {
        this.authenticate("cite_mosaic1", "cite");
        String path = "wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false";
        MockHttpServletResponse response = this.getAsServletResponse(path);
        ResourceAccessManagerWMSTest.assertEquals((String)"image/png", (String)response.getContentType());
        response = this.getAsServletResponse(path);
        ResourceAccessManagerWMSTest.assertEquals((String)"image/png", (String)response.getContentType());
    }

    public void testRasterFilterGreen() throws Exception {
        this.authenticate("cite_mosaic1", "cite");
        MockHttpServletResponse response = this.getAsServletResponse("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false");
        ResourceAccessManagerWMSTest.assertEquals((String)"image/png", (String)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        int[] pixel = new int[3];
        image.getData().getPixel(0, 0, pixel);
        ResourceAccessManagerWMSTest.assertEquals((int)0, (int)pixel[0]);
        ResourceAccessManagerWMSTest.assertEquals((int)255, (int)pixel[1]);
        ResourceAccessManagerWMSTest.assertEquals((int)0, (int)pixel[2]);
    }

    public void testRasterCrop() throws Exception {
        this.authenticate("cite_mosaic2", "cite");
        MockHttpServletResponse response = this.getAsServletResponse("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false");
        ResourceAccessManagerWMSTest.assertEquals((String)"image/png", (String)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        int[] pixel = new int[3];
        image.getData().getPixel(0, 149, pixel);
        ResourceAccessManagerWMSTest.assertEquals((int)0, (int)pixel[0]);
        ResourceAccessManagerWMSTest.assertEquals((int)255, (int)pixel[1]);
        ResourceAccessManagerWMSTest.assertEquals((int)0, (int)pixel[2]);
        image.getData().getPixel(149, 149, pixel);
        ResourceAccessManagerWMSTest.assertEquals((int)0, (int)pixel[0]);
        ResourceAccessManagerWMSTest.assertEquals((int)0, (int)pixel[1]);
        ResourceAccessManagerWMSTest.assertEquals((int)0, (int)pixel[2]);
    }
}

