/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.animate;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.RenderedImageList;
import javax.xml.namespace.QName;
import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.WebMapService;
import org.geoserver.wms.animate.FrameCatalog;
import org.geoserver.wms.animate.FrameCatalogVisitor;

public class AnimatorTest
extends WMSTestSupport {
    public static final String GIF_ANIMATED_FORMAT = "image/gif;subtype=animated";

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new AnimatorTest());
    }

    public void testFrameCatalog() throws Exception {
        WebMapService wms = (WebMapService)applicationContext.getBean("wmsService2");
        String layerName = String.valueOf(MockData.BASIC_POLYGONS.getPrefix()) + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        GetMapRequest getMapRequest = this.createGetMapRequest(new QName(layerName));
        FrameCatalog catalog = null;
        try {
            catalog = new FrameCatalog(getMapRequest, wms, this.getWMS());
        }
        catch (RuntimeException e) {
            AnimatorTest.assertEquals((String)"Missing \"animator\" mandatory params \"aparam\" and \"avalues\".", (String)e.getLocalizedMessage());
        }
        getMapRequest.getRawKvp().put("aparam", "fake_param");
        getMapRequest.getRawKvp().put("avalues", "val0,val\\,1,val2\\,\\,,val3");
        catalog = new FrameCatalog(getMapRequest, wms, this.getWMS());
        AnimatorTest.assertNotNull((Object)catalog);
        AnimatorTest.assertEquals((String)"fake_param", (String)catalog.getParameter());
        AnimatorTest.assertEquals((int)4, (int)catalog.getValues().length);
        AnimatorTest.assertEquals((String)"val0", (String)catalog.getValues()[0]);
        AnimatorTest.assertEquals((String)"val\\,1", (String)catalog.getValues()[1]);
        AnimatorTest.assertEquals((String)"val2\\,\\,", (String)catalog.getValues()[2]);
        AnimatorTest.assertEquals((String)"val3", (String)catalog.getValues()[3]);
    }

    public void testFrameVisitor() throws Exception {
        WebMapService wms = (WebMapService)applicationContext.getBean("wmsService2");
        String layerName = String.valueOf(MockData.BASIC_POLYGONS.getPrefix()) + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        GetMapRequest getMapRequest = this.createGetMapRequest(new QName(layerName));
        FrameCatalog catalog = null;
        getMapRequest.getRawKvp().put("aparam", "fake_param");
        getMapRequest.getRawKvp().put("avalues", "val0,val\\,1,val2\\,\\,,val3");
        getMapRequest.getRawKvp().put("format", GIF_ANIMATED_FORMAT);
        getMapRequest.getRawKvp().put("LAYERS", layerName);
        catalog = new FrameCatalog(getMapRequest, wms, this.getWMS());
        AnimatorTest.assertNotNull((Object)catalog);
        FrameCatalogVisitor visitor = new FrameCatalogVisitor();
        catalog.getFrames(visitor);
        AnimatorTest.assertEquals((int)4, (int)visitor.framesNumber);
        RenderedImageList frames = visitor.produce(this.getWMS());
        AnimatorTest.assertNotNull((Object)frames);
        AnimatorTest.assertEquals((int)4, (int)frames.size());
    }

    public void testAnimator() throws Exception {
        String layerName = String.valueOf(MockData.BASIC_POLYGONS.getPrefix()) + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String requestURL = "wms/animate?layers=" + layerName + "&aparam=fake_param&avalues=val0,val\\,1,val2\\,\\,,val3";
        MockHttpServletResponse resp = this.getAsServletResponse(requestURL);
        AnimatorTest.assertEquals((String)"image/gif", (String)resp.getContentType());
    }

    public void testAnimatorLayers() throws Exception {
        String layerName = String.valueOf(MockData.BASIC_POLYGONS.getPrefix()) + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String requestURL = "cite/wms/animate?&aparam=layers&avalues=MapNeatline,Buildings,Lakes";
        MockHttpServletResponse resp = this.getAsServletResponse(requestURL);
        AnimatorTest.assertEquals((String)"image/gif", (String)resp.getContentType());
        ByteArrayInputStream bis = this.getBinaryInputStream(resp);
        ImageInputStream iis = ImageIO.createImageInputStream(bis);
        ImageReader reader = ImageIO.getImageReadersBySuffix("gif").next();
        reader.setInput(iis);
        AnimatorTest.assertEquals((int)3, (int)reader.getNumImages(true));
    }
}

