/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.ContactInfoImpl;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.wms.ExtendedCapabilitiesProvider;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSInfoImpl;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.capabilities.GetCapabilitiesTransformer;
import org.geotools.referencing.CRS;
import org.geotools.xml.transform.TransformerBase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.NamespaceSupport;

public class GetCapabilitiesTransformerTest
extends TestCase {
    private XpathEngine XPATH;
    private static final String baseUrl = "http://localhost/geoserver";
    private static final Set<String> mapFormats = Collections.singleton("image/png");
    private static final Set<String> legendFormats = Collections.singleton("image/png");
    private GeoServerImpl geosConfig;
    private GeoServerInfoImpl geosInfo;
    private WMSInfoImpl wmsInfo;
    private CatalogImpl catalog;
    private GetCapabilitiesRequest req;
    private WMS wmsConfig;

    protected void setUp() throws Exception {
        this.geosConfig = new GeoServerImpl();
        this.geosInfo = new GeoServerInfoImpl((GeoServer)this.geosConfig);
        this.geosInfo.setContact((ContactInfo)new ContactInfoImpl());
        this.geosConfig.setGlobal((GeoServerInfo)this.geosInfo);
        this.wmsInfo = new WMSInfoImpl();
        this.geosConfig.add((ServiceInfo)this.wmsInfo);
        this.catalog = new CatalogImpl();
        this.geosConfig.setCatalog((Catalog)this.catalog);
        this.wmsConfig = new WMS((GeoServer)this.geosConfig);
        this.req = new GetCapabilitiesRequest();
        this.req.setBaseUrl(baseUrl);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        this.XPATH = XMLUnit.newXpathEngine();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testHeader() throws Exception {
        GetCapabilitiesTransformer tr = new GetCapabilitiesTransformer(this.wmsConfig, baseUrl, mapFormats, legendFormats, null);
        StringWriter writer = new StringWriter();
        tr.transform((Object)this.req, (Writer)writer);
        String content = writer.getBuffer().toString();
        GetCapabilitiesTransformerTest.assertTrue((boolean)content.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        String dtdDef = "<!DOCTYPE WMT_MS_Capabilities SYSTEM \"http://localhost/geoserver/schemas/wms/1.1.1/WMS_MS_Capabilities.dtd\">";
        GetCapabilitiesTransformerTest.assertTrue((boolean)content.contains(dtdDef));
    }

    public void testRootElement() throws Exception {
        GetCapabilitiesTransformer tr = new GetCapabilitiesTransformer(this.wmsConfig, baseUrl, mapFormats, legendFormats, null);
        Document dom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        Element root = dom.getDocumentElement();
        GetCapabilitiesTransformerTest.assertEquals((String)"WMT_MS_Capabilities", (String)root.getNodeName());
        GetCapabilitiesTransformerTest.assertEquals((String)"1.1.1", (String)root.getAttribute("version"));
        GetCapabilitiesTransformerTest.assertEquals((String)"0", (String)root.getAttribute("updateSequence"));
        this.geosInfo.setUpdateSequence(10L);
        tr = new GetCapabilitiesTransformer(this.wmsConfig, baseUrl, mapFormats, legendFormats, null);
        dom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        root = dom.getDocumentElement();
        GetCapabilitiesTransformerTest.assertEquals((String)"10", (String)root.getAttribute("updateSequence"));
    }

    public void testServiceSection() throws Exception {
        this.wmsInfo.setTitle("title");
        this.wmsInfo.setAbstract("abstract");
        this.wmsInfo.getKeywords().add(new Keyword("k1"));
        this.wmsInfo.getKeywords().add(new Keyword("k2"));
        this.wmsInfo.setOnlineResource("http://onlineresource/fake");
        ContactInfoImpl contactInfo = new ContactInfoImpl();
        this.geosInfo.setContact((ContactInfo)contactInfo);
        contactInfo.setContactPerson("contactPerson");
        contactInfo.setContactOrganization("contactOrganization");
        contactInfo.setContactPosition("contactPosition");
        contactInfo.setAddress("address");
        contactInfo.setAddressType("addressType");
        contactInfo.setAddressCity("city");
        contactInfo.setAddressState("state");
        contactInfo.setAddressPostalCode("postCode");
        contactInfo.setAddressCountry("country");
        contactInfo.setContactVoice("voice");
        contactInfo.setContactEmail("email");
        contactInfo.setContactFacsimile("fax");
        this.wmsInfo.setFees("fees");
        this.wmsInfo.setAccessConstraints("accessConstraints");
        GetCapabilitiesTransformer tr = new GetCapabilitiesTransformer(this.wmsConfig, baseUrl, mapFormats, legendFormats, null);
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        String service = "/WMT_MS_Capabilities/Service";
        XMLAssert.assertXpathEvaluatesTo((String)"OGC:WMS", (String)(String.valueOf(service) + "/Name"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"title", (String)(String.valueOf(service) + "/Title"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"abstract", (String)(String.valueOf(service) + "/Abstract"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"k1", (String)(String.valueOf(service) + "/KeywordList/Keyword[1]"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"k2", (String)(String.valueOf(service) + "/KeywordList/Keyword[2]"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)this.wmsInfo.getOnlineResource(), (String)(String.valueOf(service) + "/OnlineResource/@xlink:href"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"contactPerson", (String)(String.valueOf(service) + "/ContactInformation/ContactPersonPrimary/ContactPerson"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"contactOrganization", (String)(String.valueOf(service) + "/ContactInformation/ContactPersonPrimary/ContactOrganization"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"contactPosition", (String)(String.valueOf(service) + "/ContactInformation/ContactPosition"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"address", (String)(String.valueOf(service) + "/ContactInformation/ContactAddress/Address"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"addressType", (String)(String.valueOf(service) + "/ContactInformation/ContactAddress/AddressType"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"city", (String)(String.valueOf(service) + "/ContactInformation/ContactAddress/City"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"state", (String)(String.valueOf(service) + "/ContactInformation/ContactAddress/StateOrProvince"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"postCode", (String)(String.valueOf(service) + "/ContactInformation/ContactAddress/PostCode"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"country", (String)(String.valueOf(service) + "/ContactInformation/ContactAddress/Country"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"voice", (String)(String.valueOf(service) + "/ContactInformation/ContactVoiceTelephone"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"fax", (String)(String.valueOf(service) + "/ContactInformation/ContactFacsimileTelephone"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"email", (String)(String.valueOf(service) + "/ContactInformation/ContactElectronicMailAddress"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"fees", (String)(String.valueOf(service) + "/Fees"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"accessConstraints", (String)(String.valueOf(service) + "/AccessConstraints"), (Document)dom);
    }

    public void testCRSList() throws Exception {
        GetCapabilitiesTransformer tr = new GetCapabilitiesTransformer(this.wmsConfig, baseUrl, mapFormats, legendFormats, null);
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        Set supportedCodes = CRS.getSupportedCodes((String)"EPSG");
        supportedCodes.addAll(CRS.getSupportedCodes((String)"AUTO"));
        NodeList allCrsCodes = this.XPATH.getMatchingNodes("/WMT_MS_Capabilities/Capability/Layer/SRS", dom);
        GetCapabilitiesTransformerTest.assertEquals((int)supportedCodes.size(), (int)allCrsCodes.getLength());
    }

    public void testLimitedCRSList() throws Exception {
        this.wmsInfo.getSRS().add("EPSG:3246");
        this.wmsInfo.getSRS().add("EPSG:23030");
        GetCapabilitiesTransformer tr = new GetCapabilitiesTransformer(this.wmsConfig, baseUrl, mapFormats, legendFormats, null);
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        NodeList limitedCrsCodes = this.XPATH.getMatchingNodes("/WMT_MS_Capabilities/Capability/Layer/SRS", dom);
        GetCapabilitiesTransformerTest.assertEquals((int)2, (int)limitedCrsCodes.getLength());
    }

    public void testVendorSpecificCapabilities() throws Exception {
        ExtendedCapabilitiesProvider vendorCapsProvider = new ExtendedCapabilitiesProvider(){

            public String[] getSchemaLocations(String schemaBaseURL) {
                throw new UnsupportedOperationException();
            }

            public void registerNamespaces(NamespaceSupport namespaces) {
                throw new UnsupportedOperationException();
            }

            public List<String> getVendorSpecificCapabilitiesRoots(GetCapabilitiesRequest request) {
                return Collections.singletonList("TestElement?");
            }

            public List<String> getVendorSpecificCapabilitiesChildDecls(GetCapabilitiesRequest request) {
                return Collections.singletonList("<!ELEMENT TestSubElement (#PCDATA) >");
            }

            public void encode(ExtendedCapabilitiesProvider.Translator tx, WMSInfo wms, GetCapabilitiesRequest request) throws IOException {
                tx.start("TestElement");
                tx.start("TestSubElement");
                tx.end("TestSubElement");
                tx.end("TestElement");
            }
        };
        GetCapabilitiesTransformer tr = new GetCapabilitiesTransformer(this.wmsConfig, baseUrl, mapFormats, legendFormats, Collections.singletonList(vendorCapsProvider));
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, (TransformerBase)tr);
        NodeList list = this.XPATH.getMatchingNodes("/WMT_MS_Capabilities/Capability/VendorSpecificCapabilities/TestElement", dom);
        GetCapabilitiesTransformerTest.assertEquals((int)1, (int)list.getLength());
        list = this.XPATH.getMatchingNodes("/WMT_MS_Capabilities/Capability/VendorSpecificCapabilities/TestElement/TestSubElement", dom);
        GetCapabilitiesTransformerTest.assertEquals((int)1, (int)list.getLength());
    }
}

