/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.decoration;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Map;
import junit.framework.TestCase;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.decoration.MapDecoration;
import org.geoserver.wms.decoration.MapDecorationLayout;

public class MapDecorationLayoutTest
extends TestCase {
    private Graphics2D createMockGraphics(int x, int y) {
        BufferedImage b = new BufferedImage(x, y, 1);
        return (Graphics2D)b.getGraphics();
    }

    public void testStaticSize() throws Exception {
        Graphics2D g2d = this.createMockGraphics(256, 256);
        MapDecorationLayout dl = new MapDecorationLayout();
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(100, 100), new Rectangle(156, 78, 100, 100)), MapDecorationLayout.Block.Position.CR, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(100, 100), new Rectangle(206, 103, 50, 50)), MapDecorationLayout.Block.Position.CR, new Dimension(50, 50), new Point(0, 0)));
        dl.paint(g2d, new Rectangle(0, 0, 256, 256), null);
    }

    public void testSquished() throws Exception {
        Graphics2D g2d = this.createMockGraphics(100, 100);
        MapDecorationLayout dl = new MapDecorationLayout();
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(150, 100), new Rectangle(0, 0, 100, 100)), MapDecorationLayout.Block.Position.CR, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(100, 150), new Rectangle(0, 0, 100, 100)), MapDecorationLayout.Block.Position.CR, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(150, 150), new Rectangle(0, 0, 100, 100)), MapDecorationLayout.Block.Position.CR, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(150, 150), new Rectangle(0, 0, 100, 100)), MapDecorationLayout.Block.Position.CR, new Dimension(100, 150), new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(150, 150), new Rectangle(0, 0, 100, 100)), MapDecorationLayout.Block.Position.CR, new Dimension(150, 100), new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(150, 150), new Rectangle(0, 0, 100, 100)), MapDecorationLayout.Block.Position.CR, new Dimension(150, 150), new Point(0, 0)));
        dl.paint(g2d, new Rectangle(0, 0, 100, 100), null);
    }

    public void testPosition() {
        Graphics2D g2d = this.createMockGraphics(100, 100);
        MapDecorationLayout dl = new MapDecorationLayout();
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(0, 0, 10, 10)), MapDecorationLayout.Block.Position.UL, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(45, 0, 10, 10)), MapDecorationLayout.Block.Position.UC, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(90, 0, 10, 10)), MapDecorationLayout.Block.Position.UR, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(0, 45, 10, 10)), MapDecorationLayout.Block.Position.CL, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(45, 45, 10, 10)), MapDecorationLayout.Block.Position.CC, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(90, 45, 10, 10)), MapDecorationLayout.Block.Position.CR, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(0, 90, 10, 10)), MapDecorationLayout.Block.Position.LL, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(45, 90, 10, 10)), MapDecorationLayout.Block.Position.LC, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(90, 90, 10, 10)), MapDecorationLayout.Block.Position.LR, null, new Point(0, 0)));
        dl.paint(g2d, new Rectangle(0, 0, 100, 100), null);
    }

    public void testOffset() {
        Graphics2D g2d = this.createMockGraphics(100, 100);
        MapDecorationLayout dl = new MapDecorationLayout();
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(10, 10, 10, 10)), MapDecorationLayout.Block.Position.UL, null, new Point(10, 10)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(45, 10, 10, 10)), MapDecorationLayout.Block.Position.UC, null, new Point(10, 10)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(80, 10, 10, 10)), MapDecorationLayout.Block.Position.UR, null, new Point(10, 10)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(10, 45, 10, 10)), MapDecorationLayout.Block.Position.CL, null, new Point(10, 10)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(45, 45, 10, 10)), MapDecorationLayout.Block.Position.CC, null, new Point(10, 10)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(80, 45, 10, 10)), MapDecorationLayout.Block.Position.CR, null, new Point(10, 10)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(10, 80, 10, 10)), MapDecorationLayout.Block.Position.LL, null, new Point(10, 10)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(45, 80, 10, 10)), MapDecorationLayout.Block.Position.LC, null, new Point(10, 10)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(80, 80, 10, 10)), MapDecorationLayout.Block.Position.LR, null, new Point(10, 10)));
        dl.paint(g2d, new Rectangle(0, 0, 100, 100), null);
    }

    public void testTopCenter() {
        Graphics2D g2d = this.createMockGraphics(100, 100);
        MapDecorationLayout dl = new MapDecorationLayout();
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(50, 10), new Rectangle(25, 10, 50, 10)), MapDecorationLayout.Block.Position.UC, null, new Point(0, 10)));
        dl.paint(g2d, new Rectangle(0, 0, 100, 100), null);
    }

    public void testResetGraphics() {
        Graphics2D g2d = this.createMockGraphics(100, 100);
        MapDecorationLayout dl = new MapDecorationLayout();
        dl.addBlock(new MapDecorationLayout.Block(new MapDecoration(){

            public void paint(Graphics2D g2d, Rectangle paintArea, WMSMapContext context) throws Exception {
                AlphaComposite c = (AlphaComposite)g2d.getComposite();
                MapDecorationLayoutTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(c.getAlpha()));
            }

            public void loadOptions(Map<String, String> options) throws Exception {
            }

            public Dimension findOptimalSize(Graphics2D g2d, WMSMapContext mapContent) throws Exception {
                return new Dimension(10, 10);
            }
        }, MapDecorationLayout.Block.Position.UC, null, new Point(0, 10)));
        dl.paint(g2d, new Rectangle(0, 0, 100, 100), null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MockMapDecoration
    implements MapDecoration {
        Dimension request;
        Rectangle expect;

        public MockMapDecoration(Dimension toRequest, Rectangle toExpect) {
            this.request = toRequest;
            this.expect = toExpect;
        }

        public void loadOptions(Map<String, String> options) {
        }

        public Dimension findOptimalSize(Graphics2D g2d, WMSMapContext mapContext) {
            return this.request;
        }

        public void paint(Graphics2D g2d, Rectangle paintArea, WMSMapContext mapContext) throws Exception {
            MapDecorationLayoutTest.assertEquals((String)"Calculated width matches expected", (int)this.expect.width, (int)paintArea.width);
            MapDecorationLayoutTest.assertEquals((String)"Calculated height matches expected", (int)this.expect.height, (int)paintArea.height);
            MapDecorationLayoutTest.assertEquals((String)"Calculated x matches expected", (int)this.expect.x, (int)paintArea.x);
            MapDecorationLayoutTest.assertEquals((String)"Calculated y matches expected", (int)this.expect.y, (int)paintArea.y);
        }
    }
}

