/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import com.mockrunner.mock.web.MockHttpServletResponse;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.test.GeoServerTestSupport;
import org.w3c.dom.Document;

public class CapabilitiesModifyingTest
extends GeoServerTestSupport {
    public void testMisconfiguredLayerGeneratesErrorDocumentInDefaultConfig() throws Exception {
        for (FeatureTypeInfo ft : this.getCatalog().getFeatureTypes()) {
            ft.setLatLonBoundingBox(null);
            this.getCatalog().save((ResourceInfo)ft);
        }
        MockHttpServletResponse response = this.getAsServletResponse("wms?service=WMS&request=GetCapabilities&version=1.1.1");
        CapabilitiesModifyingTest.assertTrue((String)("Response does not contain ServiceExceptionReport: " + response.getOutputStreamContent()), (boolean)response.getOutputStreamContent().endsWith("</ServiceExceptionReport>"));
    }

    public void testMisconfiguredLayerIsSkippedWhenWMSServiceIsConfiguredThatWay() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setResourceErrorHandling(ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS);
        this.getGeoServer().save(global);
        for (FeatureTypeInfo ft : this.getCatalog().getFeatureTypes()) {
            ft.setLatLonBoundingBox(null);
            this.getCatalog().save((ResourceInfo)ft);
        }
        Document caps = this.getAsDOM("wms?service=WMS&request=GetCapabilities&version=1.1.1");
        CapabilitiesModifyingTest.assertEquals((String)"WMT_MS_Capabilities", (String)caps.getDocumentElement().getTagName());
        XMLAssert.assertXpathEvaluatesTo((String)"", (String)"//Layer/Name/text()", (Document)caps);
    }

    public void testMisconfiguredLayerGeneratesErrorDocumentInDefaultConfig_1_3_0() throws Exception {
        for (FeatureTypeInfo ft : this.getCatalog().getFeatureTypes()) {
            ft.setLatLonBoundingBox(null);
            this.getCatalog().save((ResourceInfo)ft);
        }
        MockHttpServletResponse response = this.getAsServletResponse("wms?service=WMS&request=GetCapabilities&version=1.3.0");
        CapabilitiesModifyingTest.assertTrue((String)("Response does not contain ServiceExceptionReport: " + response.getOutputStreamContent()), (boolean)response.getOutputStreamContent().endsWith("</ServiceExceptionReport>"));
    }

    public void testMisconfiguredLayerIsSkippedWhenWMSServiceIsConfiguredThatWay_1_3_0() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setResourceErrorHandling(ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS);
        this.getGeoServer().save(global);
        for (FeatureTypeInfo ft : this.getCatalog().getFeatureTypes()) {
            ft.setLatLonBoundingBox(null);
            this.getCatalog().save((ResourceInfo)ft);
        }
        Document caps = this.getAsDOM("wms?service=WMS&request=GetCapabilities&version=1.3.0");
        CapabilitiesModifyingTest.assertEquals((String)"WMS_Capabilities", (String)caps.getDocumentElement().getTagName());
        XMLAssert.assertXpathEvaluatesTo((String)"", (String)"//Layer/Name/text()", (Document)caps);
    }
}

