/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.xml.namespace.QName;
import junit.framework.Test;
import org.apache.commons.io.FileUtils;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.test.RemoteOWSTestSupport;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.w3c.dom.Document;

public class GetMapIntegrationTest
extends WMSTestSupport {
    String bbox = "-130,24,-66,50";
    String styles = "states";
    String layers = "sf:states";
    public static final String STATES_SLD = "<StyledLayerDescriptor version=\"1.0.0\"><UserLayer><Name>sf:states</Name><UserStyle><Name>UserSelection</Name><FeatureTypeStyle><Rule><Filter xmlns:gml=\"http://www.opengis.net/gml\"><PropertyIsEqualTo><PropertyName>STATE_ABBR</PropertyName><Literal>IL</Literal></PropertyIsEqualTo></Filter><PolygonSymbolizer><Fill><CssParameter name=\"fill\">#FF0000</CssParameter></Fill></PolygonSymbolizer></Rule><Rule><LineSymbolizer><Stroke/></LineSymbolizer></Rule></FeatureTypeStyle></UserStyle></UserLayer></StyledLayerDescriptor>";
    public static final String STATES_SLD11 = "<StyledLayerDescriptor version=\"1.1.0\">  <UserLayer>   <Name>sf:states</Name>   <UserStyle>    <Name>UserSelection</Name>    <se:FeatureTypeStyle xmlns:se=\"http://www.opengis.net/se\">     <se:Rule>      <ogc:Filter xmlns:ogc=\"http://www.opengis.net/ogc\">       <ogc:PropertyIsEqualTo>        <ogc:PropertyName>STATE_ABBR</ogc:PropertyName>        <ogc:Literal>IL</ogc:Literal>       </ogc:PropertyIsEqualTo>      </ogc:Filter>      <se:PolygonSymbolizer>       <se:Fill>        <se:SvgParameter name=\"fill\">#FF0000</se:SvgParameter>       </se:Fill>      </se:PolygonSymbolizer>     </se:Rule>     <se:Rule>      <se:LineSymbolizer>       <se:Stroke/>      </se:LineSymbolizer>     </se:Rule>    </se:FeatureTypeStyle>   </UserStyle>  </UserLayer> </StyledLayerDescriptor>";
    public static final String STATES_GETMAP = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n <ogc:GetMap service=\"WMS\"  version=\"1.1.1\" \n         xmlns:gml=\"http://www.opengis.net/gml\"\n         xmlns:ogc=\"http://www.opengis.net/ows\"\n         xmlns:sld=\"http://www.opengis.net/sld\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://www.opengis.net/ows GetMap.xsd http://www.opengis.net/gml geometry.xsd http://www.opengis.net/sld StyledLayerDescriptor.xsd \">\n         <sld:StyledLayerDescriptor>\n                 <sld:NamedLayer>\n                         <sld:Name>sf:states</sld:Name>\n                         <sld:NamedStyle>\n                                 <sld:Name>Default</sld:Name>\n                         </sld:NamedStyle>\n                 </sld:NamedLayer>\n         </sld:StyledLayerDescriptor>\n         <ogc:BoundingBox srsName=\"4326\">\n                 <gml:coord>\n                         <gml:X>-130</gml:X>\n                         <gml:Y>24</gml:Y>\n                 </gml:coord>\n                 <gml:coord>\n                         <gml:X>-66</gml:X>\n                         <gml:Y>50</gml:Y>\n                 </gml:coord>\n         </ogc:BoundingBox>\n         <ogc:Output>\n                 <ogc:Format>image/png</ogc:Format>\n                 <ogc:Size>\n                         <ogc:Width>550</ogc:Width>\n                         <ogc:Height>250</ogc:Height>\n                 </ogc:Size>\n         </ogc:Output>\n </ogc:GetMap>\n ";

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetMapIntegrationTest());
    }

    public void setUpInternal() throws Exception {
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addStyle("Population", GetMapIntegrationTest.class.getResource("Population.sld"));
        dataDirectory.addPropertiesType(new QName(MockData.SF_URI, "states", MockData.SF_PREFIX), ((Object)((Object)this)).getClass().getResource("states.properties"), null);
        dataDirectory.addStyle("parametric", WMSTestSupport.class.getResource("map/parametric.sld"));
        dataDirectory.addStyle("translucent", GetMapIntegrationTest.class.getResource("translucent.sld"));
        URL style = MockData.class.getResource("raster.sld");
        String styleName = "raster";
        dataDirectory.addStyle(styleName, style);
        dataDirectory.addCoverage(new QName(MockData.SF_URI, "mosaic_holes", MockData.SF_PREFIX), GetMapIntegrationTest.class.getResource("mosaic_holes.zip"), null, "raster");
        dataDirectory.addWcs11Coverages();
        dataDirectory.addStyle("demTranslucent", GetMapIntegrationTest.class.getResource("demTranslucent.sld"));
    }

    public void testImage() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png" + "&request=GetMap" + "&width=550" + "&height=250" + "&srs=EPSG:4326");
        this.checkImage(response);
    }

    public void testLayoutLegendNPE() throws Exception {
        FeatureTypeInfo states = this.getCatalog().getFeatureTypeByName("states");
        states.setTitle(null);
        this.getCatalog().save((ResourceInfo)states);
        File layouts = this.getDataDirectory().findOrCreateDir(new String[]{"layouts"});
        URL layout = GetMapIntegrationTest.class.getResource("test-layout.xml");
        FileUtils.copyURLToFile((URL)layout, (File)new File(layouts, "test-layout.xml"));
        BufferedImage image = this.getAsImage("wms?bbox=" + this.bbox + "&styles=Population&layers=" + this.layers + "&Format=image/png" + "&request=GetMap" + "&width=550" + "&height=250" + "&srs=EPSG:4326&format_options=layout:test-layout", "image/png");
        this.assertPixel(image, 12, 16, Color.RED);
        this.assertPixel(image, 12, 32, Color.GREEN);
        this.assertPixel(image, 12, 52, Color.BLUE);
    }

    public void testLayoutLegendStyleTitle() throws Exception {
        FeatureTypeInfo states = this.getCatalog().getFeatureTypeByName("states");
        states.setTitle(null);
        this.getCatalog().save((ResourceInfo)states);
        File layouts = this.getDataDirectory().findOrCreateDir(new String[]{"layouts"});
        URL layout = GetMapIntegrationTest.class.getResource("test-layout-sldtitle.xml");
        FileUtils.copyURLToFile((URL)layout, (File)new File(layouts, "test-layout-sldtitle.xml"));
        BufferedImage image = this.getAsImage("wms?bbox=" + this.bbox + "&styles=Population&layers=" + this.layers + "&Format=image/png" + "&request=GetMap" + "&width=550" + "&height=250" + "&srs=EPSG:4326&format_options=layout:test-layout-sldtitle", "image/png");
        this.assertPixel(image, 12, 36, Color.RED);
        this.assertPixel(image, 12, 52, Color.GREEN);
        this.assertPixel(image, 12, 72, Color.BLUE);
    }

    public void testLayoutTranslucent() throws Exception {
        File layouts = this.getDataDirectory().findOrCreateDir(new String[]{"layouts"});
        URL layout = GetMapIntegrationTest.class.getResource("test-layout.xml");
        FileUtils.copyURLToFile((URL)layout, (File)new File(layouts, "test-layout.xml"));
        BufferedImage image = this.getAsImage("wms?bbox=" + this.bbox + "&styles=translucent&layers=" + this.layers + "&Format=image/png" + "&request=GetMap" + "&width=550" + "&height=250" + "&srs=EPSG:4326" + "&format_options=layout:test-layout&transparent=true", "image/png");
        this.assertPixel(image, 56, 211, Color.WHITE);
        this.assertPixel(image, 52, 221, Color.BLACK);
    }

    public void testGeotiffMime() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/geotiff" + "&request=GetMap" + "&width=550" + "&height=250" + "&srs=EPSG:4326");
        GetMapIntegrationTest.assertEquals((String)"image/geotiff", (String)response.getContentType());
        GetMapIntegrationTest.assertEquals((String)"inline; filename=sf-states.tif", (String)response.getHeader("Content-Disposition"));
    }

    public void testPng8Mime() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png8" + "&request=GetMap" + "&width=550" + "&height=250" + "&srs=EPSG:4326");
        GetMapIntegrationTest.assertEquals((String)"image/png; mode=8bit", (String)response.getContentType());
        GetMapIntegrationTest.assertEquals((String)"inline; filename=sf-states.png", (String)response.getHeader("Content-Disposition"));
    }

    public void testDefaultContentDisposition() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png" + "&request=GetMap" + "&width=550" + "&height=250" + "&srs=EPSG:4326");
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        GetMapIntegrationTest.assertEquals((String)"inline; filename=sf-states.png", (String)response.getHeader("Content-Disposition"));
    }

    public void testForcedContentDisposition() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png" + "&request=GetMap" + "&width=550" + "&height=250" + "&srs=EPSG:4326&content-disposition=attachment");
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        GetMapIntegrationTest.assertEquals((String)"attachment; filename=sf-states.png", (String)response.getHeader("Content-Disposition"));
    }

    public void testForcedFilename() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png" + "&request=GetMap" + "&width=550" + "&height=250" + "&srs=EPSG:4326&filename=dude.png");
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        GetMapIntegrationTest.assertEquals((String)"inline; filename=dude.png", (String)response.getHeader("Content-Disposition"));
    }

    public void testForcedContentDispositionFilename() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png" + "&request=GetMap" + "&width=550" + "&height=250" + "&srs=EPSG:4326&content-disposition=attachment&filename=dude.png");
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        GetMapIntegrationTest.assertEquals((String)"attachment; filename=dude.png", (String)response.getHeader("Content-Disposition"));
    }

    public void testSldBody() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=" + "&layers=" + this.layers + "&Format=image/png" + "&request=GetMap" + "&width=550" + "&height=250" + "&srs=EPSG:4326" + "&SLD_BODY=" + STATES_SLD.replaceAll("=", "%3D"));
        this.checkImage(response);
    }

    public void testSldBody11() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=" + "&layers=" + this.layers + "&Format=image/png" + "&request=GetMap" + "&width=550" + "&height=250" + "&srs=EPSG:4326" + "&SLD_BODY=" + STATES_SLD11.replaceAll("=", "%3D"));
        this.checkImage(response);
    }

    public void testSldBodyNoVersion() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=" + "&layers=" + this.layers + "&Format=image/png" + "&request=GetMap" + "&width=550" + "&height=250" + "&srs=EPSG:4326" + "&SLD_BODY=" + STATES_SLD.replace(" version=\"1.1.0\"", "").replaceAll("=", "%3D"));
        this.checkImage(response);
    }

    public void testSldBodyPost() throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse("wms?bbox=" + this.bbox + "&format=image/png&request=GetMap&width=550&height=250" + "&srs=EPSG:4326", STATES_SLD);
        this.checkImage(response);
    }

    public void testSldBodyPost11() throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse("wms?bbox=" + this.bbox + "&format=image/png&request=GetMap&width=550&height=250" + "&srs=EPSG:4326", STATES_SLD11);
        this.checkImage(response);
    }

    public void testXmlPost() throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse("wms?", STATES_GETMAP);
        this.checkImage(response);
    }

    public void testRemoteOWSGet() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWFSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        MockHttpServletResponse response = this.getAsServletResponse("wms?request=getmap&service=wms&version=1.1.1&format=image/png&layers=topp:states," + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "&styles=Population," + MockData.BASIC_POLYGONS.getLocalPart() + "&remote_ows_type=WFS" + "&remote_ows_url=" + "http://demo.opengeo.org/geoserver/wfs?" + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326");
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
    }

    public void testRemoteOWSUserStyleGet() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWFSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        URL url = GetMapIntegrationTest.class.getResource("remoteOws.sld");
        MockHttpServletResponse response = this.getAsServletResponse("wms?request=getmap&service=wms&version=1.1.1&format=image/png&sld=" + url.toString() + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326");
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
    }

    public void testWorkspaceQualified() throws Exception {
        Document doc = this.getAsDOM("cite/wms?request=getmap&service=wms&layers=PrimitiveGeoFeature&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-180,-90,180,90", true);
        GetMapIntegrationTest.assertEquals((String)"ServiceExceptionReport", (String)doc.getDocumentElement().getNodeName());
        MockHttpServletResponse response = this.getAsServletResponse("cite/wms?request=getmap&service=wms&layers=Lakes&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-180,-90,180,90");
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
    }

    public void testLayerQualified() throws Exception {
        Document doc = this.getAsDOM("cite/Ponds/wms?request=getmap&service=wms&layers=Forests&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-180,-90,180,90", true);
        GetMapIntegrationTest.assertEquals((String)"ServiceExceptionReport", (String)doc.getDocumentElement().getNodeName());
        MockHttpServletResponse response = this.getAsServletResponse("cite/Ponds/wms?request=getmap&service=wms&layers=Ponds&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-180,-90,180,90");
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
    }

    public void testGroupWorkspaceQualified() throws Exception {
        String url = "wms?request=getmap&service=wms&layers=nature&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002";
        MockHttpServletResponse response = this.getAsServletResponse(url);
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        response = this.getAsServletResponse("cite/" + url);
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
    }

    public void testEnvDefault() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=parametric&layers=" + this.layers + "&Format=image/png" + "&request=GetMap" + "&width=550" + "&height=250" + "&srs=EPSG:4326");
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        int[] rgba = new int[3];
        image.getData().getPixel(250, 125, rgba);
        GetMapIntegrationTest.assertEquals((int)0, (int)rgba[0]);
        GetMapIntegrationTest.assertEquals((int)0, (int)rgba[1]);
        GetMapIntegrationTest.assertEquals((int)0, (int)rgba[2]);
    }

    public void testEnvRed() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=parametric&layers=" + this.layers + "&Format=image/png" + "&request=GetMap" + "&width=550" + "&height=250" + "&srs=EPSG:4326&env=color:0xFF0000");
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        int[] rgba = new int[3];
        image.getData().getPixel(250, 125, rgba);
        GetMapIntegrationTest.assertEquals((int)255, (int)rgba[0]);
        GetMapIntegrationTest.assertEquals((int)0, (int)rgba[1]);
        GetMapIntegrationTest.assertEquals((int)0, (int)rgba[2]);
    }

    public void testMosaicHoles() throws Exception {
        String url = "wms?LAYERS=sf%3Amosaic_holes&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&STYLES=&SRS=EPSG%3A4326&BBOX=6.40284375,36.385494140625,12.189662109375,42.444494140625&WIDTH=489&HEIGHT=512&transparent=true";
        BufferedImage bi = this.getAsImage(url, "image/png");
        int[] pixel = new int[4];
        bi.getRaster().getPixel(0, 250, pixel);
        int[] nArray = new int[4];
        nArray[3] = 255;
        GetMapIntegrationTest.assertTrue((boolean)Arrays.equals(nArray, pixel));
        CoverageInfo ci = this.getCatalog().getCoverageByName("sf:mosaic_holes");
        Map params = ci.getParameters();
        params.put(ImageMosaicFormat.INPUT_TRANSPARENT_COLOR.getName().getCode(), "#000000");
        params.put(ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.getName().getCode(), "#000000");
        this.getCatalog().save((ResourceInfo)ci);
        bi = this.getAsImage(url, "image/png");
        bi.getRaster().getPixel(0, 250, pixel);
        int[] nArray2 = new int[4];
        nArray2[0] = 255;
        nArray2[1] = 255;
        nArray2[2] = 255;
        GetMapIntegrationTest.assertTrue((boolean)Arrays.equals(nArray2, pixel));
    }

    public void testTransparentPaletteOpaqueOutput() throws Exception {
        String url = "wms?LAYERS=" + this.getLayerId(MockData.TASMANIA_DEM) + "&styles=demTranslucent&" + "FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1" + "&REQUEST=GetMap&SRS=EPSG%3A4326" + "&BBOX=145,-43,146,-41&WIDTH=100&HEIGHT=200&bgcolor=0xFF0000";
        BufferedImage bi = this.getAsImage(url, "image/png");
        ColorModel cm = bi.getColorModel();
        GetMapIntegrationTest.assertTrue((boolean)(cm instanceof IndexColorModel));
        GetMapIntegrationTest.assertEquals((int)1, (int)cm.getTransparency());
        int[] pixel = new int[1];
        bi.getRaster().getPixel(4, 196, pixel);
        int[] color = new int[3];
        cm.getComponents(pixel[0], color, 0);
        GetMapIntegrationTest.assertEquals((int)255, (int)color[0]);
        GetMapIntegrationTest.assertEquals((int)0, (int)color[1]);
        GetMapIntegrationTest.assertEquals((int)0, (int)color[2]);
        bi.getRaster().getPixel(56, 49, pixel);
        cm.getComponents(pixel[0], color, 0);
        GetMapIntegrationTest.assertEquals((int)0, (int)color[0]);
        GetMapIntegrationTest.assertEquals((int)255, (int)color[1]);
        GetMapIntegrationTest.assertEquals((int)0, (int)color[2]);
    }

    public void testTransparentPaletteTransparentOutput() throws Exception {
        String url = "wms?LAYERS=" + this.getLayerId(MockData.TASMANIA_DEM) + "&styles=demTranslucent&" + "FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1" + "&REQUEST=GetMap&SRS=EPSG%3A4326" + "&BBOX=145,-43,146,-41&WIDTH=100&HEIGHT=200&transparent=true";
        BufferedImage bi = this.getAsImage(url, "image/png");
        ColorModel cm = bi.getColorModel();
        GetMapIntegrationTest.assertTrue((boolean)(cm instanceof IndexColorModel));
        GetMapIntegrationTest.assertEquals((int)3, (int)cm.getTransparency());
        int[] pixel = new int[1];
        bi.getRaster().getPixel(4, 196, pixel);
        int[] color = new int[4];
        cm.getComponents(pixel[0], color, 0);
        GetMapIntegrationTest.assertEquals((int)0, (int)color[3]);
        bi.getRaster().getPixel(56, 49, pixel);
        cm.getComponents(pixel[0], color, 0);
        GetMapIntegrationTest.assertEquals((int)0, (int)color[0]);
        GetMapIntegrationTest.assertEquals((int)255, (int)color[1]);
        GetMapIntegrationTest.assertEquals((int)0, (int)color[2]);
        GetMapIntegrationTest.assertEquals((int)255, (int)color[3]);
    }

    public void testTransparentPaletteTransparentOutputPng8() throws Exception {
        String url = "wms?LAYERS=" + this.getLayerId(MockData.TASMANIA_DEM) + "&styles=demTranslucent&" + "FORMAT=image%2Fpng8&SERVICE=WMS&VERSION=1.1.1" + "&REQUEST=GetMap&SRS=EPSG%3A4326" + "&BBOX=145,-43,146,-41&WIDTH=100&HEIGHT=200&transparent=true";
        BufferedImage bi = this.getAsImage(url, "image/png; mode=8bit");
        ColorModel cm = bi.getColorModel();
        GetMapIntegrationTest.assertTrue((boolean)(cm instanceof IndexColorModel));
        GetMapIntegrationTest.assertEquals((int)3, (int)cm.getTransparency());
        int[] pixel = new int[1];
        bi.getRaster().getPixel(4, 196, pixel);
        int[] color = new int[4];
        cm.getComponents(pixel[0], color, 0);
        GetMapIntegrationTest.assertEquals((int)0, (int)color[3]);
        bi.getRaster().getPixel(56, 49, pixel);
        cm.getComponents(pixel[0], color, 0);
        GetMapIntegrationTest.assertEquals((int)0, (int)color[0]);
        GetMapIntegrationTest.assertEquals((int)255, (int)color[1]);
        GetMapIntegrationTest.assertEquals((int)0, (int)color[2]);
        GetMapIntegrationTest.assertEquals((int)255, (int)color[3]);
    }
}

