/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import java.util.Map;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapabilitiesBBOXForEachCRSTest
extends WMSTestSupport {
    @Override
    protected void registerNamespaces(Map<String, String> namespaces) {
        namespaces.put("wms", "http://www.opengis.net/wms");
        namespaces.put("ows", "http://www.opengis.net/ows");
    }

    void addSRSAndSetFlag() {
        WMSInfo wms = this.getWMS().getServiceInfo();
        wms.getSRS().add("4326");
        wms.getSRS().add("3005");
        wms.setBBOXForEachCRS(true);
        this.getGeoServer().save((ServiceInfo)wms);
    }

    public void testBBOXForEachCRS() throws Exception {
        Document doc = this.getAsDOM("sf/PrimitiveGeoFeature/wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        String layer = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        XMLAssert.assertXpathExists((String)("//wms:Layer[wms:Name='" + layer + "']/wms:BoundingBox[@CRS = 'EPSG:4326']"), (Document)doc);
        XMLAssert.assertXpathNotExists((String)("//wms:Layer[wms:Name='" + layer + "']/wms:BoundingBox[@CRS = 'EPSG:3005']"), (Document)doc);
        this.addSRSAndSetFlag();
        doc = this.getAsDOM("sf/PrimitiveGeoFeature/wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathExists((String)("//wms:Layer[wms:Name='" + layer + "']/wms:BoundingBox[@CRS = 'EPSG:4326']"), (Document)doc);
        XMLAssert.assertXpathExists((String)("//wms:Layer[wms:Name='" + layer + "']/wms:BoundingBox[@CRS = 'EPSG:3005']"), (Document)doc);
    }

    public void testRootLayer() throws Exception {
        Document doc = this.getAsDOM("sf/PrimitiveGeoFeature/wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathNotExists((String)"/wms:WMS_Capabilities/wms:Capability/wms:Layer/wms:BoundingBox[@CRS = 'EPSG:4326']", (Document)doc);
        XMLAssert.assertXpathNotExists((String)"/wms:WMS_Capabilities/wms:Capability/wms:Layer/wms:BoundingBox[@CRS = 'EPSG:3005']", (Document)doc);
        this.addSRSAndSetFlag();
        doc = this.getAsDOM("sf/PrimitiveGeoFeature/wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathExists((String)"/wms:WMS_Capabilities/wms:Capability/wms:Layer/wms:BoundingBox[@CRS = 'EPSG:4326']", (Document)doc);
        XMLAssert.assertXpathExists((String)"/wms:WMS_Capabilities/wms:Capability/wms:Layer/wms:BoundingBox[@CRS = 'EPSG:3005']", (Document)doc);
    }
}

