/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import junit.framework.Test;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.featureinfo.GetFeatureInfoKvpReader;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Document;

public class GetFeatureInfoIntegrationTest
extends WMSTestSupport {
    public static String WCS_PREFIX = "wcs";
    public static String WCS_URI = "http://www.opengis.net/wcs/1.1.1";
    public static QName TASMANIA_BM = new QName(WCS_URI, "BlueMarble", WCS_PREFIX);
    public static QName SQUARES = new QName(MockData.CITE_URI, "squares", MockData.CITE_PREFIX);

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetFeatureInfoIntegrationTest());
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("wms", "http://www.opengis.net/wms");
        namespaces.put("ows", "http://www.opengis.net/ows");
        namespaces.put("ogc", "http://www.opengis.net/ogc");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put(WCS_PREFIX, WCS_URI);
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
        Logging.getLogger((String)"org.geoserver.ows").setLevel(Level.OFF);
        WMSInfo wmsInfo = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wmsInfo.setMaxBuffer(50);
        this.getGeoServer().save((ServiceInfo)wmsInfo);
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addWcs10Coverages();
        dataDirectory.addStyle("thickStroke", ((Object)((Object)this)).getClass().getResource("../wms_1_1_1/thickStroke.sld"));
        dataDirectory.addStyle("raster", ((Object)((Object)this)).getClass().getResource("../wms_1_1_1/raster.sld"));
        dataDirectory.addStyle("rasterScales", ((Object)((Object)this)).getClass().getResource("../wms_1_1_1/rasterScales.sld"));
        dataDirectory.addCoverage(TASMANIA_BM, ((Object)((Object)this)).getClass().getResource("../wms_1_1_1/tazbm.tiff"), "tiff", "raster");
        dataDirectory.addStyle("squares", ((Object)((Object)this)).getClass().getResource("../wms_1_1_1/squares.sld"));
        dataDirectory.addPropertiesType(SQUARES, ((Object)((Object)this)).getClass().getResource("../wms_1_1_1/squares.properties"), null);
    }

    public void testQueryNonQueryableLayer() throws Exception {
        WMS wms = (WMS)applicationContext.getBean("wms");
        GetFeatureInfoKvpReader reader = (GetFeatureInfoKvpReader)applicationContext.getBean("getFeatureInfoKvpReader");
        try {
            WMS fakeWMS = new WMS(wms.getGeoServer()){

                public boolean isQueryable(LayerInfo layer) {
                    if ("Forests".equals(layer.getName())) {
                        return false;
                    }
                    return super.isQueryable(layer);
                }
            };
            reader.setWMS(fakeWMS);
            String layer = this.getLayerId(MockData.FORESTS);
            String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10";
            Document doc = this.dom(this.get(request), true);
            XMLAssert.assertXpathEvaluatesTo((String)"LayerNotQueryable", (String)"/ogc:ServiceExceptionReport/ogc:ServiceException/@code", (Document)doc);
        }
        finally {
            reader.setWMS(wms);
        }
    }

    public void testInvalidPoint() throws Exception {
        String layer = String.valueOf(MockData.FORESTS.getPrefix()) + ":" + MockData.FORESTS.getLocalPart();
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20";
        Document doc = this.dom(this.get(request), true);
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidPoint", (String)"/ogc:ServiceExceptionReport/ogc:ServiceException/@code", (Document)doc);
        request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=A&j=";
        doc = this.dom(this.get(request), true);
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidPoint", (String)"/ogc:ServiceExceptionReport/ogc:ServiceException/@code", (Document)doc);
    }

    public void testSimple() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10";
        String result = this.getAsString(request);
        GetFeatureInfoIntegrationTest.assertNotNull((Object)result);
        GetFeatureInfoIntegrationTest.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    public void testSimpleHtml() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'Forests.')])", (Document)dom);
    }

    public void testBuffer() throws Exception {
        String layer = this.getLayerId(MockData.BASIC_POLYGONS);
        String base = "wms?version=1.3.0&bbox=-4.5,-2.,4.5,7&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=300&height=300";
        Document dom = this.getAsDOM(String.valueOf(base) + "&i=85&j=230");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr)", (Document)dom);
        dom = this.getAsDOM(String.valueOf(base) + "&i=85&j=230&buffer=40");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'BasicPolygons.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'BasicPolygons.1107531493630'])", (Document)dom);
        dom = this.getAsDOM(String.valueOf(base) + "&i=85&j=230&buffer=300");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'BasicPolygons.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'BasicPolygons.1107531493630'])", (Document)dom);
    }

    public void testAutoBuffer() throws Exception {
        String layer = this.getLayerId(MockData.BASIC_POLYGONS);
        String base = "wms?version=1.3.0&bbox=-4.5,-2.,4.5,7&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=300&height=300&i=114&j=229";
        Document dom = this.getAsDOM(String.valueOf(base) + "&styles=");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr)", (Document)dom);
        dom = this.getAsDOM(String.valueOf(base) + "&styles=thickStroke");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'BasicPolygons.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'BasicPolygons.1107531493630'])", (Document)dom);
    }

    public void testBufferScales() throws Exception {
        String layer = this.getLayerId(SQUARES);
        String base = "wms?version=1.3.0&&format=png&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&styles=squares&bbox=0,0,10000,10000&feature_count=10";
        int w = 357142;
        Document dom = this.getAsDOM(String.valueOf(base) + "&width=" + w + "&height=" + w + "&i=20&j=" + (w - 20));
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr)", (Document)dom);
        w = 714285;
        dom = this.getAsDOM(String.valueOf(base) + "&width=" + w + "&height=" + w + "&i=20&j=" + (w - 20));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'squares.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'squares.1'])", (Document)dom);
        w = 3571428;
        dom = this.getAsDOM(String.valueOf(base) + "&width=" + w + "&height=" + w + "&i=20&j=" + (w - 20));
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(/html/body/table/tr/td[starts-with(.,'squares.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'squares.1'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'squares.2'])", (Document)dom);
    }

    public void testTwoLayers() throws Exception {
        String layer = String.valueOf(this.getLayerId(MockData.FORESTS)) + "," + this.getLayerId(MockData.LAKES);
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10&info";
        String result = this.getAsString(request);
        GetFeatureInfoIntegrationTest.assertNotNull((Object)result);
        GetFeatureInfoIntegrationTest.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        GetFeatureInfoIntegrationTest.assertTrue((result.indexOf("<style type=\"text/css\">") > 0 ? 1 : 0) != 0);
    }

    public void testUknownFormat() throws Exception {
        String layer = String.valueOf(MockData.FORESTS.getPrefix()) + ":" + MockData.FORESTS.getLocalPart();
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=unknown/format&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10";
        Document doc = this.dom(this.get(request), true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceExceptionReport/ogc:ServiceException)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidFormat", (String)"/ogc:ServiceExceptionReport/ogc:ServiceException/@code", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"info_format", (String)"/ogc:ServiceExceptionReport/ogc:ServiceException/@locator", (Document)doc);
    }

    public void testCoverage() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?version=1.3.0&service=wms&request=GetFeatureInfo&layers=" + layer + "&styles=&bbox=-44.5,146.5,-43,148&width=600&height=600" + "&info_format=text/html&query_layers=" + layer + "&i=300&j=300&srs=EPSG:4326";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'RED_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'GREEN_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'BLUE_BAND'])", (Document)dom);
    }

    public void testCoverageGML() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?version=1.3.0&service=wms&request=GetFeatureInfo&layers=" + layer + "&styles=&bbox=-44.5,146.5,-43,148&width=600&height=600" + "&info_format=application/vnd.ogc.gml&query_layers=" + layer + "&i=300&j=300&srs=EPSG:4326";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"26.0", (String)"//wfs:FeatureCollection/gml:featureMember/wcs:BlueMarble/wcs:RED_BAND", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"70.0", (String)"//wfs:FeatureCollection/gml:featureMember/wcs:BlueMarble/wcs:GREEN_BAND", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"126.0", (String)"//wfs:FeatureCollection/gml:featureMember/wcs:BlueMarble/wcs:BLUE_BAND", (Document)dom);
    }

    public void testCoverageScales() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?version=1.3.0&service=wms&request=GetFeatureInfo&layers=" + layer + "&styles=rasterScales&bbox=-44.5,146.5,-43,148" + "&info_format=text/html&query_layers=" + layer + "&i=300&j=300&srs=EPSG:4326";
        Document dom = this.getAsDOM(String.valueOf(request) + "&width=300&height=300");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr/th)", (Document)dom);
        dom = this.getAsDOM(String.valueOf(request) + "&width=600&height=600");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'RED_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'GREEN_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'BLUE_BAND'])", (Document)dom);
    }

    public void testOutsideCoverage() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?version=1.3.0&service=wms&request=GetFeatureInfo&layers=" + layer + "&styles=raster&bbox=0,-90,148,-43" + "&info_format=text/html&query_layers=" + layer + "&width=300&height=300&i=10&j=150&srs=EPSG:4326";
        Document dom = this.getAsDOM(String.valueOf(request));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr/th)", (Document)dom);
    }

    public void testUnknownQueryLayer() throws Exception {
        String layers1 = String.valueOf(this.getLayerId(MockData.FORESTS)) + "," + this.getLayerId(MockData.LAKES);
        String layers2 = String.valueOf(this.getLayerId(MockData.FORESTS)) + "," + this.getLayerId(MockData.BRIDGES);
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layers1 + "&query_layers=" + layers2 + "&width=20&height=20&i=10&j=10&info";
        Document dom = this.getAsDOM(String.valueOf(request));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/ogc:ServiceExceptionReport)", (Document)dom);
    }

    public void testDeriveLayersFromSLD() throws Exception {
        String layers = String.valueOf(this.getLayerId(MockData.FORESTS)) + "," + this.getLayerId(MockData.LAKES);
        String sld = "<StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\"        xmlns:se=\"http://www.opengis.net/se\" version=\"1.1.0\">  <NamedLayer>   <se:Name>" + this.getLayerId(MockData.FORESTS) + "</se:Name> " + " </NamedLayer> " + " <NamedLayer> " + "  <se:Name>" + this.getLayerId(MockData.LAKES) + "</se:Name> " + " </NamedLayer> " + "</StyledLayerDescriptor>";
        String request1 = "wms?version=1.3&bbox=146.5,-44.5,148,-43&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&sld_body=" + sld.replaceAll("=", "%3D") + "&width=20&height=20&x=10&y=10&info";
        String request2 = "wms?version=1.3&bbox=146.5,-44.5,148,-43&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&sld_body=" + sld.replaceAll("=", "%3D") + "&query_layers=" + layers + "&width=20&height=20&x=10&y=10&info";
        String request3 = "wms?version=1.3&bbox=146.5,-44.5,148,-43&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layers + "&query_layers=" + layers + "&width=20&height=20&x=10&y=10&info";
        String invalidRequest1 = "wms?version=1.3&bbox=146.5,-44.5,148,-43&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layers + "&width=20&height=20&x=10&y=10&info";
        String invalidRequest2 = "wms?version=1.3&bbox=146.5,-44.5,148,-43&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&sld_body=" + sld.replaceAll("=", "%3D") + "&query_layers=" + this.getLayerId(MockData.TASMANIA_BM) + "&width=20&height=20&x=10&y=10&info";
        String result1 = this.getAsString(request1);
        String result2 = this.getAsString(request2);
        String result3 = this.getAsString(request3);
        GetFeatureInfoIntegrationTest.assertEquals((String)result1, (String)result2);
        GetFeatureInfoIntegrationTest.assertEquals((String)result1, (String)result3);
        Document invalidResult1 = this.getAsDOM(invalidRequest1);
        Document invalidResult2 = this.getAsDOM(invalidRequest2);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ServiceExceptionReport/ServiceException)", (Document)invalidResult1);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ServiceExceptionReport/ServiceException)", (Document)invalidResult2);
    }

    public void testLayerQualified() throws Exception {
        String layer = "Forests";
        String q = "?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&i=10&j=10";
        String request = "cite/Ponds/wms" + q;
        Document dom = this.getAsDOM(request);
        GetFeatureInfoIntegrationTest.assertEquals((String)"ServiceExceptionReport", (String)dom.getDocumentElement().getNodeName());
        request = "cite/Forests/wms" + q;
        String result = this.getAsString(request);
        GetFeatureInfoIntegrationTest.assertNotNull((Object)result);
        GetFeatureInfoIntegrationTest.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    public void testXY() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.3.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        String result = this.getAsString(request);
        GetFeatureInfoIntegrationTest.assertNotNull((Object)result);
        GetFeatureInfoIntegrationTest.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    public void testXYGeo() throws Exception {
        String layer = this.getLayerId(MockData.BASIC_POLYGONS);
        String url = "wms?styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=292&height=512&x=147&y=360&srs=epsg:4326";
        String request = String.valueOf(url) + "&VERSION=1.1.1&BBOX=-3.992187,-4.5,3.992188,9.5";
        String result = this.getAsString(request);
        GetFeatureInfoIntegrationTest.assertTrue((result.indexOf("the_geom =") > 0 ? 1 : 0) != 0);
        request = String.valueOf(url) + "&VERSION=1.3.0&BBOX=-4.5,-3.992187,9.5,3.992188";
        result = this.getAsString(request);
        GetFeatureInfoIntegrationTest.assertTrue((result.indexOf("the_geom =") > 0 ? 1 : 0) != 0);
    }

    public void testXYProj() throws Exception {
        String layer = this.getLayerId(MockData.POLYGONS);
        String url = "wms?styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&WIDTH=512&HEIGHT=511&X=136&Y=380&srs=epsg:32615";
        String request = String.valueOf(url) + "&VERSION=1.1.1&BBOX=499699.999705,499502.050472,501800.000326,501597.949528";
        String result = this.getAsString(request);
        GetFeatureInfoIntegrationTest.assertTrue((result.indexOf("polygonProperty =") > 0 ? 1 : 0) != 0);
        request = String.valueOf(url) + "&VERSION=1.3.0&BBOX=499699.999705,499502.050472,501800.000326,501597.949528";
        result = this.getAsString(request);
        GetFeatureInfoIntegrationTest.assertTrue((result.indexOf("polygonProperty =") > 0 ? 1 : 0) != 0);
    }

    public void testXYCoverage() throws Exception {
        String layer = this.getLayerId(MockData.USA_WORLDIMG);
        String url = "wms?styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&WIDTH=512&HEIGHT=408&X=75&Y=132&srs=epsg:4326";
        String request = String.valueOf(url) + "&VERSION=1.1.1&BBOX=-180,-143.4375,180,143.4375";
        String result = this.getAsString(request);
        Matcher m = Pattern.compile(".*RED_BAND = (\\d+\\.\\d+).*GREEN_BAND = (\\d+\\.\\d+).*BLUE_BAND = (\\d+\\.\\d+).*", 32).matcher(result);
        GetFeatureInfoIntegrationTest.assertTrue((boolean)m.matches());
        double red = Double.parseDouble(m.group(1));
        double green = Double.parseDouble(m.group(2));
        double blue = Double.parseDouble(m.group(3));
        request = String.valueOf(url) + "&VERSION=1.3.0&BBOX=-143.4375,-180,143.4375,180";
        result = this.getAsString(request);
        m = Pattern.compile(".*RED_BAND = (\\d+\\.\\d+).*GREEN_BAND = (\\d+\\.\\d+).*BLUE_BAND = (\\d+\\.\\d+).*", 32).matcher(result);
        GetFeatureInfoIntegrationTest.assertTrue((boolean)m.matches());
        GetFeatureInfoIntegrationTest.assertEquals((Object)red, (Object)Double.parseDouble(m.group(1)));
        GetFeatureInfoIntegrationTest.assertEquals((Object)green, (Object)Double.parseDouble(m.group(2)));
        GetFeatureInfoIntegrationTest.assertEquals((Object)blue, (Object)Double.parseDouble(m.group(3)));
    }
}

