/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.List;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedImageList;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.resources.image.ImageUtilities;

public class RasterCleaner
extends AbstractDispatcherCallback {
    static final ThreadLocal<List<RenderedImage>> images = new ThreadLocal();
    static final ThreadLocal<List<GridCoverage2D>> coverages = new ThreadLocal();

    public static void addImage(RenderedImage image) {
        if (image == null) {
            return;
        }
        List<RenderedImage> list = images.get();
        if (list == null) {
            list = new ArrayList<RenderedImage>();
            images.set(list);
        }
        list.add(image);
    }

    public static void addCoverage(GridCoverage2D coverage) {
        if (coverage == null) {
            return;
        }
        List<GridCoverage2D> list = coverages.get();
        if (list == null) {
            list = new ArrayList<GridCoverage2D>();
            coverages.set(list);
        }
        list.add(coverage);
    }

    public void finished(Request request) {
        this.disposeCoverages();
        this.disposeImages();
    }

    private void disposeImages() {
        List<RenderedImage> list = images.get();
        if (list != null) {
            images.remove();
            for (RenderedImage image : list) {
                if (image instanceof RenderedImageList) {
                    RenderedImageList ril = (RenderedImageList)image;
                    int i = 0;
                    while (i < ril.size()) {
                        this.disposeImage((RenderedImage)ril.get(i));
                        ++i;
                    }
                    continue;
                }
                this.disposeImage(image);
            }
            list.clear();
        }
    }

    private void disposeImage(RenderedImage image) {
        if (image instanceof PlanarImage) {
            ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)image));
        } else if (image instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)image;
            bi.flush();
        }
    }

    private void disposeCoverages() {
        List<GridCoverage2D> list = coverages.get();
        if (list != null) {
            coverages.remove();
            for (GridCoverage2D coverage : list) {
                coverage.dispose(true);
            }
            list.clear();
        }
    }
}

