/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.JAIInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wms.ExtendedCapabilitiesProvider;
import org.geoserver.wms.GetLegendGraphicOutputFormat;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSExtensions;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WatermarkInfo;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.styling.Style;
import org.geotools.util.Converters;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMS
implements ApplicationContextAware {
    public static final Version VERSION_1_1_1 = new Version("1.1.1");
    public static final Version VERSION_1_3_0 = new Version("1.3.0");
    public static final String JPEG_COMPRESSION = "jpegCompression";
    public static final int JPEG_COMPRESSION_DEFAULT = 25;
    public static final String PNG_COMPRESSION = "pngCompression";
    public static final int PNG_COMPRESSION_DEFAULT = 25;
    public static final String MAX_ALLOWED_FRAMES = "maxAllowedFrames";
    public static final int MAX_ALLOWED_FRAMES_DEFAULT = Integer.MAX_VALUE;
    public static final String MAX_RENDERING_TIME = "maxAnimatorRenderingTime";
    public static final String MAX_RENDERING_SIZE = "maxRenderingSize";
    public static final String FRAMES_DELAY = "framesDelay";
    public static final int FRAMES_DELAY_DEFAULT = 1000;
    public static final String LOOP_CONTINUOUSLY = "loopContinuously";
    public static final Boolean LOOP_CONTINUOUSLY_DEFAULT = Boolean.FALSE;
    static final Logger LOGGER = Logging.getLogger(WMS.class);
    public static final String WEB_CONTAINER_KEY = "WMS";
    public static final String SVG_SIMPLE = "Simple";
    public static final String SVG_BATIK = "Batik";
    public static String KML_REFLECTOR_MODE = "kmlReflectorMode";
    public static final String KML_REFLECTOR_MODE_REFRESH = "refresh";
    public static final String KML_REFLECTOR_MODE_SUPEROVERLAY = "superoverlay";
    public static final String KML_REFLECTOR_MODE_DOWNLOAD = "download";
    public static final String KML_REFLECTOR_MODE_DEFAULT = "refresh";
    public static final String KML_SUPEROVERLAY_MODE = "kmlSuperoverlayMode";
    public static final String KML_SUPEROVERLAY_MODE_AUTO = "auto";
    public static final String KML_SUPEROVERLAY_MODE_RASTER = "raster";
    public static final String KML_SUPEROVERLAY_MODE_OVERVIEW = "overview";
    public static final String KML_SUPEROVERLAY_MODE_HYBRID = "hybrid";
    public static final String KML_SUPEROVERLAY_MODE_CACHED = "cached";
    public static final String KML_SUPEROVERLAY_MODE_DEFAULT = "auto";
    public static final String KML_KMLATTR = "kmlAttr";
    public static final boolean KML_KMLATTR_DEFAULT = true;
    public static final String KML_KMLPLACEMARK = "kmlPlacemark";
    public static final boolean KML_KMLPLACEMARK_DEFAULT = false;
    public static final String KML_KMSCORE = "kmlKmscore";
    public static final int KML_KMSCORE_DEFAULT = 40;
    private ExecutorService animatorExecutorService;
    private final GeoServer geoserver;
    private ApplicationContext applicationContext;

    public WMS(GeoServer geoserver) {
        this.geoserver = geoserver;
    }

    private Catalog getCatalog() {
        return this.geoserver.getCatalog();
    }

    public WMSInfo getServiceInfo() {
        return (WMSInfo)this.geoserver.getService(WMSInfo.class);
    }

    public Style getStyleByName(String styleName) throws IOException {
        StyleInfo styleInfo = this.getCatalog().getStyleByName(styleName);
        return styleInfo == null ? null : styleInfo.getStyle();
    }

    public LayerInfo getLayerByName(String layerName) {
        return this.getCatalog().getLayerByName(layerName);
    }

    public LayerGroupInfo getLayerGroupByName(String layerGroupName) {
        return this.getCatalog().getLayerGroupByName(layerGroupName);
    }

    public boolean isEnabled() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return serviceInfo.isEnabled();
    }

    public static Version negotiateVersion(String requestedVersion) {
        return WMS.negotiateVersion(requestedVersion != null ? new Version(requestedVersion) : null);
    }

    public static Version negotiateVersion(Version requestedVersion) {
        if (requestedVersion == null) {
            return VERSION_1_3_0;
        }
        if (VERSION_1_1_1.equals((Object)requestedVersion)) {
            return VERSION_1_1_1;
        }
        if (VERSION_1_3_0.equals((Object)requestedVersion)) {
            return VERSION_1_3_0;
        }
        if (requestedVersion.compareTo(VERSION_1_3_0) < 0) {
            return VERSION_1_1_1;
        }
        return VERSION_1_3_0;
    }

    public String getVersion() {
        WMSInfo serviceInfo = this.getServiceInfo();
        List versions = serviceInfo.getVersions();
        String version = versions.size() > 0 ? ((Version)versions.get(0)).toString() : "1.1.1";
        return version;
    }

    public GeoServer getGeoServer() {
        return this.geoserver;
    }

    public void setAnimatorExecutorService(ExecutorService animatorExecutorService) {
        this.animatorExecutorService = animatorExecutorService;
    }

    public ExecutorService getAnimatorExecutorService() {
        return this.animatorExecutorService;
    }

    public WMSInfo.WMSInterpolation getInterpolation() {
        return this.getServiceInfo().getInterpolation();
    }

    public Boolean getPNGNativeAcceleration() {
        JAIInfo jaiInfo = this.getJaiInfo();
        return jaiInfo.isPngAcceleration();
    }

    public Boolean getJPEGNativeAcceleration() {
        JAIInfo jaiInfo = this.getJaiInfo();
        return jaiInfo.isJpegAcceleration();
    }

    private JAIInfo getJaiInfo() {
        GeoServer geoServer = this.getGeoServer();
        GeoServerInfo global = geoServer.getGlobal();
        return global.getJAI();
    }

    public Charset getCharSet() {
        GeoServer geoServer2 = this.getGeoServer();
        GeoServerInfo global = geoServer2.getGlobal();
        String charset = global.getCharset();
        return Charset.forName(charset);
    }

    public String getProxyBaseUrl() {
        GeoServer geoServer = this.getGeoServer();
        GeoServerInfo global = geoServer.getGlobal();
        String proxyBaseUrl = global.getProxyBaseUrl();
        return proxyBaseUrl;
    }

    public long getUpdateSequence() {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        return global.getUpdateSequence();
    }

    public int getWatermarkTransparency() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        return watermark.getTransparency();
    }

    public int getWatermarkPosition() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        WatermarkInfo.Position position = watermark.getPosition();
        return position.getCode();
    }

    public boolean isGlobalWatermarking() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        return watermark.isEnabled();
    }

    public String getGlobalWatermarkingURL() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        return watermark.getURL();
    }

    public FeatureTypeInfo getFeatureTypeInfo(Name name) {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo resource = (FeatureTypeInfo)catalog.getResourceByName(name, FeatureTypeInfo.class);
        return resource;
    }

    public CoverageInfo getCoverageInfo(Name name) {
        Catalog catalog = this.getCatalog();
        CoverageInfo resource = (CoverageInfo)catalog.getResourceByName(name, CoverageInfo.class);
        return resource;
    }

    public WMSLayerInfo getWMSLayerInfo(Name name) {
        Catalog catalog = this.getCatalog();
        WMSLayerInfo resource = (WMSLayerInfo)catalog.getResourceByName(name, WMSLayerInfo.class);
        return resource;
    }

    public ResourceInfo getResourceInfo(Name name) {
        Catalog catalog = this.getCatalog();
        ResourceInfo resource = catalog.getResourceByName(name, ResourceInfo.class);
        return resource;
    }

    public List<LayerInfo> getLayers() {
        Catalog catalog = this.getCatalog();
        return catalog.getLayers();
    }

    public String getNamespaceByPrefix(String prefix) {
        Catalog catalog = this.getCatalog();
        NamespaceInfo namespaceInfo = catalog.getNamespaceByPrefix(prefix);
        return namespaceInfo == null ? null : namespaceInfo.getURI();
    }

    public List<LayerGroupInfo> getLayerGroups() {
        Catalog catalog = this.getCatalog();
        List layerGroups = catalog.getLayerGroups();
        return layerGroups;
    }

    public boolean supportsSLD() {
        return true;
    }

    public boolean supportsUserLayer() {
        return true;
    }

    public boolean supportsUserStyle() {
        return true;
    }

    public boolean supportsRemoteWFS() {
        return true;
    }

    public void setSvgRenderer(String svgRendererHint) {
        WMSInfo serviceInfo = this.getServiceInfo();
        serviceInfo.getMetadata().put("svgRenderer", (Serializable)((Object)svgRendererHint));
        this.getGeoServer().save((ServiceInfo)serviceInfo);
    }

    public String getSvgRenderer() {
        WMSInfo serviceInfo = this.getServiceInfo();
        String svgRendererHint = (String)((Object)serviceInfo.getMetadata().get((Object)"svgRenderer"));
        return svgRendererHint;
    }

    public boolean isSvgAntiAlias() {
        WMSInfo serviceInfo = this.getServiceInfo();
        Boolean svgAntiAlias = (Boolean)Converters.convert((Object)serviceInfo.getMetadata().get((Object)"svgAntiAlias"), Boolean.class);
        return svgAntiAlias == null ? true : svgAntiAlias;
    }

    public int getPngCompression() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return this.getMetadataPercentage(serviceInfo.getMetadata(), PNG_COMPRESSION, 25);
    }

    public int getJpegCompression() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return this.getMetadataPercentage(serviceInfo.getMetadata(), JPEG_COMPRESSION, 25);
    }

    public int getMaxAllowedFrames() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return this.getMetadataValue(serviceInfo.getMetadata(), MAX_ALLOWED_FRAMES, Integer.MAX_VALUE, Integer.class);
    }

    public Long getMaxAnimatorRenderingTime() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return this.getMetadataValue(serviceInfo.getMetadata(), MAX_RENDERING_TIME, null, Long.class);
    }

    public Long getMaxRenderingSize() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return this.getMetadataValue(serviceInfo.getMetadata(), MAX_RENDERING_SIZE, null, Long.class);
    }

    public Integer getFramesDelay() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return this.getMetadataValue(serviceInfo.getMetadata(), FRAMES_DELAY, 1000, Integer.class);
    }

    public Boolean getLoopContinuously() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return this.getMetadataValue(serviceInfo.getMetadata(), LOOP_CONTINUOUSLY, LOOP_CONTINUOUSLY_DEFAULT, Boolean.class);
    }

    int getMetadataPercentage(MetadataMap metadata, String key, int defaultValue) {
        Integer parsedValue = (Integer)Converters.convert((Object)metadata.get((Object)key), Integer.class);
        if (parsedValue == null) {
            return defaultValue;
        }
        int value = parsedValue;
        if (value < 0 || value > 100) {
            LOGGER.warning("Invalid percertage value for '" + key + "', it should be between 0 and 100");
            return defaultValue;
        }
        return value;
    }

    <T> T getMetadataValue(MetadataMap metadata, String key, T defaultValue, Class<T> clazz) {
        Object parsedValue = Converters.convert((Object)metadata.get((Object)key), clazz);
        if (parsedValue == null) {
            return defaultValue;
        }
        return (T)parsedValue;
    }

    public int getNumDecimals() {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        return global.getNumDecimals();
    }

    public String getNameSpacePrefix(String nsUri) {
        Catalog catalog = this.getCatalog();
        NamespaceInfo ns = catalog.getNamespaceByURI(nsUri);
        return ns == null ? null : ns.getPrefix();
    }

    public int getMaxBuffer() {
        return this.getServiceInfo().getMaxBuffer();
    }

    public int getMaxRequestMemory() {
        return this.getServiceInfo().getMaxRequestMemory();
    }

    public int getMaxRenderingTime() {
        return this.getServiceInfo().getMaxRenderingTime();
    }

    public int getMaxRenderingErrors() {
        return this.getServiceInfo().getMaxRenderingErrors();
    }

    public String getKmlReflectorMode() {
        String value = (String)((Object)this.getServiceInfo().getMetadata().get((Object)KML_REFLECTOR_MODE));
        return value != null ? value : "refresh";
    }

    public String getKmlSuperoverlayMode() {
        String value = (String)((Object)this.getServiceInfo().getMetadata().get((Object)KML_SUPEROVERLAY_MODE));
        return value != null ? value : "auto";
    }

    public boolean getKmlKmAttr() {
        Boolean kmAttr = (Boolean)Converters.convert((Object)this.getServiceInfo().getMetadata().get((Object)KML_KMLATTR), Boolean.class);
        return kmAttr == null ? true : kmAttr;
    }

    public boolean getKmlPlacemark() {
        Boolean kmAttr = (Boolean)Converters.convert((Object)this.getServiceInfo().getMetadata().get((Object)KML_KMLPLACEMARK), Boolean.class);
        return kmAttr == null ? false : kmAttr;
    }

    public int getKmScore() {
        return this.getMetadataPercentage(this.getServiceInfo().getMetadata(), KML_KMSCORE, 40);
    }

    public Collection<GetMapOutputFormat> getAvailableMapFormats() {
        return WMSExtensions.findMapProducers(this.applicationContext);
    }

    public Set<String> getAvailableMapFormatNames() {
        List<GetMapOutputFormat> producers = WMSExtensions.findMapProducers(this.applicationContext);
        HashSet<String> formats = new HashSet<String>();
        for (GetMapOutputFormat producer : producers) {
            formats.addAll(producer.getOutputFormatNames());
        }
        return formats;
    }

    public Set<String> getAvailableLegendGraphicsFormats() {
        List<GetLegendGraphicOutputFormat> formats = WMSExtensions.findLegendGraphicFormats(this.applicationContext);
        HashSet<String> mimeTypes = new HashSet<String>();
        for (GetLegendGraphicOutputFormat format : formats) {
            mimeTypes.add(format.getContentType());
        }
        return mimeTypes;
    }

    public List<ExtendedCapabilitiesProvider> getAvailableExtendedCapabilitiesProviders() {
        return WMSExtensions.findExtendedCapabilitiesProviders(this.applicationContext);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public GetFeatureInfoOutputFormat getFeatureInfoOutputFormat(String requestFormat) {
        List<GetFeatureInfoOutputFormat> outputFormats = WMSExtensions.findFeatureInfoFormats(this.applicationContext);
        for (GetFeatureInfoOutputFormat format : outputFormats) {
            if (!format.canProduce(requestFormat)) continue;
            return format;
        }
        return null;
    }

    public List<String> getAvailableFeatureInfoFormats() {
        List<GetFeatureInfoOutputFormat> outputFormats = WMSExtensions.findFeatureInfoFormats(this.applicationContext);
        ArrayList<String> mimeTypes = new ArrayList<String>(outputFormats.size());
        for (GetFeatureInfoOutputFormat format : outputFormats) {
            mimeTypes.add(format.getContentType());
        }
        return mimeTypes;
    }

    public GetMapOutputFormat getMapOutputFormat(String mimeType) {
        GetMapOutputFormat outputFormat = WMSExtensions.findMapProducer(mimeType, this.applicationContext);
        return outputFormat;
    }

    public GetLegendGraphicOutputFormat getLegendGraphicOutputFormat(String outputFormat) {
        GetLegendGraphicOutputFormat format = WMSExtensions.findLegendGraphicFormat(outputFormat, this.applicationContext);
        return format;
    }

    public static Version version(String version) {
        return WMS.version(version, false);
    }

    public static Version version(String version, boolean exact) {
        if (version == null || version.trim().length() == 0) {
            return null;
        }
        if (VERSION_1_1_1.toString().equals(version)) {
            return VERSION_1_1_1;
        }
        if (VERSION_1_3_0.toString().equals(version)) {
            return VERSION_1_3_0;
        }
        return exact ? null : new Version(version);
    }

    public static String toInternalSRS(String srs, Version version) {
        if (VERSION_1_3_0.equals((Object)version) && srs != null && srs.toUpperCase().startsWith("EPSG:")) {
            srs = srs.toUpperCase().replace("EPSG:", "urn:x-ogc:def:crs:EPSG:");
        }
        return srs;
    }

    public boolean isQueryable(LayerInfo layer) {
        block4: {
            WMSLayerInfo info;
            block5: {
                try {
                    if (!(layer.getResource() instanceof WMSLayerInfo)) break block4;
                    info = (WMSLayerInfo)layer.getResource();
                    Layer wl = info.getWMSLayer(null);
                    if (wl.isQueryable()) break block5;
                    return false;
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, "Failed to determin if the layer is queryable, assuming it's not", e);
                    return false;
                }
            }
            WMSCapabilities caps = info.getStore().getWebMapServer(null).getCapabilities();
            if (caps.getRequest().getGetFeatureInfo().getFormats().contains("application/vnd.ogc.gml")) break block4;
            return false;
        }
        return layer.isQueryable();
    }

    public Integer getCascadedHopCount(LayerInfo layer) {
        if (!(layer.getResource() instanceof WMSLayerInfo)) {
            return null;
        }
        WMSLayerInfo wmsLayerInfo = (WMSLayerInfo)layer.getResource();
        int cascaded = 1;
        try {
            Layer wmsLayer = wmsLayerInfo.getWMSLayer(null);
            cascaded = 1 + wmsLayer.getCascaded();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Unable to determina WMSLayer cascaded hop count", e);
        }
        return cascaded;
    }

    public boolean isQueryable(LayerGroupInfo layerGroup) {
        for (LayerInfo layer : layerGroup.getLayers()) {
            if (this.isQueryable(layer)) continue;
            return false;
        }
        return true;
    }

    public GeneralParameterValue[] getWMSReadParameters(GetMapRequest request, MapLayerInfo mapLayerInfo, Filter layerFilter, AbstractGridCoverage2DReader reader, boolean readGeom) {
        double elevationValue;
        boolean hasElevation;
        ParameterValueGroup readParametersDescriptor = reader.getFormat().getReadParameters();
        GeneralParameterValue[] readParameters = CoverageUtils.getParameters((ParameterValueGroup)readParametersDescriptor, (Map)mapLayerInfo.getCoverage().getParameters(), (boolean)readGeom);
        List<Date> dateTime = request.getTime();
        boolean hasTime = dateTime != null && dateTime.size() > 0;
        List parameterDescriptors = readParametersDescriptor.getDescriptor().descriptors();
        if (hasTime) {
            readParameters = CoverageUtils.mergeParameter((List)parameterDescriptors, (GeneralParameterValue[])readParameters, request.getTime(), (String[])new String[]{"TIME", "Time"});
        }
        boolean bl = hasElevation = !Double.isNaN(elevationValue = request.getElevation());
        if (hasElevation) {
            readParameters = CoverageUtils.mergeParameter((List)parameterDescriptors, (GeneralParameterValue[])readParameters, (Object)request.getElevation(), (String[])new String[]{"ELEVATION", "Elevation"});
        }
        if (layerFilter != null) {
            readParameters = CoverageUtils.mergeParameter((List)parameterDescriptors, (GeneralParameterValue[])readParameters, (Object)layerFilter, (String[])new String[]{"FILTER", "Filter"});
        }
        return readParameters;
    }

    public Collection<RenderedImageMapResponse> getAvailableMapResponses() {
        return WMSExtensions.findMapResponses(this.applicationContext);
    }

    public static WMS get() {
        return (WMS)GeoServerExtensions.bean(WMS.class);
    }
}

