/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.geom.NoninvertibleTransformException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.util.logging.Logging;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;

public class RenderExceptionStrategy
implements RenderListener {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.wms");
    private final GTRenderer renderer;
    private Exception renderException;

    public RenderExceptionStrategy(GTRenderer renderer) {
        this.renderer = renderer;
        this.renderException = null;
    }

    public boolean exceptionOccurred() {
        return this.renderException != null;
    }

    public Exception getException() {
        return this.renderException;
    }

    public void errorOccurred(Exception renderException) {
        Throwable cause = renderException;
        while (cause != null) {
            if (cause instanceof TransformException || cause instanceof IllegalAttributeException || cause instanceof FactoryException || cause instanceof NoninvertibleTransformException) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Ignoring renderer error", renderException);
                }
                return;
            }
            cause = cause.getCause();
        }
        LOGGER.log(Level.FINE, "Got an unexpected render exception.", renderException);
        this.renderException = renderException;
        this.renderer.stopRendering();
    }

    public void featureRenderer(SimpleFeature feature) {
    }
}

