/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class RemoteOWSTestSupport {
    public static final String TOPP_STATES = "topp:states";
    public static final String WFS_SERVER_URL = "http://demo.opengeo.org/geoserver/wfs?";
    public static final String REMOTE_OWS_USER_STYLE_URL = "http://sigma.openplans.org:8080/geoserver/wfs?";
    static Boolean remoteStatesAvailable;

    public static boolean isRemoteStatesAvailable(Logger logger) {
        if (remoteStatesAvailable == null) {
            try {
                WFSDataStoreFactory factory = new WFSDataStoreFactory();
                HashMap<String, Serializable> params = new HashMap<String, Serializable>(factory.getImplementationHints());
                URL url = new URL("http://demo.opengeo.org/geoserver/wfs?service=WFS&request=GetCapabilities");
                params.put(WFSDataStoreFactory.URL.key, url);
                params.put(WFSDataStoreFactory.TRY_GZIP.key, Boolean.TRUE);
                params.put(WFSDataStoreFactory.TIMEOUT.key, Integer.valueOf(5000));
                WFSDataStore remoteStore = factory.createDataStore(params);
                FeatureSource fs = remoteStore.getFeatureSource(TOPP_STATES);
                remoteStatesAvailable = Boolean.TRUE;
                DefaultQuery dq = new DefaultQuery(TOPP_STATES);
                FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
                dq.setFilter((Filter)ff.greater((Expression)ff.property("PERSONS"), (Expression)ff.literal(20000000)));
                FeatureCollection fc = fs.getFeatures((Query)dq);
                if (fc.size() != 1) {
                    logger.log(Level.WARNING, "Remote database status invalid, there should be one and only one feature with more than 20M persons in topp:states");
                    remoteStatesAvailable = Boolean.FALSE;
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Skipping remote OWS test, either demo  is down or the topp:states layer is not there", e);
                remoteStatesAvailable = Boolean.FALSE;
            }
        }
        return remoteStatesAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRemoteOwsUserStyleAvailable(Logger logger) {
        InputStream input = null;
        try {
            URL url = new URL("http://sigma.openplans.org:8080/geoserver/wfs?service=WFS&request=GetCapabilities");
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            input = connection.getInputStream();
            if (input.read() < 0) {
                throw new IOException("Unexpected end of input stream");
            }
            logger.info("RemoteOWS user style appears to be available");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "RemoteOWS user style not available", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

