/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Envelope;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.util.WMSRequests;
import org.geotools.data.FeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.Translator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.map.kml.KMLTransformerBase;
import org.vfny.geoserver.wms.responses.map.kml.KMLUtils;
import org.xml.sax.ContentHandler;

public class KMLSuperOverlayTransformer
extends KMLTransformerBase {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.kml");
    final WMSMapContext mapContext;

    public KMLSuperOverlayTransformer(WMSMapContext mapContext) {
        this.mapContext = mapContext;
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new KMLSuperOverlayerTranslator(handler);
    }

    class KMLSuperOverlayerTranslator
    extends KMLTransformerBase.KMLTranslatorSupport {
        public KMLSuperOverlayerTranslator(ContentHandler contentHandler) {
            super(KMLSuperOverlayTransformer.this, contentHandler);
        }

        public void encode(Object o) throws IllegalArgumentException {
            MapLayer mapLayer = (MapLayer)o;
            ReferencedEnvelope extent = KMLSuperOverlayTransformer.this.mapContext.getAreaOfInterest();
            Envelope top = KMLUtils.expandToTile((Envelope)extent);
            int i = KMLUtils.findZoomLevel((Envelope)extent);
            LOGGER.fine("request = " + extent);
            LOGGER.fine("top level = " + top);
            if (KMLSuperOverlayTransformer.this.isStandAlone()) {
                this.start("kml");
            }
            this.start("Document");
            this.encodeRegion(top, 256, -1);
            if (top != KMLUtils.WORLD_BOUNDS_WGS84) {
                Envelope e00 = new Envelope(top.getMinX(), top.getMinX() + top.getWidth() / 2.0, top.getMaxY() - top.getHeight() / 2.0, top.getMaxY());
                Envelope e01 = new Envelope(e00.getMaxX(), top.getMaxX(), e00.getMinY(), e00.getMaxY());
                Envelope e10 = new Envelope(e00.getMinX(), e00.getMaxX(), top.getMinY(), e00.getMinY());
                Envelope e11 = new Envelope(e01.getMinX(), e01.getMaxX(), e10.getMinY(), e10.getMaxY());
                this.encodeNetworkLink(e00, "00", mapLayer);
                this.encodeNetworkLink(e01, "01", mapLayer);
                this.encodeNetworkLink(e10, "10", mapLayer);
                this.encodeNetworkLink(e11, "11", mapLayer);
            } else {
                Envelope e0 = new Envelope(top.getMinX(), top.getMinX() + top.getWidth() / 2.0, top.getMinY(), top.getMaxY());
                Envelope e1 = new Envelope(e0.getMaxX(), top.getMaxX(), top.getMinY(), top.getMaxY());
                this.encodeNetworkLink(e0, "0", mapLayer);
                this.encodeNetworkLink(e1, "1", mapLayer);
            }
            if (top == KMLUtils.WORLD_BOUNDS_WGS84) {
                this.encodeTileForViewing(mapLayer, i, new Envelope(-180.0, 0.0, -90.0, 90.0));
                this.encodeTileForViewing(mapLayer, i, new Envelope(0.0, 180.0, -90.0, 90.0));
            } else {
                this.encodeTileForViewing(mapLayer, i, top);
            }
            this.end("Document");
            if (KMLSuperOverlayTransformer.this.isStandAlone()) {
                this.end("kml");
            }
        }

        void encodeTileForViewing(MapLayer mapLayer, int drawOrder, Envelope box) {
            if (this.shouldDrawVectorLayer(mapLayer, box)) {
                this.encodeKMLLink(mapLayer, drawOrder, box);
            }
            if (this.shouldDrawWMSOverlay(mapLayer, box)) {
                this.encodeGroundOverlay(mapLayer, drawOrder, box);
            }
        }

        private boolean shouldDrawVectorLayer(MapLayer layer, Envelope box) {
            if (!this.isVectorLayer(layer)) {
                return false;
            }
            String overlayMode = (String)KMLSuperOverlayTransformer.this.mapContext.getRequest().getFormatOptions().get("overlayMode");
            if ("raster".equals(overlayMode)) {
                return false;
            }
            if ("overview".equals(overlayMode)) {
                return this.featuresInTile(layer, box, false) <= this.getRegionateFeatureLimit(this.getFeatureTypeInfo(layer));
            }
            return this.featuresInTile(layer, box, true) > 0;
        }

        private int getRegionateFeatureLimit(FeatureTypeInfo ft) {
            Integer regionateFeatureLimit = (Integer)ft.getMetadata().get("kml.regionateFeatureLimit", Integer.class);
            return regionateFeatureLimit != null ? regionateFeatureLimit : -1;
        }

        private boolean shouldDrawWMSOverlay(MapLayer layer, Envelope box) {
            if (!this.isVectorLayer(layer)) {
                return true;
            }
            String overlayMode = (String)KMLSuperOverlayTransformer.this.mapContext.getRequest().getFormatOptions().get("overlayMode");
            if ("hybrid".equals(overlayMode) || "raster".equals(overlayMode)) {
                return true;
            }
            if ("overview".equals(overlayMode)) {
                return this.featuresInTile(layer, box, false) > this.getRegionateFeatureLimit(this.getFeatureTypeInfo(layer));
            }
            return false;
        }

        void encodeKMLLink(MapLayer mapLayer, int drawOrder, Envelope box) {
            CaseInsensitiveMap fo = new CaseInsensitiveMap(new HashMap());
            fo.putAll(KMLSuperOverlayTransformer.this.mapContext.getRequest().getFormatOptions());
            fo.remove((Object)"superoverlay");
            String overlayMode = (String)fo.get((Object)"overlayMode");
            if ("overview".equalsIgnoreCase(overlayMode)) {
                fo.remove((Object)"regionateBy");
            } else if (!fo.containsKey((Object)"regionateBy")) {
                fo.put((Object)"regionateBy", (Object)"auto");
            }
            String foEncoded = WMSRequests.encodeFormatOptions((Map)fo);
            this.start("NetworkLink");
            this.element("visibility", "1");
            this.start("Link");
            this.element("href", KMLUtils.getMapUrl(KMLSuperOverlayTransformer.this.mapContext, mapLayer, 0, box, new String[]{"width", "256", "height", "256", "format_options", foEncoded, "superoverlay", "false"}, true));
            this.end("Link");
            this.encodeRegion(box, 128, -1);
            this.end("NetworkLink");
        }

        boolean isVectorLayer(MapLayer layer) {
            int index = Arrays.asList(KMLSuperOverlayTransformer.this.mapContext.getLayers()).indexOf(layer);
            MapLayerInfo info = KMLSuperOverlayTransformer.this.mapContext.getRequest().getLayers()[index];
            return info.getType() == MapLayerInfo.TYPE_VECTOR || info.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR;
        }

        private FeatureTypeInfo getFeatureTypeInfo(MapLayer layer) {
            for (MapLayerInfo info : KMLSuperOverlayTransformer.this.mapContext.getRequest().getLayers()) {
                if (!info.getName().equals(layer.getTitle())) continue;
                return info.getFeature();
            }
            return null;
        }

        private int featuresInTile(MapLayer mapLayer, Envelope bounds, boolean regionate) {
            if (!this.isVectorLayer(mapLayer)) {
                return 1;
            }
            Envelope originalBounds = KMLSuperOverlayTransformer.this.mapContext.getRequest().getBbox();
            KMLSuperOverlayTransformer.this.mapContext.getRequest().setBbox(bounds);
            KMLSuperOverlayTransformer.this.mapContext.setAreaOfInterest(bounds);
            String originalRegionateBy = null;
            if (regionate && (originalRegionateBy = (String)KMLSuperOverlayTransformer.this.mapContext.getRequest().getFormatOptions().get("regionateby")) == null) {
                KMLSuperOverlayTransformer.this.mapContext.getRequest().getFormatOptions().put("regionateby", "auto");
            }
            int numFeatures = 0;
            try {
                numFeatures = KMLUtils.loadFeatureCollection((FeatureSource<SimpleFeatureType, SimpleFeature>)mapLayer.getFeatureSource(), mapLayer, KMLSuperOverlayTransformer.this.mapContext).size();
            }
            catch (WmsException e) {
                LOGGER.severe("Caught the WmsException!");
                numFeatures = -1;
            }
            catch (HttpErrorCodeException e) {
                if (e.getErrorCode() == 204) {
                    KMLSuperOverlayTransformer.this.mapContext.getRequest().getFormatOptions().remove("regionateby");
                    numFeatures = 0;
                } else {
                    LOGGER.log(Level.WARNING, "Failure while checking whether a regionated child tile contained features!", e);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failure while checking whether a regionated child tile contained features!", e);
            }
            KMLSuperOverlayTransformer.this.mapContext.getRequest().setBbox(originalBounds);
            KMLSuperOverlayTransformer.this.mapContext.setAreaOfInterest(originalBounds);
            if (regionate && originalRegionateBy == null) {
                KMLSuperOverlayTransformer.this.mapContext.getRequest().getFormatOptions().remove("regionateby");
            }
            return numFeatures;
        }

        void encodeGroundOverlay(MapLayer mapLayer, int drawOrder, Envelope box) {
            this.start("GroundOverlay");
            this.element("drawOrder", "" + drawOrder);
            this.start("Icon");
            String href = KMLUtils.getMapUrl(KMLSuperOverlayTransformer.this.mapContext, mapLayer, 0, box, new String[]{"width", "256", "height", "256", "format", "image/png", "transparent", "true"}, true);
            this.element("href", href);
            LOGGER.fine(href);
            this.end("Icon");
            this.encodeRegion(box, 256, 512);
            this.encodeLatLonBox(box);
            this.end("GroundOverlay");
        }

        void encodeRegion(Envelope box, int minLodPixels, int maxLodPixels) {
            this.start("Region");
            this.start("Lod");
            this.element("minLodPixels", "128");
            this.element("maxLodPixels", "" + maxLodPixels);
            this.end("Lod");
            this.encodeLatLonAltBox(box);
            this.end("Region");
        }

        void encodeNetworkLink(Envelope box, String name, MapLayer mapLayer) {
            this.start("NetworkLink");
            this.element("name", name);
            this.encodeRegion(box, 512, -1);
            this.start("Link");
            String getMap = KMLUtils.getMapUrl(KMLSuperOverlayTransformer.this.mapContext, mapLayer, 0, box, new String[]{"format", "application/vnd.google-earth.kml+xml", "width", "256", "height", "256", "superoverlay", "true"}, false);
            this.element("href", getMap);
            LOGGER.fine("Network link " + name + ":" + getMap);
            this.element("viewRefreshMode", "onRegion");
            this.end("Link");
            this.end("NetworkLink");
        }

        void encodeLatLonAltBox(Envelope box) {
            this.start("LatLonAltBox");
            this.encodeBox(box);
            this.end("LatLonAltBox");
        }

        void encodeLatLonBox(Envelope box) {
            this.start("LatLonBox");
            this.encodeBox(box);
            this.end("LatLonBox");
        }

        void encodeBox(Envelope box) {
            this.element("north", String.valueOf(box.getMaxY()));
            this.element("south", String.valueOf(box.getMinY()));
            this.element("east", String.valueOf(box.getMaxX()));
            this.element("west", String.valueOf(box.getMinX()));
        }
    }
}

