/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.filter.function;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.TextSymbolizer;
import org.geotools.swing.JMapFrame;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.geotools.swing.wizard.JPage;
import org.geotools.swing.wizard.JWizard;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class CompoundLabel {
    public static void main(String[] args) throws Exception {
        File file = JFileDataStoreChooser.showOpenFile((String)"shp", null);
        if (file == null) {
            return;
        }
        CompoundLabel me = new CompoundLabel();
        me.displayShapefile(file);
    }

    private void displayShapefile(File file) throws Exception {
        FileDataStore store = FileDataStoreFinder.getDataStore((File)file);
        FeatureSource featureSource = store.getFeatureSource();
        Style style = this.createLabelStyle(featureSource);
        if (style != null) {
            DefaultMapContext map = new DefaultMapContext();
            map.setTitle("Compound feature labels");
            map.addLayer(featureSource, style);
            JMapFrame.showMap((MapContext)map);
        }
    }

    private Style createLabelStyle(FeatureSource featureSource) {
        FeatureType schema = featureSource.getSchema();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (PropertyDescriptor desc : schema.getDescriptors()) {
            if (!String.class.isAssignableFrom(desc.getType().getBinding())) continue;
            fieldNames.add(desc.getName().getLocalPart());
        }
        if (fieldNames.size() < 2) {
            JOptionPane.showMessageDialog(null, "This example needs a feature type with at least two String fields", "Bummer", 2);
            return null;
        }
        Style style = null;
        FieldWizard wizard = new FieldWizard(fieldNames);
        if (wizard.showModalDialog() == 0) {
            String[] fields = wizard.getSelections();
            style = SLD.createSimpleStyle((SimpleFeatureType)((SimpleFeatureType)schema), (Color)Color.CYAN);
            StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            TextSymbolizer sym = sf.createTextSymbolizer();
            sym.setLabel((Expression)ff.function("Concatenate", new Expression[]{ff.property(fields[0]), ff.literal((Object)":"), ff.property(fields[1])}));
            SLD.rules((Style)style)[0].symbolizers().add(sym);
            return style;
        }
        return style;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FieldWizard
    extends JWizard {
        JComboBox field1CB;
        JComboBox field2CB;

        public FieldWizard(final List<String> items) {
            super("Fields for labels");
            JPage page = new JPage(){

                public JPanel createPanel() {
                    JPanel panel = super.createPanel();
                    panel.setLayout((LayoutManager)new MigLayout());
                    JLabel label1 = new JLabel("First label part");
                    panel.add((Component)label1, "wrap");
                    FieldWizard.this.field1CB = new JComboBox<Object>(items.toArray());
                    FieldWizard.this.field1CB.setEditable(false);
                    FieldWizard.this.field1CB.addActionListener((ActionListener)this.getJWizard().getController());
                    panel.add((Component)FieldWizard.this.field1CB, "gapbefore indent, wrap");
                    JLabel label2 = new JLabel("Second label part");
                    panel.add((Component)label2, "wrap");
                    FieldWizard.this.field2CB = new JComboBox<Object>(items.toArray());
                    FieldWizard.this.field2CB.setEditable(false);
                    FieldWizard.this.field2CB.addActionListener((ActionListener)this.getJWizard().getController());
                    panel.add((Component)FieldWizard.this.field2CB, "gapbefore indent, wrap");
                    return panel;
                }

                public boolean isValid() {
                    String field2;
                    String field1 = (String)FieldWizard.this.field1CB.getSelectedItem();
                    return !field1.equals(field2 = (String)FieldWizard.this.field2CB.getSelectedItem());
                }
            };
            page.setPageIdentifier("Default");
            this.registerWizardPanel(page);
        }

        public String[] getSelections() {
            String[] selections = new String[]{(String)this.field1CB.getSelectedItem(), (String)this.field2CB.getSelectedItem()};
            return selections;
        }
    }
}

