/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.coverage;

import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.demo.coverage.WritableGridCoverage2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.geometry.Envelope;

public class WritableGridDemo {
    private static final int WIDTH = 512;

    public static void main(String[] args) {
        GridCoverageFactory gcf = CoverageFactoryFinder.getGridCoverageFactory(null);
        float[][] data = new float[512][512];
        GridCoverage2D cov = gcf.create((CharSequence)"cov", data, (Envelope)new ReferencedEnvelope(0.0, 512.0, 0.0, 512.0, null));
        WritableGridCoverage2D writableCov = new WritableGridCoverage2D(cov);
        double centre = 256.0;
        for (int y = 0; y < 512; ++y) {
            double dy = ((double)y - centre) / centre;
            double dy2 = dy * dy;
            for (int x = 0; x < 512; ++x) {
                double dx = ((double)x - centre) / centre;
                double d = Math.sqrt(dx * dx + dy2);
                GridCoordinates2D coords = new GridCoordinates2D(x, y);
                writableCov.setValue(coords, (float)Math.sin(Math.PI * 8 * d));
            }
        }
        writableCov.show();
    }
}

