/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.data;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.GeoTools;
import org.opengis.feature.simple.SimpleFeature;

public class ShapefileRead2 {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File file;
        System.out.println("Welcome to GeoTools:" + GeoTools.getVersion());
        if (args.length == 0) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getPath().endsWith("shp") || f.getPath().endsWith("SHP");
                }

                public String getDescription() {
                    return "Shapefiles";
                }
            });
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal != 0) {
                System.exit(0);
            }
            System.out.println("You chose to open this file: " + chooser.getSelectedFile().getName());
            file = chooser.getSelectedFile();
        } else {
            file = new File(args[0]);
        }
        if (!file.exists()) {
            System.exit(1);
        }
        HashMap<String, URL> connect = new HashMap<String, URL>();
        connect.put("url", file.toURI().toURL());
        DataStore dataStore = DataStoreFinder.getDataStore(connect);
        String[] typeNames = dataStore.getTypeNames();
        String typeName = typeNames[0];
        System.out.println("Reading content " + typeName);
        SimpleFeatureSource featureSource = dataStore.getFeatureSource(typeName);
        SimpleFeatureCollection collection = featureSource.getFeatures();
        Iterator iterator = collection.iterator();
        int length = 0;
        try {
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                length = (int)((double)length + geometry.getLength());
            }
        }
        finally {
            collection.close(iterator);
        }
        System.out.println("Total length " + length);
    }
}

