/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterExamples {
    SimpleFeatureSource featureSource;

    SimpleFeatureCollection grabSelectedIds(Set<String> selection) throws IOException {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        HashSet<FeatureId> fids = new HashSet<FeatureId>();
        for (String id : selection) {
            FeatureId fid = ff.featureId(id);
            fids.add(fid);
        }
        Id filter = ff.id(fids);
        return this.featureSource.getFeatures((Filter)filter);
    }

    FeatureCollection grabSelectedName(String name) throws Exception {
        return this.featureSource.getFeatures(CQL.toFilter((String)("Name = '" + name + "'")));
    }

    FeatureCollection grabSelectedNameIgnoreCase(String name) throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        PropertyIsEqualTo filter = ff.equal((Expression)ff.property("Name"), (Expression)ff.literal((Object)name), false);
        return this.featureSource.getFeatures((Filter)filter);
    }

    FeatureCollection grabSelectedNames(Set<String> selectedNames) throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        ArrayList<PropertyIsEqualTo> match = new ArrayList<PropertyIsEqualTo>();
        for (String name : selectedNames) {
            PropertyIsEqualTo aMatch = ff.equals((Expression)ff.property("Name"), (Expression)ff.literal((Object)name));
            match.add(aMatch);
        }
        Or filter = ff.or(match);
        return this.featureSource.getFeatures((Filter)filter);
    }

    FeatureCollection grabFeaturesInBoundingBox(double x1, double y1, double x2, double y2) throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        FeatureType schema = this.featureSource.getSchema();
        String geometryPropertyName = schema.getGeometryDescriptor().getLocalName();
        CoordinateReferenceSystem crs = schema.getGeometryDescriptor().getCoordinateReferenceSystem();
        ReferencedEnvelope bbox = new ReferencedEnvelope(x1, y1, x2, y2, crs);
        BBOX filter = ff.bbox((Expression)ff.property(geometryPropertyName), (BoundingBox)bbox);
        return this.featureSource.getFeatures((Filter)filter);
    }
}

