/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.filter.function;

import java.io.File;
import java.net.URL;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.swing.ExceptionMonitor;
import org.geotools.swing.JMapFrame;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DynamicFillColor {
    private static final float SATURATION = 0.8f;
    private static final float BRIGHTNESS = 0.8f;
    private FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    private StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);

    public Style createColorRampStyle(String attrName, float minValue, float maxValue, boolean logValues) {
        Style style = this.styleFactory.createStyle();
        Object valueExpr = null;
        valueExpr = logValues ? this.filterFactory.function("log", new Expression[]{this.filterFactory.property(attrName)}) : this.filterFactory.property(attrName);
        Function colorRampFn = this.filterFactory.function("colorramp", new Expression[]{valueExpr, this.filterFactory.literal(minValue), this.filterFactory.literal(maxValue), this.filterFactory.literal(0.8f), this.filterFactory.literal(0.8f)});
        Fill fill = this.styleFactory.createFill((Expression)colorRampFn);
        Stroke stroke = this.styleFactory.createStroke((Expression)colorRampFn, (Expression)this.filterFactory.literal(1.0));
        PolygonSymbolizer symbolizer = this.styleFactory.createPolygonSymbolizer(stroke, fill, "the_geom");
        Rule rule = this.styleFactory.createRule();
        rule.symbolizers().add(symbolizer);
        FeatureTypeStyle fts = this.styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        style.featureTypeStyles().add(fts);
        return style;
    }

    private Style createFromSLD(URL url) {
        String path = url.getPath();
        int dot = path.lastIndexOf(46);
        File sld = new File(path.substring(0, dot) + ".sld");
        Object style = null;
        try {
            SLDParser stylereader = new SLDParser(this.styleFactory, sld.toURI().toURL());
            Style[] styles = stylereader.readXML();
            return styles[0];
        }
        catch (Exception e) {
            ExceptionMonitor.show(null, (Throwable)e, (String)"Problem creating style");
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        DynamicFillColor me = new DynamicFillColor();
        me.demo();
    }

    private void demo() throws Exception {
        URL url = DynamicFillColor.class.getResource("/data/shapefiles/countries.shp");
        ShapefileDataStore shapefile = new ShapefileDataStore(url);
        String typeName = shapefile.getTypeNames()[0];
        SimpleFeatureSource featureSource = shapefile.getFeatureSource(typeName);
        FeatureType schema = featureSource.getSchema();
        CoordinateReferenceSystem crs = schema.getCoordinateReferenceSystem();
        Style style = null;
        style = this.createColorRampStyle("POP_CNTRY", 5.0f, 22.0f, true);
        DefaultMapContext map = new DefaultMapContext(crs);
        map.addLayer((FeatureSource)featureSource, style);
        JMapFrame.showMap((MapContext)map);
    }
}

