/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.grid;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.Envelopes;
import org.geotools.grid.GridElement;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.Grids;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.styling.SLD;
import org.geotools.swing.JMapFrame;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;

public class IntersectionExample {
    public static void main(String[] args) throws Exception {
        URL url = IntersectionExample.class.getResource("/data/shapefiles/oz.shp");
        FileDataStore dataStore = FileDataStoreFinder.getDataStore((URL)url);
        SimpleFeatureSource ozMapSource = dataStore.getFeatureSource();
        double sideLen = 1.0;
        ReferencedEnvelope gridBounds = Envelopes.expandToInclude((ReferencedEnvelope)ozMapSource.getBounds(), (double)sideLen);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("grid");
        tb.add("element", Polygon.class, gridBounds.getCoordinateReferenceSystem());
        tb.add("id", Integer.class);
        SimpleFeatureType TYPE = tb.buildFeatureType();
        IntersectionBuilder builder = new IntersectionBuilder(TYPE, ozMapSource);
        SimpleFeatureSource grid = Grids.createHexagonalGrid((ReferencedEnvelope)gridBounds, (double)sideLen, (double)-1.0, (GridFeatureBuilder)builder);
        DefaultMapContext map = new DefaultMapContext();
        map.addLayer((FeatureSource)ozMapSource, SLD.createPolygonStyle((Color)Color.BLUE, (Color)Color.CYAN, (float)1.0f));
        map.addLayer((FeatureSource)grid, null);
        JMapFrame.showMap((MapContext)map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntersectionBuilder
    extends GridFeatureBuilder {
        final FilterFactory2 ff2 = CommonFactoryFinder.getFilterFactory2(null);
        final GeometryFactory gf = JTSFactoryFinder.getGeometryFactory(null);
        final SimpleFeatureSource source;
        int id = 0;

        public IntersectionBuilder(SimpleFeatureType type, SimpleFeatureSource source) {
            super(type);
            this.source = source;
        }

        public void setAttributes(GridElement el, Map<String, Object> attributes) {
            attributes.put("id", ++this.id);
        }

        public boolean getCreateFeature(GridElement el) {
            Coordinate c = el.getCenter();
            Point p = this.gf.createPoint(c);
            Intersects filter = this.ff2.intersects((Expression)this.ff2.property("the_geom"), (Expression)this.ff2.literal((Object)p));
            boolean result = false;
            try {
                result = !this.source.getFeatures((Filter)filter).isEmpty();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            return result;
        }
    }
}

