/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.grid;

import java.awt.Color;
import java.net.URL;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.Envelopes;
import org.geotools.grid.Grids;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.CRS;
import org.geotools.styling.SLD;
import org.geotools.swing.JMapFrame;

public class ReprojectedGridExample {
    public static void main(String[] args) throws Exception {
        URL url = ReprojectedGridExample.class.getResource("/data/shapefiles/oz.shp");
        FileDataStore store = FileDataStoreFinder.getDataStore((URL)url);
        SimpleFeatureSource ozMapSource = store.getFeatureSource();
        double gridSize = 10.0;
        double vertexSpacing = gridSize / 20.0;
        ReferencedEnvelope gridBounds = Envelopes.expandToInclude((ReferencedEnvelope)ozMapSource.getBounds(), (double)gridSize);
        SimpleFeatureSource grid = Grids.createSquareGrid((ReferencedEnvelope)gridBounds, (double)gridSize, (double)vertexSpacing);
        DefaultMapContext map = new DefaultMapContext();
        map.setTitle("Vector grid");
        map.setCoordinateReferenceSystem(CRS.decode((String)"EPSG:4462", (boolean)true));
        map.addLayer((FeatureSource)ozMapSource, SLD.createPolygonStyle((Color)Color.BLUE, (Color)Color.CYAN, (float)1.0f));
        map.addLayer((FeatureSource)grid, SLD.createPolygonStyle((Color)Color.LIGHT_GRAY, null, (float)1.0f));
        JMapFrame.showMap((MapContext)map);
    }
}

