/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryExample {
    public void createPoint() {
        GeometryFactory gf = new GeometryFactory();
        Coordinate coord = new Coordinate(1.0, 1.0);
        Point point = gf.createPoint(coord);
        System.out.println(point);
    }

    public void wktWriter() {
        GeometryFactory gf = new GeometryFactory();
        Coordinate coord = new Coordinate(1.0, 1.0);
        Point point = gf.createPoint(coord);
        StringWriter writer = new StringWriter();
        WKTWriter wktWriter = new WKTWriter(2);
        try {
            wktWriter.write((Geometry)point, (Writer)writer);
        }
        catch (IOException e) {
            // empty catch block
        }
        String wkt = writer.toString();
        System.out.println(wkt);
    }

    public void parseWKT() {
        GeometryFactory geometryFactory = new GeometryFactory();
        WKTReader reader = new WKTReader(geometryFactory);
        Point point = null;
        try {
            point = (Point)reader.read("POINT (1 1)");
        }
        catch (ParseException e) {
            // empty catch block
        }
        System.out.println(point);
    }

    public static void main(String[] args) {
        ArrayList<String> examples = new ArrayList<String>();
        if (args.length == 0 || "-all".equalsIgnoreCase(args[0])) {
            for (Method method : GeometryExample.getExamples()) {
                examples.add(method.getName());
            }
        } else if ("-help".equalsIgnoreCase(args[0])) {
            System.out.println("Usage: java org.geotools.demo.jts.GeometryExample <example>");
            System.out.println("Where <example> is one of the following:");
            System.out.println("-help");
            System.out.println("-all");
            for (Method method : GeometryExample.getExamples()) {
                System.out.println(method.getName());
            }
            System.exit(0);
        } else {
            for (String arg : args) {
                examples.add(arg);
            }
        }
        GeometryExample example = new GeometryExample();
        for (Method method : GeometryExample.getExamples()) {
            if (!examples.contains(method.getName())) continue;
            System.out.println("Running example " + method.getName());
            try {
                method.invoke((Object)example, new Object[0]);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {}
        }
    }

    public static List<Method> getExamples() {
        ArrayList<Method> examples = new ArrayList<Method>();
        for (Method method : GeometryExample.class.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || method.getReturnType() != Void.TYPE || method.getParameterAnnotations().length != 0) continue;
            examples.add(method);
        }
        return examples;
    }
}

