/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.linearref.LinearLocation;
import com.vividsolutions.jts.linearref.LocationIndexedLine;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.Name;
import org.opengis.util.ProgressListener;

public class SnapToLine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Please provide a filename");
            return;
        }
        File file = new File(args[0]);
        System.out.println("Snapping against:" + file);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (file.getName().endsWith(".properties")) {
            Properties properties = new Properties();
            FileInputStream inStream = new FileInputStream(file);
            try {
                properties.load(inStream);
            }
            finally {
                inStream.close();
            }
            for (Map.Entry<Object, Object> property : properties.entrySet()) {
                params.put((String)property.getKey(), (String)property.getValue());
            }
        } else {
            params.put("url", file.toURI().toURL());
        }
        DataStore data = DataStoreFinder.getDataStore(params);
        List names = data.getNames();
        SimpleFeatureSource source = data.getFeatureSource((Name)names.get(0));
        STRtree index = new STRtree();
        SimpleFeatureCollection features = source.getFeatures();
        System.out.println("Slurping in features ...");
        features.accepts(new FeatureVisitor((SpatialIndex)index){
            final /* synthetic */ SpatialIndex val$index;
            {
                this.val$index = spatialIndex;
            }

            public void visit(Feature feature) {
                SimpleFeature simpleFeature = (SimpleFeature)feature;
                MultiLineString geom = (MultiLineString)simpleFeature.getDefaultGeometry();
                Envelope bounds = geom.getEnvelopeInternal();
                if (bounds.isNull()) {
                    return;
                }
                this.val$index.insert(bounds, (Object)new LocationIndexedLine((Geometry)geom));
            }
        }, (ProgressListener)new NullProgressListener());
        int DURATION = 6000;
        System.out.println("we now have our spatial index and are going to snap for 6000");
        ReferencedEnvelope limit = features.getBounds();
        Coordinate[] points = new Coordinate[10000];
        Random rand = new Random(file.hashCode());
        for (int i = 0; i < 10000; ++i) {
            points[i] = new Coordinate(limit.getMinX() + rand.nextDouble() * limit.getWidth(), limit.getMinY() + rand.nextDouble() * limit.getHeight());
        }
        double distance = limit.getSpan(0) / 100.0;
        long now = System.currentTimeMillis();
        long then = now + 6000L;
        int count = 0;
        System.out.println("we now have our spatial index and are going to snap for 6000");
        while (System.currentTimeMillis() < then) {
            Coordinate pt = points[rand.nextInt(10000)];
            Envelope search = new Envelope(pt);
            search.expandBy(distance);
            List hits = index.query(search);
            double d = Double.MAX_VALUE;
            Coordinate best = null;
            for (LocationIndexedLine line : hits) {
                LinearLocation here;
                Coordinate point = line.extractPoint(here = line.project(pt));
                double currentD = point.distance(pt);
                if (!(currentD < d)) continue;
                best = point;
            }
            if (best == null) {
                System.out.println(pt + "-X");
            } else {
                System.out.println(pt + "->" + best);
            }
            ++count;
        }
        System.out.println("snapped " + count + " times - and now I am tired");
        System.out.println("snapped " + count / 6000 + " per milli?");
    }
}

