/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.referencing;

import java.awt.RenderingHints;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.operation.DefiningConversion;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;

public class CTSTutorial {
    private CoordinateReferenceSystem nad27CRS = null;
    private CoordinateReferenceSystem utm10NCRS = null;

    CTSTutorial() {
        try {
            this.creatCRSFromWKT();
            this.createFromEPSGCode();
            this.createCRSByHand1();
            this.createCRSByHand2();
            this.createMathTransformBetweenCRSs();
            this.createAndUseMathTransform();
            this.hintExample();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void premadeObjects() {
        DefaultGeographicCRS geoCRS = DefaultGeographicCRS.WGS84;
        DefaultGeodeticDatum wgs84Datum = DefaultGeodeticDatum.WGS84;
        DefaultPrimeMeridian greenwichMeridian = DefaultPrimeMeridian.GREENWICH;
        DefaultCartesianCS cartCS = DefaultCartesianCS.GENERIC_2D;
        DefaultCoordinateSystemAxis latAxis = DefaultCoordinateSystemAxis.GEODETIC_LATITUDE;
    }

    void creatCRSFromWKT() throws Exception {
        System.out.println("------------------------------------------");
        System.out.println("Creating a CRS from a WKT string:");
        CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
        String wkt = "PROJCS[\"UTM_Zone_10N\", GEOGCS[\"WGS84\", DATUM[\"WGS84\", SPHEROID[\"WGS84\", 6378137.0, 298.257223563]], PRIMEM[\"Greenwich\", 0.0], UNIT[\"degree\",0.017453292519943295], AXIS[\"Longitude\",EAST], AXIS[\"Latitude\",NORTH]], PROJECTION[\"Transverse_Mercator\"], PARAMETER[\"semi_major\", 6378137.0], PARAMETER[\"semi_minor\", 6356752.314245179], PARAMETER[\"central_meridian\", -123.0], PARAMETER[\"latitude_of_origin\", 0.0], PARAMETER[\"scale_factor\", 0.9996], PARAMETER[\"false_easting\", 500000.0], PARAMETER[\"false_northing\", 0.0], UNIT[\"metre\",1.0], AXIS[\"x\",EAST], AXIS[\"y\",NORTH]]";
        CoordinateReferenceSystem crs = crsFactory.createFromWKT(wkt);
        System.out.println("  CRS: " + crs.toWKT());
        System.out.println("Identified CRS object:");
        this.printIdentifierStuff((IdentifiedObject)crs);
        System.out.println("Identified Datum object:");
        this.printIdentifierStuff((IdentifiedObject)((ProjectedCRS)crs).getDatum());
        System.out.println("------------------------------------------");
    }

    void createFromEPSGCode() throws Exception {
        System.out.println("------------------------------------------");
        System.out.println("Creating a CRS from an authority factory:");
        String code = "26910";
        CoordinateReferenceSystem crs = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"EPSG", null).createCoordinateReferenceSystem(code);
        System.out.println("  CRS: " + crs.toWKT());
        System.out.println("Identified CRS object:");
        this.printIdentifierStuff((IdentifiedObject)crs);
        System.out.println("------------------------------------------");
    }

    void createCRSByHand1() throws Exception {
        System.out.println("------------------------------------------");
        System.out.println("Creating a CRS by hand:");
        MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
        DefaultGeographicCRS geoCRS = DefaultGeographicCRS.WGS84;
        DefaultCartesianCS cartCS = DefaultCartesianCS.GENERIC_2D;
        ParameterValueGroup parameters = mtFactory.getDefaultParameters("Transverse_Mercator");
        parameters.parameter("central_meridian").setValue(-111.0);
        parameters.parameter("latitude_of_origin").setValue(0.0);
        parameters.parameter("scale_factor").setValue(0.9996);
        parameters.parameter("false_easting").setValue(500000.0);
        parameters.parameter("false_northing").setValue(0.0);
        DefiningConversion conversion = new DefiningConversion("Transverse_Mercator", parameters);
        Map<String, String> properties = Collections.singletonMap("name", "WGS 84 / UTM Zone 12N");
        ProjectedCRS projCRS = crsFactory.createProjectedCRS(properties, (GeographicCRS)geoCRS, (Conversion)conversion, (CartesianCS)cartCS);
        System.out.println("  Projected CRS: " + projCRS.toWKT());
        System.out.println("------------------------------------------");
        this.utm10NCRS = projCRS;
    }

    void createCRSByHand2() throws Exception {
        System.out.println("------------------------------------------");
        System.out.println("Creating a CRS by hand:");
        CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
        DatumFactory datumFactory = ReferencingFactoryFinder.getDatumFactory(null);
        CSFactory csFactory = ReferencingFactoryFinder.getCSFactory(null);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "Clarke 1866");
        Ellipsoid clark1866ellipse = datumFactory.createFlattenedSphere(map, 6378206.4, 294.978698213901, SI.METER);
        DefaultPrimeMeridian greenwichMeridian = DefaultPrimeMeridian.GREENWICH;
        BursaWolfParameters toWGS84 = new BursaWolfParameters((GeodeticDatum)DefaultGeodeticDatum.WGS84);
        toWGS84.dx = -3.0;
        toWGS84.dy = 142.0;
        toWGS84.dz = 183.0;
        map.clear();
        map.put("name", "North American Datum 1927");
        map.put("bursaWolf", (String)toWGS84);
        GeodeticDatum clark1866datum = datumFactory.createGeodeticDatum(map, clark1866ellipse, (PrimeMeridian)greenwichMeridian);
        System.out.println(clark1866datum.toWKT());
        System.out.println("Identified Datum object:");
        this.printIdentifierStuff((IdentifiedObject)clark1866datum);
        map.clear();
        map.put("name", "<lat>, <long>");
        DefaultCoordinateSystemAxis latAxis = DefaultCoordinateSystemAxis.GEODETIC_LATITUDE;
        DefaultCoordinateSystemAxis longAxis = DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE;
        EllipsoidalCS ellipsCS = csFactory.createEllipsoidalCS(map, (CoordinateSystemAxis)latAxis, (CoordinateSystemAxis)longAxis);
        map.clear();
        map.put("name", "NAD 27");
        map.put("authority", "9999");
        GeographicCRS nad27CRS = crsFactory.createGeographicCRS(map, clark1866datum, ellipsCS);
        System.out.println(nad27CRS.toWKT());
        System.out.println("Identified CRS object:");
        this.printIdentifierStuff((IdentifiedObject)nad27CRS);
        System.out.println("------------------------------------------");
        this.nad27CRS = nad27CRS;
    }

    void createCRSByHand3() throws FactoryException {
        System.out.println("------------------------------------------");
        System.out.println("Creating two CRSs by hand:");
        CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
        DatumFactory datumFactory = ReferencingFactoryFinder.getDatumFactory(null);
        CSFactory csFactory = ReferencingFactoryFinder.getCSFactory(null);
        HashMap<String, String> map = new HashMap<String, String>();
        map.clear();
        map.put("name", "Greenwich Meridian");
        PrimeMeridian greenwichMeridian = datumFactory.createPrimeMeridian(map, 0.0, NonSI.DEGREE_ANGLE);
        map.clear();
        map.put("name", "WGS 84 Ellipsoid Datum");
        Ellipsoid wgs84Ellipsoid = datumFactory.createFlattenedSphere(map, 6378137.0, 298.257223563, SI.METER);
        map.clear();
        map.put("name", "WGS84 Height Datum");
        GeodeticDatum wgs84Datum = datumFactory.createGeodeticDatum(map, wgs84Ellipsoid, greenwichMeridian);
        map.clear();
        map.put("name", "Cartesian X axis");
        CoordinateSystemAxis xAxis = csFactory.createCoordinateSystemAxis(map, "X", AxisDirection.GEOCENTRIC_X, SI.METER);
        map.clear();
        map.put("name", "Cartesian Y axis");
        CoordinateSystemAxis yAxis = csFactory.createCoordinateSystemAxis(map, "Y", AxisDirection.GEOCENTRIC_Y, SI.METER);
        map.clear();
        map.put("name", "Cartesian Z axis");
        CoordinateSystemAxis zAxis = csFactory.createCoordinateSystemAxis(map, "Z", AxisDirection.GEOCENTRIC_Z, SI.METER);
        map.clear();
        map.put("name", "Rendered Cartesian CS");
        CartesianCS worldCS = csFactory.createCartesianCS(map, xAxis, yAxis, zAxis);
        map.clear();
        map.put("name", "Output Cartesian CS");
        GeocentricCRS geocentricCRS = crsFactory.createGeocentricCRS(map, wgs84Datum, worldCS);
        System.out.println("Geocentric CRS: " + geocentricCRS.toWKT());
        map.clear();
        map.put("name", "Geodetic North axis");
        CoordinateSystemAxis northAxis = csFactory.createCoordinateSystemAxis(map, "N", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
        map.clear();
        map.put("name", "Geodetic East axis");
        CoordinateSystemAxis eastAxis = csFactory.createCoordinateSystemAxis(map, "E", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
        map.clear();
        map.put("name", "Geodetic Height axis");
        CoordinateSystemAxis heightAxis = csFactory.createCoordinateSystemAxis(map, "Up", AxisDirection.UP, SI.METER);
        map.clear();
        map.put("name", "<long>,<lat> Airy 1830 geodetic");
        EllipsoidalCS airyCS = csFactory.createEllipsoidalCS(map, eastAxis, northAxis, heightAxis);
        GeographicCRS airyCRS = crsFactory.createGeographicCRS(map, wgs84Datum, airyCS);
        System.out.println("Geographic CRS: " + airyCRS.toString());
        System.out.println("Identified CRS object:");
        this.printIdentifierStuff((IdentifiedObject)airyCRS);
        System.out.println("Identified Datum object:");
        this.printIdentifierStuff((IdentifiedObject)airyCRS.getDatum());
        System.out.println("------------------------------------------");
    }

    void createMathTransformBetweenCRSs() throws Exception {
        System.out.println("------------------------------------------");
        System.out.println("Creating a math transform between two CRSs:");
        CoordinateOperationFactory coFactory = ReferencingFactoryFinder.getCoordinateOperationFactory(null);
        CoordinateReferenceSystem sourceCRS = this.nad27CRS;
        CoordinateReferenceSystem targetCRS = this.utm10NCRS;
        CoordinateOperation op = coFactory.createOperation(sourceCRS, targetCRS);
        MathTransform trans = op.getMathTransform();
        System.out.println("Math Transform: " + trans.toWKT());
        GeneralDirectPosition pt = new GeneralDirectPosition(45.1, -120.0);
        System.out.println("Input point: " + pt);
        pt = trans.transform((DirectPosition)pt, null);
        System.out.println("Output point: " + pt);
        System.out.println("Inverse of output point: " + trans.inverse().transform((DirectPosition)pt, null));
        System.out.println("------------------------------------------");
    }

    void transformUsingCRSUtility() throws Exception {
        System.out.println("------------------------------------------");
        System.out.println("Using the CRS utility to create a math transform between two CRSs:");
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)"EPSG:4978");
        CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:4979");
        System.out.println("Source CRS: " + sourceCRS.getName().getCode());
        System.out.println("Target CRS: " + targetCRS.getName().getCode());
        MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
        System.out.println("MT: " + mathTransform.toWKT());
        GeneralDirectPosition pt = new GeneralDirectPosition(4089881.3, -4874130.7, 441946.6);
        System.out.println("Input point: " + pt);
        pt = mathTransform.transform((DirectPosition)pt, null);
        System.out.println("Output point: " + pt);
        System.out.println("------------------------------------------");
    }

    void createAndUseMathTransform() throws FactoryException, MismatchedDimensionException, TransformException {
        System.out.println("------------------------------------------");
        System.out.println("Creating a math transform by hand:");
        MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        ParameterValueGroup params = mtFactory.getDefaultParameters("Hotine_Oblique_Mercator");
        params.parameter("semi_major").setValue(6377298.556);
        params.parameter("semi_minor").setValue(6356097.5503009);
        params.parameter("longitude_of_center").setValue(115.0);
        params.parameter("latitude_of_center").setValue(4.0);
        params.parameter("azimuth").setValue(53.3158204722222);
        params.parameter("rectified_grid_angle").setValue(53.1301023611111);
        params.parameter("scale_factor").setValue(0.99984);
        params.parameter("false_easting").setValue(0.0);
        params.parameter("false_northing").setValue(0.0);
        MathTransform trans = mtFactory.createParameterizedTransform(params);
        System.out.println("Math Transform: " + trans.toWKT());
        GeneralDirectPosition pt = new GeneralDirectPosition(120.0, 6.0);
        System.out.println("Input point: " + pt);
        pt = trans.transform((DirectPosition)pt, null);
        System.out.println("Output point: " + pt);
        System.out.println("Inverse of output point: " + trans.inverse().transform((DirectPosition)pt, null));
        System.out.println("------------------------------------------");
    }

    void hintExample() throws Exception {
        System.out.println("------------------------------------------");
        System.out.println("Using hints to create a transform without a datum shift:");
        String sourceCode = "31300";
        String targetCode = "27591";
        Hints hints = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
        CRSAuthorityFactory crsFactory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"EPSG", (Hints)hints);
        CoordinateReferenceSystem sourceCRS = crsFactory.createCoordinateReferenceSystem(sourceCode);
        CoordinateReferenceSystem targetCRS = crsFactory.createCoordinateReferenceSystem(targetCode);
        CoordinateOperationFactory opFactory = ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)hints);
        MathTransform mt = opFactory.createOperation(sourceCRS, targetCRS).getMathTransform();
        System.out.println("Math Transform: " + mt.toWKT());
        System.out.println("------------------------------------------");
    }

    void createOperationFromAuthorityCode() throws Exception {
        CoordinateOperationAuthorityFactory coaf = ReferencingFactoryFinder.getCoordinateOperationAuthorityFactory((String)"EPSG", null);
        CoordinateOperation co = coaf.createCoordinateOperation("");
    }

    void createTransformFromAuthorityCode() throws Exception {
        CoordinateOperationAuthorityFactory coaf = ReferencingFactoryFinder.getCoordinateOperationAuthorityFactory((String)"EPSG", null);
        Set coordOperations = coaf.createFromCoordinateReferenceSystemCodes("EPSG:4267", "EPSG:4269");
        for (CoordinateOperation co : coordOperations) {
            System.out.println("  " + co.toWKT());
        }
    }

    void printIdentifierStuff(IdentifiedObject identObj) {
        System.out.println("  getName().getCode() - " + identObj.getName().getCode());
        System.out.println("  getName().getAuthority() - " + identObj.getName().getAuthority());
        System.out.println("  getRemarks() - " + identObj.getRemarks());
        System.out.println("  getAliases():");
        Iterator aliases = identObj.getAlias().iterator();
        if (!aliases.hasNext()) {
            System.out.println("    no aliases");
        } else {
            int i = 0;
            while (aliases.hasNext()) {
                System.out.println("    alias(" + i + "): " + (GenericName)aliases.next());
                ++i;
            }
        }
        System.out.println("  getIdentifiers():");
        Iterator idents = identObj.getIdentifiers().iterator();
        if (!idents.hasNext()) {
            System.out.println("    no extra identifiers");
        } else {
            int i = 0;
            while (idents.hasNext()) {
                Identifier ident = (Identifier)idents.next();
                System.out.println("    identifier(" + i + ").getCode() - " + ident.getCode());
                System.out.println("    identifier(" + i + ").getAuthority() - " + ident.getAuthority());
                ++i;
            }
        }
    }

    public static void main(String[] args) {
        new CTSTutorial();
    }
}

