/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.gmlparsing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.geotools.xml.StreamingParser;
import org.opengis.feature.simple.SimpleFeature;
import org.w3c.dom.Document;

public class GMLParsing {
    public static void main(String[] args) throws Exception {
        GMLParsing.schemaParseGML3();
    }

    public static void parseGML3() throws Exception {
        InputStream in = GMLParsing.class.getResourceAsStream("states.xml");
        GMLConfiguration gml = new GMLConfiguration();
        Parser parser = new Parser((Configuration)gml);
        parser.setStrict(false);
        FeatureCollection features = (FeatureCollection)parser.parse(in);
        FeatureIterator i = features.features();
        int nfeatures = 0;
        while (i.hasNext()) {
            SimpleFeature f = (SimpleFeature)i.next();
            System.out.println(f.getID());
            ++nfeatures;
        }
        System.out.println("Number of features: " + nfeatures);
    }

    public static void streamParseGML3() throws Exception {
        InputStream in = GMLParsing.class.getResourceAsStream("states.xml");
        GMLConfiguration gml = new GMLConfiguration();
        StreamingParser parser = new StreamingParser((Configuration)gml, in, SimpleFeature.class);
        int nfeatures = 0;
        SimpleFeature f = null;
        while ((f = (SimpleFeature)parser.parse()) != null) {
            ++nfeatures;
            System.out.println(f.getID());
        }
        System.out.println("Number of features: " + nfeatures);
    }

    public static void schemaParseGML3() throws Exception {
        File xml = GMLParsing.setSchemaLocation();
        FileInputStream in = new FileInputStream(xml);
        GMLConfiguration gml = new GMLConfiguration();
        Parser parser = new Parser((Configuration)gml);
        parser.setStrict(false);
        FeatureCollection features = (FeatureCollection)parser.parse((InputStream)in);
        FeatureIterator i = features.features();
        int nfeatures = 0;
        while (i.hasNext()) {
            SimpleFeature f = (SimpleFeature)i.next();
            System.out.println(f.getID());
            ++nfeatures;
        }
        System.out.println("Number of features: " + nfeatures);
    }

    static File setSchemaLocation() throws Exception {
        File xsd = File.createTempFile("states", "xsd");
        IOUtils.copy((InputStream)GMLParsing.class.getResourceAsStream("states.xsd"), (OutputStream)new FileOutputStream(xsd));
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document d = db.parse(GMLParsing.class.getResourceAsStream("states.xml"));
        d.getDocumentElement().setAttribute("xsi:schemaLocation", "http://www.openplans.org/topp " + xsd.getCanonicalPath());
        File xml = File.createTempFile("states", "xml");
        TransformerFactory.newInstance().newTransformer().transform(new DOMSource(d), new StreamResult(xml));
        return xml;
    }
}

