/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.geotools.data.FeatureLockFactory;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryFinder;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollections;
import org.geotools.filter.FunctionFactory;
import org.geotools.resources.LazySet;
import org.geotools.styling.StyleFactory;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommonFactoryFinder
extends FactoryFinder {
    private static FactoryRegistry registry;

    private CommonFactoryFinder() {
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(CommonFactoryFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(StyleFactory.class, FilterFactory.class, FeatureLockFactory.class, FileDataStoreFactorySpi.class, Function.class, FunctionFactory.class, FeatureFactory.class, FeatureTypeFactory.class, FeatureCollections.class));
        }
        return registry;
    }

    public static StyleFactory getStyleFactory(Hints hints) throws FactoryRegistryException {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return (StyleFactory)CommonFactoryFinder.lookup(StyleFactory.class, hints, (Hints.Key)Hints.STYLE_FACTORY);
    }

    public static synchronized Set getStyleFactories(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(StyleFactory.class, null, hints));
    }

    public static synchronized Set getFunctionExpressions(Hints hints) {
        return Collections.EMPTY_SET;
    }

    public static synchronized Set getFunctions(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(Function.class, null, hints));
    }

    public static synchronized Set<FunctionFactory> getFunctionFactories(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FunctionFactory.class, null, hints));
    }

    public static FeatureLockFactory getFeatureLockFactory(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return (FeatureLockFactory)CommonFactoryFinder.lookup(FeatureLockFactory.class, hints, (Hints.Key)Hints.FEATURE_LOCK_FACTORY);
    }

    public static synchronized Set getFeatureLockFactories(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FeatureLockFactory.class, null, hints));
    }

    public static synchronized Set getFileDataStoreFactories(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FileDataStoreFactorySpi.class, null, hints));
    }

    public static FeatureFactory getFeatureFactory(Hints hints) {
        if ((hints = CommonFactoryFinder.mergeSystemHints((Hints)hints)).get((Object)Hints.FEATURE_FACTORY) == null) {
            try {
                Class<?> lenient = Class.forName("org.geotools.feature.LenientFeatureFactoryImpl");
                hints.put((Object)Hints.FEATURE_FACTORY, lenient);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return (FeatureFactory)CommonFactoryFinder.lookup(FeatureFactory.class, hints, (Hints.Key)Hints.FEATURE_FACTORY);
    }

    public static FeatureTypeFactory getFeatureTypeFactory(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return (FeatureTypeFactory)CommonFactoryFinder.lookup(FeatureTypeFactory.class, hints, (Hints.Key)Hints.FEATURE_TYPE_FACTORY);
    }

    public static FeatureCollections getFeatureCollections(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return (FeatureCollections)CommonFactoryFinder.lookup(FeatureCollections.class, hints, (Hints.Key)Hints.FEATURE_COLLECTIONS);
    }

    public static synchronized Set getFeatureCollectionsSet(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FeatureCollections.class, null, hints));
    }

    public static FilterFactory getFilterFactory(Hints hints) throws FactoryRegistryException {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return (FilterFactory)CommonFactoryFinder.lookup(FilterFactory.class, hints, (Hints.Key)Hints.FILTER_FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object lookup(Class category, Hints hints, Hints.Key key) {
        if (hints == null || key == null) {
            return null;
        }
        Object hint = hints.get((Object)key);
        if (hint != null && category.isInstance(hint)) {
            return hint;
        }
        Class<CommonFactoryFinder> clazz = CommonFactoryFinder.class;
        synchronized (CommonFactoryFinder.class) {
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return CommonFactoryFinder.getServiceRegistry().getServiceProvider(category, null, hints, key);
        }
    }

    public static synchronized Set getFilterFactories(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FilterFactory.class, null, hints));
    }

    public static FilterFactory2 getFilterFactory2(Hints hints) throws FactoryRegistryException {
        Object h = (hints = CommonFactoryFinder.mergeSystemHints((Hints)hints)).get((Object)Hints.FILTER_FACTORY);
        if (h instanceof Class ? !FilterFactory2.class.isAssignableFrom((Class)h) : !(h instanceof FilterFactory2)) {
            hints = new Hints((RenderingHints)hints);
            hints.put((Object)Hints.FILTER_FACTORY, FilterFactory2.class);
        }
        return (FilterFactory2)CommonFactoryFinder.getFilterFactory(hints);
    }

    public static synchronized void scanForPlugins() {
        if (registry != null) {
            registry.scanForPlugins();
        }
    }

    public static void reset() {
        FactoryRegistry copy = registry;
        registry = null;
        if (copy != null) {
            copy.deregisterAll();
        }
    }
}

