/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.geometry.jts.CoordinateSequenceTransformer;
import org.geotools.geometry.jts.DefaultCoordinateSequenceTransformer;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class GeometryCoordinateSequenceTransformer {
    private MathTransform transform;
    private CoordinateSequenceTransformer csTransformer;
    private CoordinateReferenceSystem crs;

    public GeometryCoordinateSequenceTransformer() {
        this.csTransformer = new DefaultCoordinateSequenceTransformer();
    }

    public GeometryCoordinateSequenceTransformer(CoordinateSequenceFactory coordianteSequenceFactory) {
        this.csTransformer = new DefaultCoordinateSequenceTransformer(coordianteSequenceFactory);
    }

    public GeometryCoordinateSequenceTransformer(CoordinateSequenceTransformer transformer) {
        this.csTransformer = transformer;
    }

    public void setMathTransform(MathTransform transform) {
        this.transform = transform;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public Geometry transform(Geometry g) throws TransformException {
        GeometryFactory factory = g.getFactory();
        Point transformed = null;
        if (g instanceof Point) {
            transformed = this.transformPoint((Point)g, factory);
        } else if (g instanceof MultiPoint) {
            MultiPoint mp = (MultiPoint)g;
            Point[] points = new Point[mp.getNumGeometries()];
            int i = 0;
            while (i < points.length) {
                points[i] = this.transformPoint((Point)mp.getGeometryN(i), factory);
                ++i;
            }
            transformed = factory.createMultiPoint(points);
        } else if (g instanceof LineString) {
            transformed = this.transformLineString((LineString)g, factory);
        } else if (g instanceof MultiLineString) {
            MultiLineString mls = (MultiLineString)g;
            LineString[] lines = new LineString[mls.getNumGeometries()];
            int i = 0;
            while (i < lines.length) {
                lines[i] = this.transformLineString((LineString)mls.getGeometryN(i), factory);
                ++i;
            }
            transformed = factory.createMultiLineString(lines);
        } else if (g instanceof Polygon) {
            transformed = this.transformPolygon((Polygon)g, factory);
        } else if (g instanceof MultiPolygon) {
            MultiPolygon mp = (MultiPolygon)g;
            Polygon[] polygons = new Polygon[mp.getNumGeometries()];
            int i = 0;
            while (i < polygons.length) {
                polygons[i] = this.transformPolygon((Polygon)mp.getGeometryN(i), factory);
                ++i;
            }
            transformed = factory.createMultiPolygon(polygons);
        } else if (g instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g;
            Geometry[] geoms = new Geometry[gc.getNumGeometries()];
            int i = 0;
            while (i < geoms.length) {
                geoms[i] = this.transform(gc.getGeometryN(i));
                ++i;
            }
            transformed = factory.createGeometryCollection(geoms);
        } else {
            throw new IllegalArgumentException("Unsupported geometry type " + g.getClass());
        }
        transformed.setUserData(g.getUserData());
        if ((g.getUserData() == null || g.getUserData() instanceof CoordinateReferenceSystem) && this.crs != null) {
            transformed.setUserData((Object)this.crs);
        }
        return transformed;
    }

    public LineString transformLineString(LineString ls, GeometryFactory gf) throws TransformException {
        CoordinateSequence cs = this.projectCoordinateSequence(ls.getCoordinateSequence());
        Object transformed = null;
        transformed = ls instanceof LinearRing ? gf.createLinearRing(cs) : gf.createLineString(cs);
        transformed.setUserData(ls.getUserData());
        return transformed;
    }

    public Point transformPoint(Point point, GeometryFactory gf) throws TransformException {
        CoordinateSequence cs = this.projectCoordinateSequence(point.getCoordinateSequence());
        Point transformed = gf.createPoint(cs);
        transformed.setUserData(point.getUserData());
        return transformed;
    }

    public CoordinateSequence projectCoordinateSequence(CoordinateSequence cs) throws TransformException {
        return this.csTransformer.transform(cs, this.transform);
    }

    public Polygon transformPolygon(Polygon polygon, GeometryFactory gf) throws TransformException {
        LinearRing exterior = (LinearRing)this.transformLineString(polygon.getExteriorRing(), gf);
        LinearRing[] interiors = new LinearRing[polygon.getNumInteriorRing()];
        int i = 0;
        while (i < interiors.length) {
            interiors[i] = (LinearRing)this.transformLineString(polygon.getInteriorRingN(i), gf);
            ++i;
        }
        Polygon transformed = gf.createPolygon(exterior, interiors);
        transformed.setUserData(polygon.getUserData());
        return transformed;
    }
}

