/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AppSchemaDataAccessFactory;
import org.geotools.feature.Types;
import org.opengis.feature.type.Name;

public class AppSchemaDataAccessFactoryTest
extends TestCase {
    AppSchemaDataAccessFactory factory;
    Map params;
    private static final String NSURI = "http://online.socialchange.net.au";
    static final Name mappedTypeName = Types.typeName((String)"http://online.socialchange.net.au", (String)"RoadSegment");

    protected void setUp() throws Exception {
        super.setUp();
        this.factory = new AppSchemaDataAccessFactory();
        this.params = new HashMap();
        this.params.put("dbtype", "app-schema");
        URL resource = ((Object)((Object)this)).getClass().getResource("/test-data/roadsegments.xml");
        if (resource == null) {
            AppSchemaDataAccessFactoryTest.fail((String)"Can't find resouce /test-data/roadsegments.xml");
        }
        this.params.put("url", resource);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.factory = null;
        this.params = null;
    }

    public void testCreateDataStorePreconditions() {
        HashMap<String, String> badParams = new HashMap<String, String>();
        try {
            this.factory.createDataStore(badParams);
            AppSchemaDataAccessFactoryTest.fail((String)"allowed bad params");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        badParams.put("dbtype", "app-schema");
        try {
            this.factory.createDataStore(badParams);
            AppSchemaDataAccessFactoryTest.fail((String)"allowed bad params");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        badParams.put("url", "file://_inexistentConfigFile123456.xml");
        try {
            this.factory.createDataStore(badParams);
            AppSchemaDataAccessFactoryTest.fail((String)"allowed bad params");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testCreateDataStore() throws IOException {
        DataAccess ds = this.factory.createDataStore(this.params);
        AppSchemaDataAccessFactoryTest.assertNotNull((Object)ds);
        FeatureSource mappedSource = ds.getFeatureSource(mappedTypeName);
        AppSchemaDataAccessFactoryTest.assertNotNull((Object)mappedSource);
        AppSchemaDataAccessFactoryTest.assertSame((Object)ds, (Object)mappedSource.getDataStore());
        ds.dispose();
    }

    public void testFactoryLookup() throws IOException {
        DataAccess ds = DataAccessFinder.getDataStore((Map)this.params);
        AppSchemaDataAccessFactoryTest.assertNotNull((Object)ds);
        AppSchemaDataAccessFactoryTest.assertTrue((boolean)(ds instanceof AppSchemaDataAccess));
        FeatureSource mappedSource = ds.getFeatureSource(mappedTypeName);
        AppSchemaDataAccessFactoryTest.assertNotNull((Object)mappedSource);
        ds.dispose();
    }

    public void testCreateNewDataStore() throws IOException {
        try {
            this.factory.createNewDataStore(Collections.EMPTY_MAP);
            AppSchemaDataAccessFactoryTest.fail((String)"unsupported?");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetParametersInfo() {
        DataAccessFactory.Param[] params = this.factory.getParametersInfo();
        AppSchemaDataAccessFactoryTest.assertNotNull((Object)params);
        AppSchemaDataAccessFactoryTest.assertEquals((int)2, (int)params.length);
        AppSchemaDataAccessFactoryTest.assertEquals(String.class, (Object)params[0].type);
        AppSchemaDataAccessFactoryTest.assertEquals(URL.class, (Object)params[1].type);
    }

    public void testCanProcess() {
        HashMap<String, String> params = new HashMap<String, String>();
        AppSchemaDataAccessFactoryTest.assertFalse((boolean)this.factory.canProcess(params));
        params.put("dbtype", "arcsde");
        params.put("url", "http://somesite.net/config.xml");
        AppSchemaDataAccessFactoryTest.assertFalse((boolean)this.factory.canProcess(params));
        params.remove("url");
        params.put("dbtype", "app-schema");
        AppSchemaDataAccessFactoryTest.assertFalse((boolean)this.factory.canProcess(params));
        params.put("url", "http://somesite.net/config.xml");
        AppSchemaDataAccessFactoryTest.assertTrue((boolean)this.factory.canProcess(params));
    }

    public void testIsAvailable() {
        AppSchemaDataAccessFactoryTest.assertTrue((boolean)this.factory.isAvailable());
    }

    public void testGetImplementationHints() {
        AppSchemaDataAccessFactoryTest.assertNotNull((Object)this.factory.getImplementationHints());
        AppSchemaDataAccessFactoryTest.assertEquals((int)0, (int)this.factory.getImplementationHints().size());
    }
}

