/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.MappingFeatureSource;
import org.geotools.data.complex.filter.XPath;
import org.geotools.feature.Types;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureTypeMapping {
    private FeatureSource<?, ?> source;
    private AttributeDescriptor target;
    List<AttributeMapping> attributeMappings;
    NamespaceSupport namespaces;
    String itemXpath;
    private Name mappingName;
    private Expression featureFidMapping;

    public FeatureTypeMapping() {
        this(null, null, new LinkedList<AttributeMapping>(), new NamespaceSupport());
    }

    public FeatureTypeMapping(FeatureSource<?, ?> source, AttributeDescriptor target, List<AttributeMapping> mappings, NamespaceSupport namespaces) {
        this.source = source;
        this.target = target;
        this.attributeMappings = new LinkedList<AttributeMapping>(mappings);
        this.namespaces = namespaces;
        for (AttributeMapping attMapping : this.attributeMappings) {
            XPath.StepList targetXPath = attMapping.getTargetXPath();
            if (targetXPath.size() > 1) continue;
            XPath.Step step = (XPath.Step)targetXPath.get(0);
            QName stepName = step.getName();
            if (!Types.equals(target.getName(), stepName)) continue;
            this.featureFidMapping = attMapping.getIdentifierExpression();
            break;
        }
        if (this.featureFidMapping == null) {
            this.featureFidMapping = Expression.NIL;
        }
    }

    public FeatureTypeMapping(FeatureSource<?, ?> source, AttributeDescriptor target, List<AttributeMapping> mappings, NamespaceSupport namespaces, String itemXpath) {
        this(source, target, mappings, namespaces);
        this.itemXpath = itemXpath;
    }

    public List<AttributeMapping> getAttributeMappings() {
        return Collections.unmodifiableList(this.attributeMappings);
    }

    public Expression getFeatureIdExpression() {
        return this.featureFidMapping;
    }

    public List<AttributeMapping> getAttributeMappingsIgnoreIndex(XPath.StepList targetPath) {
        ArrayList<AttributeMapping> mappings = new ArrayList<AttributeMapping>();
        for (AttributeMapping attMapping : this.attributeMappings) {
            if (!targetPath.equalsIgnoreIndex(attMapping.getTargetXPath())) continue;
            mappings.add(attMapping);
        }
        return mappings;
    }

    public List<AttributeMapping> getAttributeMappingsByExpression(Expression sourceExpression) {
        ArrayList<AttributeMapping> mappings = new ArrayList<AttributeMapping>();
        for (AttributeMapping attMapping : this.attributeMappings) {
            if (!sourceExpression.equals(attMapping.getSourceExpression())) continue;
            mappings.add(attMapping);
        }
        return mappings;
    }

    public AttributeMapping getAttributeMapping(XPath.StepList exactPath) {
        for (AttributeMapping attMapping : this.attributeMappings) {
            if (!exactPath.equals((Object)attMapping.getTargetXPath())) continue;
            return attMapping;
        }
        return null;
    }

    public NamespaceSupport getNamespaces() {
        return this.namespaces;
    }

    public String getItemXpath() {
        return this.itemXpath;
    }

    public void setTargetFeature(AttributeDescriptor feature) {
        this.target = feature;
    }

    public AttributeDescriptor getTargetFeature() {
        return this.target;
    }

    public FeatureSource getSource() {
        return this.source;
    }

    public FeatureTypeMapping getUnderlyingComplexMapping() {
        if (this.source instanceof MappingFeatureSource) {
            return ((MappingFeatureSource)this.source).getMapping();
        }
        return null;
    }

    public void setName(Name name) {
        this.mappingName = name;
    }

    public Name getMappingName() {
        return this.mappingName;
    }
}

