/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.Set;
import junit.framework.TestCase;
import org.geotools.feature.TypeBuilder;
import org.geotools.referencing.CRS;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComplexTestData
extends TestCase {
    public static final String NSURI = "http://online.socialchange.net.au";
    public static final String GML_NSURI = "http://www.opengis.net/gml";

    public static FeatureType createExample01MultiValuedComplexProperty(FeatureTypeFactory typeFactory) {
        TypeBuilder builder = new TypeBuilder(typeFactory);
        builder.setNamespaceURI(NSURI);
        builder.setName("sitename");
        builder.setBinding(String.class);
        AttributeType SITENAME = builder.attribute();
        builder.setName("anzlic_noType");
        builder.setBinding(String.class);
        AttributeType ANZLIC_NO = builder.attribute();
        builder.setName("locationType");
        builder.setBinding(Point.class);
        GeometryType LOCATION = builder.geometry();
        ComplexType MEASUREMENT = ComplexTestData.createMeasurementType(typeFactory);
        builder.setName("project_noType");
        builder.setBinding(String.class);
        AttributeType PROJECT_NO = builder.attribute();
        builder.setName("wq_plus");
        builder.cardinality(1, 1);
        builder.addAttribute("sitename", SITENAME);
        builder.cardinality(0, 1);
        builder.addAttribute("anzlic_no", ANZLIC_NO);
        builder.cardinality(0, 1);
        builder.addAttribute("location", (AttributeType)LOCATION);
        builder.cardinality(0, Integer.MAX_VALUE);
        builder.addAttribute("measurement", (AttributeType)MEASUREMENT);
        builder.cardinality(0, 1);
        builder.addAttribute("project_no", PROJECT_NO);
        FeatureType wqPlusType = builder.feature();
        return wqPlusType;
    }

    public static FeatureType createExample02MultipleMultivalued(FeatureTypeFactory typeFactory) {
        TypeBuilder builder = new TypeBuilder(typeFactory);
        builder.setNamespaceURI(NSURI);
        ComplexType measurement = ComplexTestData.createMeasurementType(typeFactory);
        AttributeType the_geom = builder.name("the_geom").bind(Geometry.class).attribute();
        AttributeType sitename = builder.name("sitename").bind(String.class).attribute();
        builder.cardinality(0, Integer.MAX_VALUE);
        builder.addAttribute("measurement", (AttributeType)measurement);
        builder.cardinality(1, 1);
        builder.addAttribute("the_geom", the_geom);
        builder.nillable(true);
        builder.cardinality(1, Integer.MAX_VALUE);
        builder.addAttribute("sitename", sitename);
        builder.setName("wq_plus");
        FeatureType wqPlusType = builder.feature();
        return wqPlusType;
    }

    public static FeatureType createExample03MultipleGeometries(FeatureTypeFactory typeFactory) {
        TypeBuilder builder = new TypeBuilder(typeFactory);
        builder.setNamespaceURI(NSURI);
        ComplexType measurement = ComplexTestData.createMeasurementType(typeFactory);
        AttributeType gmlLocationAssociation = ComplexTestData.createGmlLocation(typeFactory);
        AttributeType gmlPointAssociation = ComplexTestData.createGmlPoint(typeFactory);
        builder.setName("wq_plus");
        builder.cardinality(0, Integer.MAX_VALUE);
        builder.addAttribute("measurement", (AttributeType)measurement);
        builder.cardinality(1, 1);
        builder.nillable(true);
        builder.addAttribute("location", gmlLocationAssociation);
        builder.cardinality(1, 1);
        builder.nillable(true);
        builder.addAttribute("nearestSlimePit", gmlPointAssociation);
        builder.cardinality(1, Integer.MAX_VALUE);
        builder.addAttribute("sitename", String.class);
        builder.defaultGeometry("nearestSlimePit");
        FeatureType wqPlusType = builder.feature();
        return wqPlusType;
    }

    public static FeatureType createExample04Type(FeatureTypeFactory typeFactory) {
        TypeBuilder builder = new TypeBuilder(typeFactory);
        builder.setNamespaceURI(NSURI);
        builder.cardinality(1, Integer.MAX_VALUE);
        builder.addAttribute("name", String.class);
        builder.setName(GML_NSURI);
        builder.cardinality(1, Integer.MAX_VALUE);
        builder.addAttribute("name", String.class);
        builder.setNamespaceURI(NSURI);
        builder.setName("wq_plus");
        FeatureType wqPlusType = builder.feature();
        return wqPlusType;
    }

    public static ComplexType createMeasurementType(FeatureTypeFactory typeFactory) {
        TypeBuilder builder = new TypeBuilder(typeFactory);
        builder.setNamespaceURI(NSURI);
        builder.setName("determinand_description");
        builder.setBinding(String.class);
        AttributeType detdesc = builder.attribute();
        builder.setName("result");
        builder.setBinding(String.class);
        AttributeType result = builder.attribute();
        builder.setName("measurementType");
        builder.cardinality(1, 1);
        builder.addAttribute("determinand_description", detdesc);
        builder.addAttribute("result", result);
        ComplexType measurement = builder.complex();
        return measurement;
    }

    public static AttributeType createGmlLocation(FeatureTypeFactory typeFactory) {
        TypeBuilder builder = new TypeBuilder(typeFactory);
        builder.setNamespaceURI(GML_NSURI);
        builder.setName("LocationPropertyType");
        builder.setBinding(Point.class);
        GeometryType type = builder.geometry();
        return type;
    }

    public static AttributeType createGmlPoint(FeatureTypeFactory typeFactory) {
        TypeBuilder builder = new TypeBuilder(typeFactory);
        builder.setNamespaceURI(GML_NSURI);
        builder.setName("PointPropertyType");
        CoordinateReferenceSystem fakeCrs = null;
        try {
            fakeCrs = CRS.decode((String)"EPSG:4326");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        builder.setCRS(fakeCrs);
        builder.setBinding(Point.class);
        GeometryType type = builder.geometry();
        return type;
    }

    public static void checkType(AttributeType type, Name name, Class<?> binding, Set<Filter> restrictions, boolean identified, boolean _abstract, AttributeType superType) {
        ComplexTestData.assertNotNull((Object)type);
        ComplexTestData.assertEquals((Object)name, (Object)type.getName());
        ComplexTestData.assertEquals(binding, (Object)type.getBinding());
        ComplexTestData.assertNotNull((Object)type.getRestrictions());
        ComplexTestData.assertEquals(restrictions, (Object)type.getRestrictions());
        ComplexTestData.assertEquals((boolean)identified, (boolean)type.isIdentified());
        ComplexTestData.assertEquals((boolean)_abstract, (boolean)type.isAbstract());
        ComplexTestData.assertEquals((Object)superType, (Object)type.getSuper());
    }
}

