/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureChainingTest;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.EmfAppSchemaReader;
import org.geotools.data.complex.config.FeatureTypeRegistry;
import org.geotools.data.complex.config.XMLConfigDigester;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.Types;
import org.geotools.xml.SchemaIndex;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeologicUnitTest {
    private static final String GSMLNS = "http://www.cgi-iugs.org/xml/GeoSciML/2";
    private static final String schemaBase = "/test-data/";
    private static EmfAppSchemaReader reader;

    @BeforeClass
    public static void setUp() throws Exception {
        reader = EmfAppSchemaReader.newInstance();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        DataAccessRegistry.unregisterAll();
    }

    private SchemaIndex loadSchema(String location) throws IOException {
        URL catalogLocation = this.getClass().getResource("/test-data/mappedPolygons.oasis.xml");
        reader.setResolver(catalogLocation);
        return reader.parse(new URL(location));
    }

    @Test
    public void testParseSchema() throws Exception {
        SchemaIndex schemaIndex = this.loadSchema("http://schemas.opengis.net/GeoSciML/Gsml.xsd");
        FeatureTypeRegistry typeRegistry = new FeatureTypeRegistry();
        typeRegistry.addSchemas(schemaIndex);
        Name typeName = Types.typeName((String)GSMLNS, (String)"GeologicUnitType");
        ComplexType mf = (ComplexType)typeRegistry.getAttributeType(typeName);
        Assert.assertNotNull((Object)mf);
        Assert.assertTrue((boolean)(mf instanceof FeatureType));
        AttributeType superType = mf.getSuper();
        Assert.assertNotNull((Object)superType);
        Name superTypeName = Types.typeName((String)GSMLNS, (String)"GeologicFeatureType");
        Assert.assertEquals((Object)superTypeName, (Object)superType.getName());
        Assert.assertTrue((boolean)(superType instanceof FeatureType));
    }

    @Test
    public void testLoadMappingsConfig() throws Exception {
        XMLConfigDigester reader = new XMLConfigDigester();
        URL url = this.getClass().getResource("/test-data/GeologicUnit.xml");
        AppSchemaDataAccessDTO config = reader.parse(url);
        Set mappings = AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config);
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)1L, (long)mappings.size());
    }

    @Test
    public void testGetFeatures() throws Exception {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = this.getClass().getResource("/test-data/GeologicUnit.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess guDataStore = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)guDataStore);
        FeatureType geologicUnitType = guDataStore.getSchema(FeatureChainingTest.GEOLOGIC_UNIT);
        Assert.assertNotNull((Object)geologicUnitType);
        url = this.getClass().getResource("/test-data/MappedFeaturePropertyfile.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess mfDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)mfDataAccess);
        FeatureSource guSource = guDataStore.getFeatureSource(FeatureChainingTest.GEOLOGIC_UNIT);
        FeatureCollection guFeatures = guSource.getFeatures();
        Assert.assertEquals((long)3L, (long)this.size((FeatureCollection<FeatureType, Feature>)guFeatures));
        FeatureSource cpSource = DataAccessRegistry.getFeatureSource((Name)FeatureChainingTest.COMPOSITION_PART);
        FeatureCollection cpFeatures = cpSource.getFeatures();
        Assert.assertEquals((long)4L, (long)this.size((FeatureCollection<FeatureType, Feature>)cpFeatures));
        FeatureSource cgiSource = DataAccessRegistry.getFeatureSource((Name)FeatureChainingTest.CGI_TERM_VALUE);
        FeatureCollection cgiFeatures = cgiSource.getFeatures();
        Assert.assertEquals((long)6L, (long)this.size((FeatureCollection<FeatureType, Feature>)cgiFeatures));
    }

    private int size(FeatureCollection<FeatureType, Feature> features) {
        int size = 0;
        Iterator i = features.iterator();
        while (i.hasNext()) {
            ++size;
            i.next();
        }
        return size;
    }
}

