/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import com.vividsolutions.jts.util.Stopwatch;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AbstractMappingFeatureIterator;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.Types;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.FunctionExpressionImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureChainingTest {
    static final String GSMLNS = "http://www.cgi-iugs.org/xml/GeoSciML/2";
    static final String GMLNS = "http://www.opengis.net/gml";
    static final Name MAPPED_FEATURE_TYPE = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"MappedFeatureType");
    static final Name MAPPED_FEATURE = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"MappedFeature");
    static final Name GEOLOGIC_UNIT_TYPE = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"GeologicUnitType");
    static final Name GEOLOGIC_UNIT = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"GeologicUnit");
    static final Name COMPOSITION_PART_TYPE = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"CompositionPartType");
    static final Name COMPOSITION_PART = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"CompositionPart");
    static final Name CGI_TERM_VALUE = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"CGI_TermValue");
    static final Name CGI_TERM_VALUE_TYPE = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"CGI_TermValueType");
    static final Name CONTROLLED_CONCEPT = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"ControlledConcept");
    static FilterFactory ff = new FilterFactoryImpl(null);
    static final Map<String, String> mfToGuMap = new HashMap<String, String>(){
        {
            this.put("mf1", "gu.25699");
            this.put("mf2", "gu.25678");
            this.put("mf3", "gu.25678");
            this.put("mf4", "gu.25682");
        }
    };
    static final Map<String, String> guToCpMap = new HashMap<String, String>(){
        {
            this.put("gu.25699", "cp.167775491936278844");
            this.put("gu.25678", "cp.167775491936278844;cp.167775491936278856");
            this.put("gu.25682", "cp.167775491936278812");
        }
    };
    static final Map<String, String> guToExposureColorMap = new HashMap<String, String>(){
        {
            this.put("gu.25699", "Blue");
            this.put("gu.25678", "Yellow;Blue");
            this.put("gu.25682", "Red");
        }
    };
    public static final String CONTAINS_TEXT = "contains_text";
    static Map<String, String> guToOutcropCharacterMap = new HashMap<String, String>(){
        {
            this.put("gu.25699", "x");
            this.put("gu.25678", "x;y");
            this.put("gu.25682", "z");
        }
    };
    private static final String schemaBase = "/test-data/";
    private static FeatureSource<FeatureType, Feature> mfSource;
    private static FeatureCollection<FeatureType, Feature> mfFeatures;
    private static FeatureCollection<FeatureType, Feature> guFeatures;
    private static FeatureCollection<FeatureType, Feature> cpFeatures;
    private static FeatureCollection<FeatureType, Feature> ccFeatures;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Stopwatch sw = new Stopwatch();
        sw.start();
        FeatureChainingTest.loadDataAccesses();
        sw.stop();
        System.out.println("Set up time: " + sw.getTimeString());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        DataAccessRegistry.unregisterAll();
    }

    @Test
    public void testFeatureChaining() throws Exception {
        Feature cpFeature;
        Feature guFeature;
        Iterator mfIterator = mfFeatures.iterator();
        Iterator guIterator = guFeatures.iterator();
        HashMap<String, Feature> guMap = new HashMap<String, Feature>();
        while (guIterator.hasNext()) {
            guFeature = (Feature)guIterator.next();
            String guId = guFeature.getIdentifier().getID();
            if (guMap.containsKey(guId)) continue;
            guMap.put(guId, guFeature);
        }
        Iterator cpIterator = cpFeatures.iterator();
        HashMap<String, Feature> cpMap = new HashMap<String, Feature>();
        while (cpIterator.hasNext()) {
            cpFeature = (Feature)cpIterator.next();
            String cpId = cpFeature.getIdentifier().getID();
            if (cpMap.containsKey(cpId)) continue;
            cpMap.put(cpId, cpFeature);
        }
        String NESTED_LINK = "specification";
        while (mfIterator.hasNext()) {
            Feature mfFeature = (Feature)mfIterator.next();
            String mfId = mfFeature.getIdentifier().toString();
            String[] guIds = mfToGuMap.get(mfId).split(";");
            Collection nestedGuFeatures = mfFeature.getProperties("specification");
            Assert.assertEquals((long)guIds.length, (long)nestedGuFeatures.size());
            ArrayList<String> nestedGuIds = new ArrayList<String>();
            for (Property property : nestedGuFeatures) {
                Object value = property.getValue();
                Assert.assertNotNull((Object)value);
                Assert.assertEquals((Object)(value instanceof Collection), (Object)true);
                Assert.assertEquals((long)((Collection)value).size(), (long)1L);
                Feature nestedGuFeature = (Feature)((Collection)value).iterator().next();
                String guId = nestedGuFeature.getIdentifier().toString();
                Assert.assertEquals((Object)true, (Object)guMap.containsKey(guId));
                nestedGuIds.add(guId);
                guFeature = (Feature)guMap.get(guId.toString());
                Collection guProperties = guFeature.getProperties();
                Assert.assertEquals((Object)guProperties, (Object)nestedGuFeature.getProperties());
                String[] cpIds = guToCpMap.get(guId).split(";");
                Collection nestedCpFeatures = guFeature.getProperties("composition");
                Assert.assertEquals((long)cpIds.length, (long)nestedCpFeatures.size());
                ArrayList<String> nestedCpIds = new ArrayList<String>();
                for (Property cpProperty : nestedCpFeatures) {
                    Object cpPropertyValue = cpProperty.getValue();
                    Assert.assertNotNull((Object)cpPropertyValue);
                    Assert.assertEquals((Object)(cpPropertyValue instanceof Collection), (Object)true);
                    Assert.assertEquals((long)((Collection)cpPropertyValue).size(), (long)1L);
                    Feature nestedCpFeature = (Feature)((Collection)cpPropertyValue).iterator().next();
                    String cpId = nestedCpFeature.getIdentifier().toString();
                    Assert.assertEquals((Object)true, (Object)cpMap.containsKey(cpId));
                    nestedCpIds.add(cpId);
                    cpFeature = (Feature)cpMap.get(cpId.toString());
                    Collection cpProperties = cpFeature.getProperties();
                    Assert.assertEquals((Object)cpProperties, (Object)nestedCpFeature.getProperties());
                }
                Assert.assertEquals((Object)nestedCpIds.containsAll(Arrays.asList(cpIds)), (Object)true);
            }
            Assert.assertEquals((Object)nestedGuIds.containsAll(Arrays.asList(guIds)), (Object)true);
        }
        mfFeatures.close(mfIterator);
        guFeatures.close(guIterator);
        cpFeatures.close(cpIterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManyOnChainedSide() throws Exception {
        String LITHOLOGY = "lithology";
        int EXPECTED_RESULT_COUNT = 2;
        AbstractMappingFeatureIterator iterator = (AbstractMappingFeatureIterator)ccFeatures.iterator();
        int count = 0;
        HashMap<String, Feature> featureList = new HashMap<String, Feature>();
        try {
            while (iterator.hasNext()) {
                Feature f = iterator.next();
                featureList.put(f.getIdentifier().getID(), f);
                ++count;
            }
        }
        finally {
            ccFeatures.close((Iterator)iterator);
        }
        Assert.assertEquals((long)2L, (long)count);
        for (Feature cpFeature : cpFeatures) {
            Collection lithologies = cpFeature.getProperties("lithology");
            if (cpFeature.getIdentifier().toString().equals("cp.167775491936278812")) {
                Assert.assertEquals((long)lithologies.size(), (long)2L);
                ArrayList<String> lithologyIds = new ArrayList<String>();
                for (Property lithologyProperty : lithologies) {
                    Feature nestedFeature = (Feature)((Collection)lithologyProperty.getValue()).iterator().next();
                    String fId = nestedFeature.getIdentifier().getID();
                    lithologyIds.add(fId);
                    Feature lithology = (Feature)featureList.get(fId);
                    Assert.assertEquals((Object)lithology.getProperties(), (Object)nestedFeature.getProperties());
                }
                Assert.assertEquals((Object)featureList.keySet().containsAll(lithologyIds), (Object)true);
                continue;
            }
            Assert.assertEquals((Object)lithologies.isEmpty(), (Object)true);
        }
    }

    @Test
    public void testMultipleMultiValuedProperties() throws Exception {
        Iterator guIterator = guFeatures.iterator();
        String EXPOSURE_COLOR = "exposureColor";
        String OUTCROP_CHARACTER = "outcropCharacter";
        while (guIterator.hasNext()) {
            Feature guFeature = (Feature)guIterator.next();
            String guId = guFeature.getIdentifier().toString();
            ArrayList<Object> realValues = new ArrayList<Object>();
            Collection nestedTermValues = guFeature.getProperties("exposureColor");
            for (Property property : nestedTermValues) {
                Object value = property.getValue();
                Assert.assertNotNull((Object)value);
                Assert.assertEquals((Object)(value instanceof Collection), (Object)true);
                Assert.assertEquals((long)((Collection)value).size(), (long)1L);
                Feature feature = (Feature)((Collection)value).iterator().next();
                for (Property nestedProperty : feature.getProperties("value")) {
                    realValues.add(((Property)((Collection)nestedProperty.getValue()).iterator().next()).getValue());
                }
            }
            String[] values = guToExposureColorMap.get(guId).split(";");
            Assert.assertEquals((long)realValues.size(), (long)values.length);
            Assert.assertEquals((Object)realValues.containsAll(Arrays.asList(values)), (Object)true);
            nestedTermValues = guFeature.getProperties("outcropCharacter");
            realValues.clear();
            for (Property property : nestedTermValues) {
                Object value = property.getValue();
                Assert.assertNotNull((Object)value);
                Assert.assertEquals((Object)(value instanceof Collection), (Object)true);
                Assert.assertEquals((long)((Collection)value).size(), (long)1L);
                Feature feature = (Feature)((Collection)value).iterator().next();
                for (Property nestedProperty : feature.getProperties("value")) {
                    realValues.add(((Property)((Collection)nestedProperty.getValue()).iterator().next()).getValue());
                }
            }
            values = guToOutcropCharacterMap.get(guId).split(";");
            Assert.assertEquals((long)realValues.size(), (long)values.length);
            Assert.assertEquals((Object)realValues.containsAll(Arrays.asList(values)), (Object)true);
        }
        guFeatures.close(guIterator);
    }

    @Test
    public void testMultiValuedSimpleProperties() throws Exception {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = this.getClass().getResource("/test-data/ControlledConcept.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess dataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)dataAccess);
        FeatureType featureType = dataAccess.getSchema(CONTROLLED_CONCEPT);
        Assert.assertNotNull((Object)featureType);
        FeatureSource fSource = dataAccess.getFeatureSource(CONTROLLED_CONCEPT);
        FeatureCollection features = fSource.getFeatures();
        int EXPECTED_RESULTS = 2;
        Assert.assertEquals((long)FeatureChainingTest.getCount((FeatureCollection<FeatureType, Feature>)features), (long)2L);
        for (Feature next : features) {
            Collection names = next.getProperties("name");
            if (next.getIdentifier().toString().equals("1")) {
                Assert.assertEquals((long)names.size(), (long)3L);
                continue;
            }
            Assert.assertEquals((long)names.size(), (long)1L);
        }
        dataAccess.dispose();
    }

    @Test
    public void testFilters() throws Exception {
        PropertyName property = ff.property("gsml:specification/gsml:GeologicUnit/gml:description");
        Literal string = ff.literal((Object)"Olivine basalt, tuff, microgabbro, minor sedimentary rocks");
        Function function = ff.function(CONTAINS_TEXT, new Expression[]{property, string});
        PropertyIsEqualTo filter = ff.equals((Expression)function, (Expression)ff.literal(1));
        FeatureCollection filteredResults = mfSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)FeatureChainingTest.getCount((FeatureCollection<FeatureType, Feature>)filteredResults), (long)3L);
        FeatureSource guSource = DataAccessRegistry.getFeatureSource((Name)GEOLOGIC_UNIT);
        property = ff.property("gsml:composition/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value");
        string = ff.literal((Object)"significant");
        function = ff.function(CONTAINS_TEXT, new Expression[]{property, string});
        filter = ff.equals((Expression)function, (Expression)ff.literal(1));
        filteredResults = guSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)FeatureChainingTest.getCount((FeatureCollection<FeatureType, Feature>)filteredResults), (long)3L);
        property = ff.property("gsml:specification/gsml:GeologicUnit/gsml:occurence/@xlink:href");
        string = ff.literal((Object)"urn:cgi:feature:MappedFeature:mf1");
        filter = ff.equals((Expression)property, (Expression)string);
        filteredResults = mfSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)FeatureChainingTest.getCount((FeatureCollection<FeatureType, Feature>)filteredResults), (long)1L);
    }

    @Test
    public void testComplexTypeWithSimpleContent() throws Exception {
        Feature feature;
        Object value;
        Collection children;
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = this.getClass().getResource("/test-data/ComplexTypeWithSimpleContent.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess dataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)dataAccess);
        Name typeName = Types.typeName((String)"http://example.com", (String)"FirstParentFeature");
        FeatureType featureType = dataAccess.getSchema(typeName);
        Assert.assertNotNull((Object)featureType);
        FeatureSource fSource = dataAccess.getFeatureSource(typeName);
        FeatureCollection features = fSource.getFeatures();
        int EXPECTED_RESULTS = 2;
        Assert.assertEquals((long)FeatureChainingTest.getCount((FeatureCollection<FeatureType, Feature>)features), (long)2L);
        for (Feature next : features) {
            children = next.getProperties("nestedFeature");
            if (next.getIdentifier().toString().equals("1")) {
                Assert.assertEquals((long)children.size(), (long)2L);
            } else {
                Assert.assertEquals((long)children.size(), (long)0L);
            }
            for (Property nestedFeature : children) {
                value = nestedFeature.getValue();
                Assert.assertNotNull((Object)value);
                value = ((Collection)value).iterator().next();
                Assert.assertEquals((Object)(value instanceof FeatureImpl), (Object)true);
                feature = (Feature)value;
                Assert.assertNotNull((Object)feature.getProperty("someAttribute").getValue());
            }
        }
        typeName = Types.typeName((String)"http://example.com", (String)"SecondParentFeature");
        featureType = dataAccess.getSchema(typeName);
        Assert.assertNotNull((Object)featureType);
        fSource = dataAccess.getFeatureSource(typeName);
        features = fSource.getFeatures();
        Assert.assertEquals((long)FeatureChainingTest.getCount((FeatureCollection<FeatureType, Feature>)features), (long)2L);
        for (Feature next : features) {
            children = next.getProperties("nestedFeature");
            if (next.getIdentifier().toString().equals("2")) {
                Assert.assertEquals((long)children.size(), (long)3L);
            } else {
                Assert.assertEquals((long)children.size(), (long)0L);
            }
            for (Property nestedFeature : children) {
                value = nestedFeature.getValue();
                Assert.assertNotNull((Object)value);
                value = ((Collection)value).iterator().next();
                Assert.assertEquals((Object)(value instanceof FeatureImpl), (Object)true);
                feature = (Feature)value;
                Assert.assertNotNull((Object)feature.getProperty("someAttribute").getValue());
            }
        }
        dataAccess.dispose();
    }

    @Test
    public void testMultiValuedPropertiesByRef() throws Exception {
        String MF_PREFIX = "urn:cgi:feature:MappedFeature:";
        String OCCURENCE = "occurence";
        HashMap<String, String> guToOccurenceMap = new HashMap<String, String>(){
            {
                this.put("gu.25699", "mf1");
                this.put("gu.25678", "mf2;mf3");
                this.put("gu.25682", "mf4");
            }
        };
        ArrayList<String> processedFeatureIds = new ArrayList<String>();
        Iterator guIterator = guFeatures.iterator();
        while (guIterator.hasNext()) {
            Feature guFeature = (Feature)guIterator.next();
            String guId = guFeature.getIdentifier().toString();
            String[] mfIds = ((String)guToOccurenceMap.get(guId)).split(";");
            Collection properties = guFeature.getProperties("occurence");
            Assert.assertEquals((long)properties.size(), (long)mfIds.length);
            int propertyIndex = 0;
            for (Property property : properties) {
                Object clientProps = property.getUserData().get(Attributes.class);
                Assert.assertNotNull(clientProps);
                Assert.assertEquals((Object)(clientProps instanceof HashMap), (Object)true);
                Object hrefValue = ((Map)clientProps).get(AbstractMappingFeatureIterator.XLINK_HREF_NAME);
                Assert.assertEquals(hrefValue, (Object)("urn:cgi:feature:MappedFeature:" + mfIds[propertyIndex]));
                Assert.assertEquals((Object)((Collection)property.getValue()).isEmpty(), (Object)true);
                ++propertyIndex;
            }
            processedFeatureIds.add(guId);
        }
        Assert.assertEquals((long)processedFeatureIds.size(), (long)guToOccurenceMap.size());
        Assert.assertEquals((Object)processedFeatureIds.containsAll(guToOccurenceMap.keySet()), (Object)true);
        guFeatures.close(guIterator);
    }

    private static void loadDataAccesses() throws Exception {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = FeatureChainingTest.class.getResource("/test-data/MappedFeaturePropertyfile.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess mfDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)mfDataAccess);
        FeatureType mappedFeatureType = mfDataAccess.getSchema(MAPPED_FEATURE);
        Assert.assertNotNull((Object)mappedFeatureType);
        mfSource = mfDataAccess.getFeatureSource(MAPPED_FEATURE);
        mfFeatures = mfSource.getFeatures();
        url = FeatureChainingTest.class.getResource("/test-data/GeologicUnit.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("url", url.toExternalForm());
        DataAccess guDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)guDataAccess);
        FeatureType guType = guDataAccess.getSchema(GEOLOGIC_UNIT);
        Assert.assertNotNull((Object)guType);
        FeatureSource guSource = guDataAccess.getFeatureSource(GEOLOGIC_UNIT);
        guFeatures = guSource.getFeatures();
        cpFeatures = DataAccessRegistry.getFeatureSource((Name)COMPOSITION_PART).getFeatures();
        FeatureCollection cgiFeatures = DataAccessRegistry.getFeatureSource((Name)CGI_TERM_VALUE).getFeatures();
        ccFeatures = DataAccessRegistry.getFeatureSource((Name)CONTROLLED_CONCEPT).getFeatures();
        int EXPECTED_RESULT_COUNT = 4;
        int resultCount = FeatureChainingTest.getCount(mfFeatures);
        Assert.assertEquals((long)EXPECTED_RESULT_COUNT, (long)resultCount);
        EXPECTED_RESULT_COUNT = 3;
        resultCount = FeatureChainingTest.getCount(guFeatures);
        Assert.assertEquals((long)EXPECTED_RESULT_COUNT, (long)resultCount);
        resultCount = FeatureChainingTest.getCount(cpFeatures);
        Assert.assertEquals((long)EXPECTED_RESULT_COUNT, (long)resultCount);
        EXPECTED_RESULT_COUNT = 8;
        resultCount = FeatureChainingTest.getCount((FeatureCollection<FeatureType, Feature>)cgiFeatures);
        Assert.assertEquals((long)EXPECTED_RESULT_COUNT, (long)resultCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getCount(FeatureCollection<FeatureType, Feature> features) {
        AbstractMappingFeatureIterator iterator = (AbstractMappingFeatureIterator)features.iterator();
        int count = 0;
        try {
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
        }
        finally {
            features.close((Iterator)iterator);
        }
        return count;
    }

    public static class ContainsTextFunctionExpression
    extends FunctionExpressionImpl {
        public ContainsTextFunctionExpression() {
            super(FeatureChainingTest.CONTAINS_TEXT);
        }

        public int getArgCount() {
            return 2;
        }

        public Object evaluate(Object obj) {
            assert (obj instanceof Feature);
            Feature feature = (Feature)obj;
            List params = this.getParameters();
            Assert.assertEquals((long)params.size(), (long)this.getArgCount());
            Object arg1 = params.get(0);
            Assert.assertNotNull(arg1);
            Object arg2 = params.get(1);
            Assert.assertNotNull(arg2);
            Assert.assertEquals((Object)(arg1 instanceof Expression), (Object)true);
            Assert.assertEquals((Object)(arg2 instanceof Expression), (Object)true);
            Object val1 = ((Expression)arg1).evaluate((Object)feature);
            if (val1 == null) {
                return false;
            }
            Object val2 = ((Expression)arg2).evaluate((Object)feature);
            if (val2 == null) {
                return false;
            }
            return val1.toString().contains(val2.toString());
        }
    }
}

