/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import org.geotools.data.DataAccess;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppSchemaDataAccessRegistry
extends DataAccessRegistry {
    private static final long serialVersionUID = -373404928035022963L;

    public static FeatureTypeMapping getMapping(Name featureTypeName) throws IOException {
        if (registry == null) {
            throw new UnsupportedOperationException("No registered data access found for: " + featureTypeName.toString());
        }
        for (DataAccess dataAccess : registry) {
            if (!(dataAccess instanceof AppSchemaDataAccess) || !((AppSchemaDataAccess)dataAccess).hasMapping(featureTypeName)) continue;
            return ((AppSchemaDataAccess)dataAccess).getMapping(featureTypeName);
        }
        AppSchemaDataAccessRegistry.throwDataSourceException(featureTypeName);
        return null;
    }

    public static FeatureSource<FeatureType, Feature> getSimpleFeatureSource(Name featureTypeName) throws IOException {
        return AppSchemaDataAccessRegistry.getMapping(featureTypeName).getSource();
    }

    public static boolean hasName(Name featureTypeName) throws IOException {
        if (registry == null) {
            return false;
        }
        for (DataAccess dataAccess : registry) {
            if (!(dataAccess instanceof AppSchemaDataAccess) || !dataAccess.getNames().contains(featureTypeName)) continue;
            return true;
        }
        return false;
    }
}

