/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.Query;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.IMappingFeatureIterator;
import org.geotools.data.complex.MappingFeatureIteratorFactory;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingFeatureCollection
implements FeatureCollection<FeatureType, Feature> {
    private final AppSchemaDataAccess store;
    private final FeatureTypeMapping mapping;
    private final Query query;

    public MappingFeatureCollection(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query) {
        this.store = store;
        this.mapping = mapping;
        this.query = query;
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean add(Feature obj) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection<? extends Feature> collection) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(FeatureCollection<? extends FeatureType, ? extends Feature> resource) {
        throw new UnsupportedOperationException();
    }

    public void addListener(CollectionListener listener) throws NullPointerException {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void close(FeatureIterator<Feature> close) {
        close.close();
    }

    public void close(Iterator<Feature> close) {
        ((IMappingFeatureIterator)close).close();
    }

    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection<?> o) {
        throw new UnsupportedOperationException();
    }

    public FeatureIterator<Feature> features() {
        try {
            return MappingFeatureIteratorFactory.getInstance(this.store, this.mapping, this.query);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ReferencedEnvelope getBounds() {
        FeatureIterator<Feature> features = this.features();
        try {
            Envelope newBBox = new Envelope();
            while (features.hasNext()) {
                Feature feature = features.next();
                Geometry geometry = (Geometry)feature.getDefaultGeometryProperty().getValue();
                if (geometry == null) continue;
                Envelope internal = geometry.getEnvelopeInternal();
                newBBox.expandToInclude(internal);
            }
            ReferencedEnvelope referencedEnvelope = ReferencedEnvelope.reference((Envelope)newBBox);
            return referencedEnvelope;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occurred while computing bounds", e);
        }
        finally {
            features.close();
        }
    }

    public String getID() {
        return null;
    }

    public FeatureType getSchema() {
        return (FeatureType)this.mapping.getTargetFeature().getType();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator<Feature> iterator() {
        try {
            return MappingFeatureIteratorFactory.getInstance(this.store, this.mapping, this.query);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void purge() {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public void removeListener(CollectionListener listener) throws NullPointerException {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        try {
            int count = this.store.getCount(this.query);
            if (count >= 0) {
                return count;
            }
            int featureCount = 0;
            FeatureIterator<Feature> features = this.features();
            while (features.hasNext()) {
                ++featureCount;
                features.next();
            }
            return featureCount;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FeatureCollection<FeatureType, Feature> sort(SortBy order) {
        throw new UnsupportedOperationException();
    }

    public FeatureCollection<FeatureType, Feature> subCollection(Filter filter) {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    public <O> O[] toArray(O[] a) {
        throw new UnsupportedOperationException();
    }
}

