/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.data.complex.config.AttributeMapping;
import org.geotools.data.complex.config.AttributeTypeProxy;
import org.geotools.data.complex.config.ComplexTypeProxy;
import org.geotools.data.complex.config.FeatureTypeProxy;
import org.geotools.data.complex.config.GeometryTypeProxy;
import org.geotools.feature.Types;
import org.geotools.feature.type.ComplexFeatureTypeFactoryImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.gml3.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.gml3.GMLSchema;
import org.geotools.gml3.smil.SMIL20LANGSchema;
import org.geotools.gml3.smil.SMIL20Schema;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.Schemas;
import org.geotools.xs.XS;
import org.geotools.xs.XSSchema;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.Schema;
import org.opengis.util.InternationalString;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureTypeRegistry {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.complex");
    private static Map<Name, AttributeType> FOUNDATION_TYPES = new HashMap<Name, AttributeType>();
    private static Map<Name, AttributeDescriptor> FOUNDATION_DESCRIPTORS = new HashMap<Name, AttributeDescriptor>();
    private List<SchemaIndex> schemas;
    private HashMap<Name, AttributeDescriptor> descriptorRegistry;
    private HashMap<Name, AttributeType> typeRegistry;
    private FeatureTypeFactory typeFactory;
    private NamespaceSupport namespaces;
    private Stack<Name> processingTypes;

    public FeatureTypeRegistry() {
        this(null);
    }

    public FeatureTypeRegistry(NamespaceSupport namespaces) {
        this.namespaces = namespaces;
        this.schemas = new ArrayList<SchemaIndex>();
        this.typeFactory = new ComplexFeatureTypeFactoryImpl();
        this.descriptorRegistry = new HashMap();
        this.typeRegistry = new HashMap();
        this.processingTypes = new Stack();
        if (FOUNDATION_TYPES.isEmpty()) {
            this.createFoundationTypes();
        }
        this.typeRegistry.putAll(FOUNDATION_TYPES);
        this.descriptorRegistry.putAll(FOUNDATION_DESCRIPTORS);
    }

    public void addSchemas(SchemaIndex schemaIndex) {
        this.schemas.add(schemaIndex);
    }

    public AttributeDescriptor getDescriptor(Name descriptorName, GeometryType geomType, List<AttributeMapping> attMappings) {
        AttributeDescriptor descriptor = this.descriptorRegistry.get(descriptorName);
        if (descriptor == null) {
            try {
                XSDElementDeclaration elemDecl = this.getElementDeclaration(descriptorName);
                descriptor = this.createAttributeDescriptor(null, elemDecl, geomType, attMappings);
                LOGGER.finest("Registering attribute descriptor " + descriptor.getName());
                this.register(descriptor);
            }
            catch (NoSuchElementException e) {
                LOGGER.log(Level.WARNING, e.getMessage());
            }
        }
        return descriptor;
    }

    public AttributeDescriptor getDescriptor(Name descriptorName) {
        return this.getDescriptor(descriptorName, null, null);
    }

    private XSDElementDeclaration getElementDeclaration(Name descriptorName) {
        SchemaIndex schemaIndex;
        QName qname = Types.toQName(descriptorName);
        XSDElementDeclaration elemDecl = null;
        Iterator<SchemaIndex> i$ = this.schemas.iterator();
        while (i$.hasNext() && (elemDecl = (schemaIndex = i$.next()).getElementDeclaration(qname)) == null) {
        }
        if (elemDecl == null) {
            throw new IllegalArgumentException("No top level element found in schemas: " + qname);
        }
        return elemDecl;
    }

    public AttributeType getAttributeType(Name typeName) {
        return this.getAttributeType(typeName, null, null);
    }

    public AttributeType getAttributeType(Name typeName, GeometryType geomType, List<AttributeMapping> attMappings) {
        AttributeType type = this.typeRegistry.get(typeName);
        if (type == null) {
            XSDTypeDefinition typeDef = this.getTypeDefinition(typeName);
            LOGGER.finest("Creating attribute type " + typeDef.getQName());
            type = this.createType(typeDef, geomType, attMappings);
            LOGGER.finest("Registering attribute type " + type.getName());
            this.register(type);
        }
        return type;
    }

    private XSDTypeDefinition getTypeDefinition(Name typeName) {
        SchemaIndex schemaIndex;
        QName qName = Types.toQName(typeName);
        XSDTypeDefinition typeDefinition = null;
        Iterator<SchemaIndex> i$ = this.schemas.iterator();
        while (i$.hasNext() && (typeDefinition = (schemaIndex = i$.next()).getTypeDefinition(qName)) == null) {
        }
        if (typeDefinition == null) {
            throw new IllegalArgumentException("XSD type definition not found in schemas: " + qName);
        }
        return typeDefinition;
    }

    private void register(AttributeDescriptor descriptor) {
        Name name = descriptor.getName();
        this.descriptorRegistry.put(name, descriptor);
    }

    private void register(AttributeType type) {
        Name name = type.getName();
        AttributeType old = this.typeRegistry.put(name, type);
        if (old != null) {
            LOGGER.fine(type.getName() + " replaced by new value.");
        }
    }

    private AttributeDescriptor createAttributeDescriptor(XSDComplexTypeDefinition container, XSDElementDeclaration elemDecl, GeometryType geomType, List<AttributeMapping> attMappings) {
        AttributeDescriptor descriptor;
        AttributeType type;
        String targetNamespace = elemDecl.getTargetNamespace();
        String name = elemDecl.getName();
        Name elemName = Types.typeName(targetNamespace, name);
        try {
            type = this.getTypeOf(elemDecl, geomType, attMappings);
        }
        catch (NoSuchElementException e) {
            String msg = "Type not found for " + elemName + " at type container " + container.getTargetNamespace() + "#" + container.getName() + " at " + container.getSchema().getSchemaLocation();
            NoSuchElementException nse = new NoSuchElementException(msg);
            nse.initCause(e);
            throw nse;
        }
        int minOccurs = container == null ? 0 : Schemas.getMinOccurs((XSDComplexTypeDefinition)container, (XSDElementDeclaration)elemDecl);
        int maxOccurs = container == null ? Integer.MAX_VALUE : Schemas.getMaxOccurs((XSDComplexTypeDefinition)container, (XSDElementDeclaration)elemDecl);
        boolean nillable = elemDecl.isNillable();
        if (maxOccurs == -1) {
            maxOccurs = Integer.MAX_VALUE;
        }
        Object defaultValue = null;
        boolean isGeometry = false;
        if (geomType != null) {
            String nsPrefix = this.namespaces.getPrefix(targetNamespace);
            for (AttributeMapping att : attMappings) {
                String[] attParts = att.getTargetAttributePath().split("/");
                String[] nameParts = attParts[attParts.length - 1].split(":");
                String ns = nameParts.length > 1 ? nameParts[0] : null;
                String attName = ns == null ? nameParts[0] : nameParts[1];
                if (!name.equals(attName) || !nsPrefix.equals(ns) || !geomType.getName().getLocalPart().equals(att.getSourceExpression())) continue;
                isGeometry = true;
                break;
            }
        }
        if (isGeometry) {
            geomType = new GeometryTypeImpl(type.getName(), type.getBinding(), geomType.getCoordinateReferenceSystem(), type.isIdentified(), type.isAbstract(), type.getRestrictions(), type.getSuper(), type.getDescription());
            descriptor = this.typeFactory.createGeometryDescriptor(geomType, elemName, minOccurs, maxOccurs, nillable, defaultValue);
        } else {
            descriptor = this.typeFactory.createAttributeDescriptor(type, elemName, minOccurs, maxOccurs, nillable, defaultValue);
        }
        descriptor.getUserData().put(XSDElementDeclaration.class, elemDecl);
        return descriptor;
    }

    private AttributeType getTypeOf(XSDElementDeclaration elemDecl, GeometryType geomType, List<AttributeMapping> attMappings) {
        AttributeType type;
        XSDTypeDefinition typeDefinition;
        boolean hasToBeRegistered = false;
        if (elemDecl.isElementDeclarationReference()) {
            elemDecl = elemDecl.getResolvedElementDeclaration();
        }
        if ((typeDefinition = elemDecl.getAnonymousTypeDefinition()) == null) {
            hasToBeRegistered = true;
            typeDefinition = elemDecl.getTypeDefinition();
        }
        if (typeDefinition == null) {
            throw new NoSuchElementException("The element declaration " + elemDecl.getTargetNamespace() + "#" + elemDecl.getName() + " has a null type definition, can't continue, fix it on the schema");
        }
        if (hasToBeRegistered) {
            String name;
            String targetNamespace = typeDefinition.getTargetNamespace();
            Name typeName = Types.typeName(targetNamespace, name = typeDefinition.getName());
            type = this.getAttributeType(typeName, geomType, attMappings);
            if (type == null) {
                type = this.createType(typeName, typeDefinition, geomType, attMappings);
                this.register(type);
            }
        } else {
            String name = elemDecl.getName();
            String targetNamespace = elemDecl.getTargetNamespace();
            Name overrideName = Types.typeName(targetNamespace, name);
            type = this.createType(overrideName, typeDefinition, geomType, attMappings);
        }
        return type;
    }

    private AttributeType createProxiedType(Name assignedName, XSDTypeDefinition typeDefinition) {
        boolean isGeometryType;
        boolean isFeatureType;
        AttributeTypeProxy type = null == typeDefinition.getSimpleType() && typeDefinition instanceof XSDComplexTypeDefinition ? ((isFeatureType = this.isDerivedFrom(typeDefinition, GML.AbstractFeatureType)) ? new FeatureTypeProxy(assignedName, this.typeRegistry) : new ComplexTypeProxy(assignedName, this.typeRegistry)) : ((isGeometryType = this.isDerivedFrom(typeDefinition, GML.AbstractGeometryType)) ? new GeometryTypeProxy(assignedName, this.typeRegistry) : new AttributeTypeProxy(assignedName, this.typeRegistry));
        return type;
    }

    private boolean isDerivedFrom(XSDTypeDefinition typeDefinition, QName baseTypeName) {
        Name typeName = Types.toTypeName(baseTypeName);
        return this.isDerivedFrom(typeDefinition, typeName);
    }

    private AttributeType createType(XSDTypeDefinition typeDefinition, GeometryType geomType, List<AttributeMapping> attMappings) {
        String targetNamespace = typeDefinition.getTargetNamespace();
        String name = typeDefinition.getName();
        Name typeName = Types.typeName(targetNamespace, name);
        return this.createType(typeName, typeDefinition, geomType, attMappings);
    }

    private AttributeType createType(Name assignedName, XSDTypeDefinition typeDefinition, GeometryType geomType, List<AttributeMapping> attMappings) {
        AttributeType attType;
        if (this.processingTypes.contains(assignedName)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Recursion found for type " + assignedName + ". Proxying it.");
            }
            AttributeType attType2 = this.createProxiedType(assignedName, typeDefinition);
            return attType2;
        }
        this.processingTypes.push(assignedName);
        XSDTypeDefinition baseType = typeDefinition.getBaseType();
        AttributeType superType = null;
        if (baseType != null) {
            String name;
            String targetNamespace = baseType.getTargetNamespace();
            superType = this.getType(targetNamespace, name = baseType.getName());
            if (superType == null) {
                superType = this.createType(baseType, geomType, attMappings);
                this.register(superType);
            }
        } else {
            LOGGER.warning(assignedName + " has no super type");
        }
        if (typeDefinition instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition complexTypeDef = (XSDComplexTypeDefinition)typeDefinition;
            boolean includeParents = true;
            List children = Schemas.getChildElementDeclarations((XSDTypeDefinition)typeDefinition, (boolean)includeParents);
            ArrayList<PropertyDescriptor> schema = new ArrayList<PropertyDescriptor>(children.size());
            for (XSDElementDeclaration childDecl : children) {
                try {
                    AttributeDescriptor descriptor = this.createAttributeDescriptor(complexTypeDef, childDecl, geomType, attMappings);
                    schema.add((PropertyDescriptor)descriptor);
                }
                catch (NoSuchElementException e) {
                    LOGGER.log(Level.WARNING, e.getMessage());
                    throw e;
                }
            }
            attType = this.createComplexAttributeType(assignedName, schema, complexTypeDef, superType);
        } else {
            Class<String> binding = String.class;
            boolean isIdentifiable = false;
            boolean isAbstract = false;
            List restrictions = Collections.emptyList();
            InternationalString description = null;
            attType = this.typeFactory.createAttributeType(assignedName, binding, isIdentifiable, isAbstract, restrictions, superType, description);
        }
        attType.getUserData().put(XSDTypeDefinition.class, typeDefinition);
        this.processingTypes.pop();
        return attType;
    }

    private AttributeType createComplexAttributeType(Name assignedName, Collection<PropertyDescriptor> schema, XSDComplexTypeDefinition typeDefinition, AttributeType superType) {
        ComplexType type;
        AttributeType abstractFType = this.getType("http://www.opengis.net/gml", GML.AbstractFeatureType.getLocalPart());
        assert (abstractFType != null);
        boolean isFeatureType = this.isDerivedFrom((XSDTypeDefinition)typeDefinition, abstractFType.getName());
        boolean isAbstract = false;
        List restrictions = Collections.emptyList();
        InternationalString description = null;
        if (isFeatureType) {
            GeometryDescriptor defaultGeometry = null;
            for (PropertyDescriptor att : schema) {
                if (defaultGeometry != null) continue;
                if (!(att instanceof GeometryDescriptor)) break;
                defaultGeometry = (GeometryDescriptor)att;
                break;
            }
            type = this.typeFactory.createFeatureType(assignedName, schema, defaultGeometry, isAbstract, restrictions, superType, description);
        } else {
            boolean isIdentifiable = this.isIdentifiable(typeDefinition);
            type = this.typeFactory.createComplexType(assignedName, schema, isIdentifiable, isAbstract, restrictions, superType, description);
        }
        return type;
    }

    private boolean isIdentifiable(XSDComplexTypeDefinition typeDefinition) {
        EList attributeUses = typeDefinition.getAttributeUses();
        String idAttName = GML.id.getLocalPart();
        for (XSDAttributeUse use : attributeUses) {
            XSDAttributeUseCategory useCategory = use.getUse();
            XSDAttributeDeclaration idAtt = use.getAttributeDeclaration();
            String targetNamespace = idAtt.getTargetNamespace();
            String name = idAtt.getName();
            if (!"http://www.opengis.net/gml".equals(targetNamespace) || !idAttName.equals(name) || !XSDAttributeUseCategory.REQUIRED_LITERAL.equals(useCategory)) continue;
            return true;
        }
        return false;
    }

    private boolean isDerivedFrom(XSDTypeDefinition typeDefinition, Name superTypeName) {
        XSDTypeDefinition baseType;
        String superNS = superTypeName.getNamespaceURI();
        String superName = superTypeName.getLocalPart();
        while ((baseType = typeDefinition.getBaseType()) != null) {
            String targetNamespace = baseType.getTargetNamespace();
            String name = baseType.getName();
            if ("http://www.w3.org/2001/XMLSchema".equals(targetNamespace) && XS.ANYTYPE.getLocalPart().equals(name)) {
                return false;
            }
            if (superNS.equals(targetNamespace) && superName.equals(name)) {
                return true;
            }
            typeDefinition = baseType;
        }
        return false;
    }

    private AttributeType getType(String namespace, String name) {
        Name typeName = Types.typeName(namespace, name);
        return this.getAttributeType(typeName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFoundationTypes() {
        Map<Name, AttributeType> map = FOUNDATION_TYPES;
        synchronized (map) {
            if (!FOUNDATION_TYPES.isEmpty()) {
                return;
            }
            XSSchema schema = new XSSchema();
            this.importSchema((Schema)schema);
            schema = new SMIL20Schema();
            this.importSchema((Schema)schema);
            schema = new SMIL20LANGSchema();
            this.importSchema((Schema)schema);
            schema = new GMLSchema();
            this.importSchema((Schema)schema);
            LOGGER.info("Creating GMLConfiguration to get the prebuilt gml schemas from");
            GMLConfiguration configuration = new GMLConfiguration();
            LOGGER.info("Aquiring prebuilt gml schema and its dependencies");
            SchemaIndex index = Schemas.findSchemas((Configuration)configuration);
            this.addSchemas(index);
            FOUNDATION_TYPES.putAll(this.typeRegistry);
            FOUNDATION_DESCRIPTORS.putAll(this.descriptorRegistry);
            this.typeRegistry.clear();
            this.descriptorRegistry.clear();
        }
    }

    private void importSchema(Schema schema) {
        for (Map.Entry entry : schema.entrySet()) {
            Name key = (Name)entry.getKey();
            Object value = entry.getValue();
            if (this.typeRegistry.containsKey(key)) {
                LOGGER.finer("Ignoring " + key + " as it already exists. type " + value.getClass().getName());
                continue;
            }
            LOGGER.finer("Importing " + key + " of type " + value.getClass().getName());
            if (value instanceof AttributeType) {
                AttributeType type = (AttributeType)value;
                this.register(type);
                continue;
            }
            if (!(value instanceof AttributeDescriptor)) continue;
            AttributeDescriptor descriptor = (AttributeDescriptor)value;
            this.register(descriptor);
        }
        LOGGER.fine("Schema " + schema.getURI() + " imported successfully");
    }
}

