/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeBuilder;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.NameImpl;
import org.geotools.feature.Types;
import org.geotools.feature.ValidatingFeatureFactoryImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.ComplexFeatureTypeImpl;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.util.CheckedArrayList;
import org.geotools.util.logging.Logging;
import org.geotools.xs.XSSchema;
import org.opengis.feature.Association;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.PropertyName;
import org.opengis.util.Cloneable;
import org.xml.sax.helpers.NamespaceSupport;

public class XPath {
    private static final Logger LOGGER = Logging.getLogger((String)XPath.class.getPackage().getName());
    private FilterFactory FF;
    private FeatureFactory featureFactory;
    private FeatureTypeFactory descriptorFactory;

    public XPath() {
        this.FF = CommonFactoryFinder.getFilterFactory(null);
        this.featureFactory = new ValidatingFeatureFactoryImpl();
        this.descriptorFactory = new FeatureTypeFactoryImpl();
    }

    public XPath(FilterFactory ff, FeatureFactory featureFactory) {
        this.setFilterFactory(ff);
        this.setFeatureFactory(featureFactory);
    }

    public void setFilterFactory(FilterFactory ff) {
        this.FF = ff;
    }

    public void setFeatureFactory(FeatureFactory featureFactory) {
        this.featureFactory = featureFactory;
    }

    public static StepList steps(AttributeDescriptor root, String xpathExpression, NamespaceSupport namespaces) throws IllegalArgumentException {
        int startIndex;
        String[] partialSteps;
        if (root == null) {
            throw new NullPointerException("root");
        }
        if (xpathExpression == null) {
            throw new NullPointerException("xpathExpression");
        }
        String expression = xpathExpression.trim();
        if ("".equals(expression)) {
            throw new IllegalArgumentException("expression is empty");
        }
        StepList steps = new StepList();
        if ("/".equals(expression)) {
            expression = root.getName().getLocalPart();
        }
        if (expression.startsWith("/")) {
            expression = expression.substring(1);
        }
        if ((partialSteps = expression.split("[/]")).length == 0) {
            throw new IllegalArgumentException("no steps provided");
        }
        for (int i = startIndex = 0; i < partialSteps.length; ++i) {
            String step = partialSteps[i];
            if ("..".equals(step)) {
                steps.remove(steps.size() - 1);
                continue;
            }
            if (".".equals(step)) continue;
            int index = 1;
            boolean isXmlAttribute = false;
            boolean isIndexed = false;
            String stepName = step;
            if (step.indexOf(91) != -1) {
                int start = step.indexOf(91);
                int end = step.indexOf(93);
                stepName = step.substring(0, start);
                Scanner scanner = new Scanner(step.substring(start + 1, end));
                if (scanner.hasNextInt()) {
                    index = scanner.nextInt();
                    isIndexed = true;
                }
            }
            if (step.charAt(0) == '@') {
                isXmlAttribute = true;
                stepName = stepName.substring(1);
            }
            QName qName = XPath.deglose(stepName, root, namespaces, isXmlAttribute);
            steps.add(new Step(qName, index, isXmlAttribute, isIndexed));
        }
        if (root != null && steps.size() > 1) {
            QName stepName;
            Step step = (Step)steps.get(0);
            Name rootName = root.getName();
            if (Types.equals(rootName, stepName = step.getName())) {
                LOGGER.fine("removing root name from xpath " + (Object)((Object)steps) + " as it is redundant");
                steps.remove(0);
            }
        }
        return steps;
    }

    private static QName deglose(String prefixedName, AttributeDescriptor root, NamespaceSupport namespaces, boolean isXmlAttribute) {
        String prefix;
        String namespaceUri;
        String localName;
        if (prefixedName == null) {
            throw new NullPointerException("prefixedName");
        }
        QName name = null;
        int prefixIdx = prefixedName.indexOf(58);
        if (prefixIdx == -1) {
            String defaultNamespace;
            localName = prefixedName;
            Name rootName = root.getName();
            namespaceUri = defaultNamespace = isXmlAttribute || localName.equals(ComplexFeatureTypeImpl.FEATURE_CHAINING_LINK_NAME.getLocalPart()) || rootName.getNamespaceURI() == null ? "" : rootName.getNamespaceURI();
            if ("".equals(defaultNamespace)) {
                prefix = "";
            } else {
                if (!localName.equals(rootName.getLocalPart())) {
                    LOGGER.warning("Using root's namespace " + defaultNamespace + " for step named '" + localName + "', as no prefix was stated");
                }
                if ((prefix = namespaces.getPrefix(defaultNamespace)) == null) {
                    throw new IllegalStateException("Default namespace is not mapped to a prefix: " + defaultNamespace);
                }
            }
        } else {
            prefix = prefixedName.substring(0, prefixIdx);
            localName = prefixedName.substring(prefixIdx + 1);
            namespaceUri = namespaces.getURI(prefix);
        }
        name = new QName(namespaceUri, localName, prefix);
        return name;
    }

    public Attribute set(Attribute att, StepList xpath, Object value, String id, AttributeType targetNodeType, boolean isXlinkRef) {
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.entering("XPath", "set", new Object[]{att, xpath, value, id, targetNodeType});
        }
        StepList steps = new StepList(xpath);
        ComplexAttribute parent = (ComplexAttribute)att;
        Name rootName = null;
        if (parent.getDescriptor() != null) {
            rootName = parent.getDescriptor().getName();
            Step rootStep = (Step)steps.get(0);
            QName stepName = rootStep.getName();
            if (stepName.getLocalPart().equals(rootName.getLocalPart()) && ("".equals(stepName.getNamespaceURI()) || stepName.getNamespaceURI().equals(rootName.getNamespaceURI()))) {
                steps.remove(0);
            }
        }
        Iterator stepsIterator = steps.iterator();
        while (stepsIterator.hasNext()) {
            Step currStep = (Step)stepsIterator.next();
            ComplexType parentType = parent.getType();
            QName stepName = currStep.getName();
            Name attributeName = Types.toName(stepName);
            boolean isLastStep = !stepsIterator.hasNext();
            AttributeDescriptor currStepDescriptor = null;
            if (!isLastStep || targetNodeType == null) {
                String prefixedStepName;
                PropertyName name;
                Attribute child;
                currStepDescriptor = null == attributeName.getNamespaceURI() ? (AttributeDescriptor)Types.descriptor(parentType, attributeName.getLocalPart()) : (AttributeDescriptor)Types.descriptor(parentType, attributeName);
                if (currStepDescriptor == null && (child = (Attribute)(name = this.FF.property(prefixedStepName = currStep.toString())).evaluate((Object)parent)) != null) {
                    currStepDescriptor = child.getDescriptor();
                }
            } else {
                AttributeDescriptor actualDescriptor = null == attributeName.getNamespaceURI() ? (AttributeDescriptor)Types.descriptor(parentType, attributeName.getLocalPart(), targetNodeType) : (AttributeDescriptor)Types.descriptor(parentType, attributeName, targetNodeType);
                if (actualDescriptor != null) {
                    int minOccurs = actualDescriptor.getMinOccurs();
                    int maxOccurs = actualDescriptor.getMaxOccurs();
                    boolean nillable = actualDescriptor.isNillable();
                    currStepDescriptor = this.descriptorFactory.createAttributeDescriptor(targetNodeType, attributeName, minOccurs, maxOccurs, nillable, null);
                }
            }
            if (currStepDescriptor == null) {
                StringBuffer parentAtts = new StringBuffer();
                Collection properties = parentType.getDescriptors();
                Iterator it = properties.iterator();
                while (it.hasNext()) {
                    PropertyDescriptor desc = (PropertyDescriptor)it.next();
                    Name name = desc.getName();
                    parentAtts.append(name.getNamespaceURI());
                    parentAtts.append("#");
                    parentAtts.append(name.getLocalPart());
                    if (!it.hasNext()) continue;
                    parentAtts.append(", ");
                }
                throw new IllegalArgumentException(currStep + " is not a valid location path for type " + parentType.getName() + ". " + currStep + " ns: " + currStep.getName().getNamespaceURI() + ", " + parentType.getName().getLocalPart() + " properties: " + parentAtts);
            }
            if (isLastStep) {
                if (currStepDescriptor == null) {
                    throw new IllegalArgumentException(currStep + " is not a valid location path for type " + parentType.getName());
                }
                int index = currStep.getIndex();
                Attribute attribute = this.setValue(currStepDescriptor, id, value, index, parent, targetNodeType, isXlinkRef);
                return attribute;
            }
            int index = currStep.getIndex();
            Attribute _parent = this.setValue(currStepDescriptor, null, null, index, parent, null, isXlinkRef);
            parent = (ComplexAttribute)_parent;
        }
        throw new IllegalStateException();
    }

    private Attribute setValue(AttributeDescriptor descriptor, String id, Object value, int index, ComplexAttribute parent, AttributeType targetNodeType, boolean isXlinkRef) {
        Object convertedValue = this.convertValue(descriptor, value);
        Attribute leafAttribute = null;
        Name attributeName = descriptor.getName();
        Collection currStepValue = parent.getProperties(attributeName);
        if (!isXlinkRef) {
            if (currStepValue instanceof Collection) {
                ArrayList values = new ArrayList(currStepValue);
                if (convertedValue == null && values.size() >= index) {
                    leafAttribute = (Attribute)values.get(index - 1);
                }
                for (Attribute stepValue : values) {
                    if (!stepValue.getValue().equals(convertedValue)) continue;
                    return stepValue;
                }
            } else if (currStepValue instanceof Attribute) {
                leafAttribute = (Attribute)currStepValue;
            } else if (currStepValue != null) {
                throw new IllegalStateException("Unknown addressed object. Xpath:" + attributeName + ", addressed: " + currStepValue.getClass().getName() + " [" + currStepValue.toString() + "]");
            }
        }
        if (leafAttribute == null) {
            AttributeBuilder builder = new AttributeBuilder(this.featureFactory);
            builder.setDescriptor(parent.getDescriptor());
            builder.setType((AttributeType)parent.getType());
            if (parent instanceof ComplexAttribute) {
                ComplexAttribute complex = parent;
                Collection properties = complex.getValue();
                for (Property property : properties) {
                    if (property instanceof Attribute && !property.getName().getLocalPart().equals("simpleContent")) {
                        Attribute att = (Attribute)property;
                        builder.add(att.getIdentifier() == null ? null : att.getIdentifier().toString(), att.getValue(), att.getName());
                        continue;
                    }
                    if (!(property instanceof Association)) continue;
                    Association assoc = (Association)property;
                    builder.associate(assoc.getValue(), assoc.getName());
                }
            }
            leafAttribute = targetNodeType != null ? builder.add(id, convertedValue, attributeName, targetNodeType) : builder.add(id, convertedValue, attributeName);
            ArrayList<Attribute> newValue = new ArrayList<Attribute>();
            newValue.addAll(parent.getValue());
            newValue.add(leafAttribute);
            parent.setValue(newValue);
        }
        if (convertedValue != null) {
            leafAttribute.setValue(convertedValue);
        }
        return leafAttribute;
    }

    private Object convertValue(AttributeDescriptor descriptor, Object value) {
        AttributeType type = descriptor.getType();
        Class binding = type.getBinding();
        if (type instanceof ComplexType && binding == Collection.class && !(value instanceof Collection) && XPath.isSimpleContentType(type)) {
            ArrayList<Attribute> list = new ArrayList<Attribute>();
            list.add(this.buildSimpleContent(type, value));
            return list;
        }
        return this.FF.literal(value).evaluate(value, binding);
    }

    static boolean isSimpleContentType(AttributeType type) {
        if (type == XSSchema.ANYSIMPLETYPE_TYPE) {
            throw new RuntimeException("Unexpected simple type");
        }
        AttributeType superType = type.getSuper();
        if (superType == XSSchema.ANYSIMPLETYPE_TYPE) {
            return true;
        }
        if (superType == null) {
            return false;
        }
        return XPath.isSimpleContentType(superType);
    }

    static AttributeType getSimpleContentType(AttributeType type) {
        Class binding = type.getBinding();
        if (binding == Collection.class) {
            return XPath.getSimpleContentType(type.getSuper());
        }
        return type;
    }

    Attribute buildSimpleContent(AttributeType type, Object value) {
        AttributeType simpleContentType = XPath.getSimpleContentType(type);
        Object convertedValue = this.FF.literal(value).evaluate(value, XPath.getSimpleContentType(type).getBinding());
        NameImpl name = new NameImpl(null, "simpleContent");
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl(simpleContentType, (Name)name, 1, 1, true, (Object)null);
        return new AttributeImpl(convertedValue, (AttributeDescriptor)descriptor, null){

            public String toString() {
                return this.getValue().toString();
            }
        };
    }

    public boolean isComplexType(StepList attrXPath, AttributeDescriptor featureType) {
        PropertyName attExp = this.FF.property(attrXPath.toString());
        Object type = attExp.evaluate((Object)featureType);
        if (type == null) {
            type = attExp.evaluate((Object)featureType);
            throw new IllegalArgumentException("path not found: " + (Object)((Object)attrXPath));
        }
        AttributeDescriptor node = (AttributeDescriptor)type;
        return node.getType() instanceof ComplexType;
    }

    public static class Step
    implements Cloneable {
        private int index;
        private QName attributeName;
        private boolean isXmlAttribute;
        private boolean isIndexed;

        public Step(QName name, int index) {
            this(name, index, false, false);
        }

        public Step(QName name, int index, boolean isXmlAttribute) {
            this(name, index, isXmlAttribute, false);
        }

        public Step(QName name, int index, boolean isXmlAttribute, boolean isIndexed) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (index < 1) {
                throw new IllegalArgumentException("index shall be >= 1");
            }
            this.attributeName = name;
            this.index = index;
            this.isXmlAttribute = isXmlAttribute;
            this.isIndexed = isIndexed;
        }

        public boolean equalsIgnoreIndex(Step other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            return other.getName().equals(this.getName());
        }

        public int getIndex() {
            return this.index;
        }

        public QName getName() {
            return this.attributeName;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.isXmlAttribute ? "@" : "");
            if ("" != this.attributeName.getPrefix()) {
                sb.append(this.attributeName.getPrefix()).append(':');
            }
            sb.append(this.attributeName.getLocalPart());
            if (this.isIndexed || this.index > 1) {
                sb.append("[").append(this.index).append("]");
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Step)) {
                return false;
            }
            Step s = (Step)o;
            return this.attributeName.equals(s.attributeName) && this.index == s.index && this.isXmlAttribute == s.isXmlAttribute;
        }

        public int hashCode() {
            return 17 * this.attributeName.hashCode() + 37 * this.index;
        }

        public Object clone() {
            return new Step(this.attributeName, this.index, this.isXmlAttribute, this.isIndexed);
        }

        public boolean isXmlAttribute() {
            return this.isXmlAttribute;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StepList
    extends CheckedArrayList<Step> {
        private static final long serialVersionUID = -5612786286175355862L;

        private StepList() {
            super(Step.class);
        }

        public StepList(StepList steps) {
            super(Step.class);
            this.addAll((Collection)((Object)steps));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Step s = (Step)it.next();
                sb.append(s.toString());
                if (!it.hasNext()) continue;
                sb.append("/");
            }
            return sb.toString();
        }

        public StepList clone() {
            StepList copy = new StepList();
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                Step step = (Step)i$.next();
                copy.add((Step)step.clone());
            }
            return copy;
        }

        public boolean equalsIgnoreIndex(StepList propertyName) {
            if (propertyName == null) {
                return false;
            }
            if (propertyName == this) {
                return true;
            }
            if (this.size() != propertyName.size()) {
                return false;
            }
            Iterator mine = this.iterator();
            Iterator him = propertyName.iterator();
            while (mine.hasNext()) {
                Step hisStep;
                Step myStep = (Step)mine.next();
                if (myStep.equalsIgnoreIndex(hisStep = (Step)him.next())) continue;
                return false;
            }
            return true;
        }
    }
}

