/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.config.NonFeatureTypeProxy;
import org.geotools.feature.Types;
import org.geotools.util.logging.Logging;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.type.Name;

public class AppSchemaDataAccessRegistryTest {
    public static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.complex");
    private static final String GSMLNS = "http://www.cgi-iugs.org/xml/GeoSciML/2";
    private static final Name MAPPED_FEATURE = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"MappedFeature");
    private static final Name GEOLOGIC_UNIT = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"GeologicUnit");
    private static final Name COMPOSITION_PART = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"CompositionPart");
    private static final Name CGI_TERM_VALUE = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"CGI_TermValue");
    private static final Name CONTROLLED_CONCEPT = Types.typeName((String)"http://www.cgi-iugs.org/xml/GeoSciML/2", (String)"ControlledConcept");
    private static final String schemaBase = "/test-data/";
    private static AppSchemaDataAccess guDataAccess;
    private static AppSchemaDataAccess cpDataAccess;
    private static AppSchemaDataAccess mfDataAccess;
    private static AppSchemaDataAccess cgiDataAccess;
    private static AppSchemaDataAccess ccDataAccess;

    @Test
    public void testRegisterAndUnregisterDataAccess() throws Exception {
        this.checkRegisteredDataAccess(mfDataAccess, MAPPED_FEATURE, false);
        this.checkRegisteredDataAccess(guDataAccess, GEOLOGIC_UNIT, false);
        this.checkRegisteredDataAccess(cpDataAccess, COMPOSITION_PART, true);
        this.checkRegisteredDataAccess(cgiDataAccess, CGI_TERM_VALUE, true);
        this.checkRegisteredDataAccess(ccDataAccess, CONTROLLED_CONCEPT, true);
        this.unregister((DataAccess)mfDataAccess, MAPPED_FEATURE);
        this.unregister((DataAccess)guDataAccess, GEOLOGIC_UNIT);
        this.unregister((DataAccess)cpDataAccess, COMPOSITION_PART);
        this.unregister((DataAccess)cgiDataAccess, CGI_TERM_VALUE);
        this.unregister((DataAccess)ccDataAccess, CONTROLLED_CONCEPT);
    }

    @Test
    public void testThrowDataSourceException() throws Exception {
        Name typeName = Types.typeName((String)GSMLNS, (String)"DoesNotExist");
        boolean handledException = false;
        try {
            AppSchemaDataAccessRegistry.getMapping((Name)typeName);
        }
        catch (DataSourceException e) {
            LOGGER.info(e.toString());
            handledException = true;
        }
        Assert.assertTrue((String)"Expected a DataSourceException to have been thrown and handled", (boolean)handledException);
    }

    @BeforeClass
    public static void setUp() throws Exception {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = AppSchemaDataAccessRegistryTest.class.getResource("/test-data/MappedFeaturePropertyfile.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        mfDataAccess = (AppSchemaDataAccess)DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)mfDataAccess);
        url = AppSchemaDataAccessRegistryTest.class.getResource("/test-data/GeologicUnit.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("url", url.toExternalForm());
        guDataAccess = (AppSchemaDataAccess)DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)guDataAccess);
        cpDataAccess = (AppSchemaDataAccess)DataAccessRegistry.getDataAccess((Name)COMPOSITION_PART);
        Assert.assertNotNull((Object)cpDataAccess);
        cgiDataAccess = (AppSchemaDataAccess)DataAccessRegistry.getDataAccess((Name)CGI_TERM_VALUE);
        Assert.assertNotNull((Object)cgiDataAccess);
        ccDataAccess = (AppSchemaDataAccess)DataAccessRegistry.getDataAccess((Name)CONTROLLED_CONCEPT);
        Assert.assertNotNull((Object)ccDataAccess);
    }

    @AfterClass
    public static void tearDown() {
        DataAccessRegistry.unregisterAll();
    }

    private void checkRegisteredDataAccess(AppSchemaDataAccess dataAccess, Name typeName, boolean isNonFeature) throws IOException {
        FeatureTypeMapping mapping = AppSchemaDataAccessRegistry.getMapping((Name)typeName);
        Assert.assertNotNull((Object)mapping);
        Assert.assertEquals((Object)dataAccess.getMapping(typeName).equals(mapping), (Object)true);
        if (isNonFeature) {
            Assert.assertEquals((Object)(mapping.getTargetFeature().getType() instanceof NonFeatureTypeProxy), (Object)true);
        }
        FeatureSource source = AppSchemaDataAccessRegistry.getSimpleFeatureSource((Name)typeName);
        Assert.assertNotNull((Object)source);
        Assert.assertEquals((Object)mapping.getSource(), (Object)source);
        FeatureSource mappedSource = DataAccessRegistry.getFeatureSource((Name)typeName);
        Assert.assertNotNull((Object)mappedSource);
        Assert.assertEquals((Object)mappedSource.getDataStore().equals(dataAccess), (Object)true);
    }

    private void unregister(DataAccess dataAccess, Name typeName) throws IOException {
        DataAccessRegistry.unregister((DataAccess)dataAccess);
        boolean notFound = false;
        try {
            FeatureTypeMapping mapping = AppSchemaDataAccessRegistry.getMapping((Name)typeName);
        }
        catch (DataSourceException e) {
            notFound = true;
        }
        if (!notFound) {
            Assert.fail((String)"Expecting DataSourceException but didn't occur. Deregistering data access fails.");
        }
        notFound = false;
        try {
            FeatureSource source = AppSchemaDataAccessRegistry.getSimpleFeatureSource((Name)typeName);
        }
        catch (DataSourceException e) {
            notFound = true;
        }
        if (!notFound) {
            Assert.fail((String)"Expecting DataSourceException but didn't occur. Deregistering data access fails.");
        }
    }
}

