/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import junit.framework.TestCase;
import org.geotools.data.ComplexTestData;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeBuilder;
import org.geotools.feature.ValidatingFeatureFactoryImpl;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.identity.FeatureId;

public class IDFunctionExpressionTest
extends TestCase {
    Feature feature;
    Function idExpr;

    public IDFunctionExpressionTest() {
        super("IDFunctionExpressionTest");
    }

    protected void setUp() throws Exception {
        super.setUp();
        FeatureTypeFactoryImpl typeFactory = new FeatureTypeFactoryImpl();
        FeatureType type = ComplexTestData.createExample02MultipleMultivalued((FeatureTypeFactory)typeFactory);
        AttributeBuilder ab = new AttributeBuilder((FeatureFactory)new ValidatingFeatureFactoryImpl());
        ab.setType((AttributeType)type);
        this.feature = (Feature)ab.build("test-id");
        this.idExpr = CommonFactoryFinder.getFilterFactory(null).function("getID", new Expression[0]);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetValue() throws Exception {
        FeatureId fid = this.feature.getIdentifier();
        Object found = this.idExpr.evaluate((Object)this.feature);
        IDFunctionExpressionTest.assertNotNull((Object)found);
        IDFunctionExpressionTest.assertEquals((Object)fid, (Object)found);
    }

    public void testGetName() {
        IDFunctionExpressionTest.assertEquals((String)"getID", (String)this.idExpr.getName());
    }

    public void testGetArgs() {
        IDFunctionExpressionTest.assertNotNull((Object)this.idExpr.getParameters());
        IDFunctionExpressionTest.assertEquals((int)0, (int)this.idExpr.getParameters().size());
    }
}

