/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.XmlFeatureTypeMapping;
import org.geotools.data.complex.filter.UnmappingFilterVisitor;
import org.geotools.data.complex.filter.XPath;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUnmappingFilterVisitor
extends UnmappingFilterVisitor {
    private static final Logger LOGGER = Logging.getLogger((String)XmlUnmappingFilterVisitor.class.getPackage().getName());
    private static final FilterFactory2 ff = new FilterFactoryImpl(null);

    public XmlUnmappingFilterVisitor(FeatureTypeMapping mappings) {
        super(mappings);
    }

    @Override
    protected List<Expression> findMappingsFor(FeatureTypeMapping mappings, XPath.StepList propertyName) {
        List<String> candidates;
        XmlFeatureTypeMapping xmlMapping = (XmlFeatureTypeMapping)mappings;
        if (!propertyName.toString().contains("[")) {
            candidates = xmlMapping.getStringMappingsIgnoreIndex(propertyName);
        } else {
            candidates = new ArrayList<String>();
            String mapping = xmlMapping.getStringMapping(propertyName);
            if (mapping != null) {
                candidates.add(mapping);
            }
        }
        List<Expression> expressions = this.getExpressions(candidates);
        return expressions;
    }

    private List<Expression> getExpressions(List<String> candidates) {
        ArrayList<Expression> ls = new ArrayList<Expression>(candidates.size());
        for (String element : candidates) {
            PropertyName ex = ff.property(element);
            ls.add((Expression)ex);
        }
        return ls;
    }
}

