/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.session;

import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeDBMSInfo;
import com.esri.sde.sdk.client.SeDelete;
import com.esri.sde.sdk.client.SeError;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeFilter;
import com.esri.sde.sdk.client.SeInsert;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeObjectId;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeQueryInfo;
import com.esri.sde.sdk.client.SeRasterColumn;
import com.esri.sde.sdk.client.SeRegistration;
import com.esri.sde.sdk.client.SeRelease;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeSqlConstruct;
import com.esri.sde.sdk.client.SeState;
import com.esri.sde.sdk.client.SeStreamOp;
import com.esri.sde.sdk.client.SeTable;
import com.esri.sde.sdk.client.SeUpdate;
import com.esri.sde.sdk.client.SeVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.logging.Loggers;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.session.SdeRow;
import org.geotools.arcsde.versioning.ArcSdeVersionHandler;

public class Commands {
    private static final Logger LOGGER = Loggers.getLogger("org.geotools.arcsde.session");
    public static final Command<Void> TEST_SERVER = new Command<Void>(){

        @Override
        public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
            connection.testServer(5L);
            return null;
        }
    };
    public static final Command<SeVersion> GET_DEFAULT_VERSION = new GetVersionCommand(SeVersion.SE_QUALIFIED_DEFAULT_VERSION_NAME);
    public static final Command<Void> START_TRANSACTION = new Command<Void>(){

        @Override
        public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
            connection.setTransactionAutoCommit(0);
            connection.startTransaction();
            return null;
        }
    };
    public static final Command<List<String>> GET_RASTER_COLUMN_NAMES = new Command<List<String>>(){

        @Override
        public List<String> execute(ISession session, SeConnection connection) throws SeException, IOException {
            Vector rasterColumns = connection.getRasterColumns();
            ArrayList<String> names = new ArrayList<String>(rasterColumns.size());
            for (SeRasterColumn col : rasterColumns) {
                names.add(col.getQualifiedTableName());
            }
            return names;
        }
    };
    public static final Command<Void> COMMIT_TRANSACTION = new CommitTransaction();
    public static final Command<Void> ROLLBACK_TRANSACTION = new Command<Void>(){

        @Override
        public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
            connection.rollbackTransaction();
            return null;
        }
    };
    public static final Command<Void> CLOSE_CONNECTION = new CloseConnection();
    public static final Command<List<SeLayer>> GET_LAYERS = new Command<List<SeLayer>>(){

        @Override
        public List<SeLayer> execute(ISession session, SeConnection connection) throws SeException, IOException {
            return connection.getLayers();
        }
    };
    public static final Command<String> GET_USER = new Command<String>(){

        @Override
        public String execute(ISession session, SeConnection connection) throws SeException, IOException {
            return connection.getUser();
        }
    };
    public static final Command<SeRelease> GET_RELEASE = new Command<SeRelease>(){

        @Override
        public SeRelease execute(ISession session, SeConnection connection) throws SeException, IOException {
            return connection.getRelease();
        }
    };
    public static final Command<String> GET_DATABASENAME = new Command<String>(){

        @Override
        public String execute(ISession session, SeConnection connection) throws SeException, IOException {
            return connection.getDatabaseName();
        }
    };
    public static final Command<SeDBMSInfo> GET_DBMS_INFO = new Command<SeDBMSInfo>(){

        @Override
        public SeDBMSInfo execute(ISession session, SeConnection connection) throws SeException, IOException {
            return connection.getDBMSInfo();
        }
    };
    public static final Command<SeInsert> CREATE_SEINSERT = new Command<SeInsert>(){

        @Override
        public SeInsert execute(ISession session, SeConnection connection) throws SeException, IOException {
            return new SeInsert(connection);
        }
    };
    public static final Command<SeUpdate> CREATE_SEUPDATE = new Command<SeUpdate>(){

        @Override
        public SeUpdate execute(ISession session, SeConnection connection) throws SeException, IOException {
            return new SeUpdate(connection);
        }
    };
    public static final Command<SeDelete> CREATE_SEDELETE = new Command<SeDelete>(){

        @Override
        public SeDelete execute(ISession session, SeConnection connection) throws SeException, IOException {
            return new SeDelete(connection);
        }
    };

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PrepareQueryCommand
    extends Command<SeQuery> {
        private final SeFilter[] spatialConstraints;
        private final SeQueryInfo qInfo;
        private ArcSdeVersionHandler version;

        public PrepareQueryCommand(SeQueryInfo qInfo, SeFilter[] spatialConstraints, ArcSdeVersionHandler version) {
            this.qInfo = qInfo;
            this.spatialConstraints = spatialConstraints;
            this.version = version;
        }

        @Override
        public SeQuery execute(ISession session, SeConnection connection) throws SeException, IOException {
            SeQuery seQuery = new SeQuery(connection);
            this.version.setUpStream(session, (SeStreamOp)seQuery);
            seQuery.prepareQueryInfo(this.qInfo);
            if (this.spatialConstraints.length > 0) {
                boolean setReturnGeometryMasks = false;
                seQuery.setSpatialConstraints(SeQuery.SE_OPTIMIZE, false, this.spatialConstraints);
            }
            return seQuery;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CreateSeRegistrationCommand
    extends Command<SeRegistration> {
        private String typeName;

        public CreateSeRegistrationCommand(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public SeRegistration execute(ISession session, SeConnection connection) throws SeException, IOException {
            return new SeRegistration(connection, this.typeName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CloseConnection
    extends Command<Void> {
        @Override
        public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
            try {
                connection.close();
                LOGGER.fine(session.toString() + " successfully closed");
            }
            catch (Exception ignore) {
                LOGGER.fine("Problem closing " + session.toString() + ": " + ignore.getMessage());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CommitTransaction
    extends Command<Void> {
        @Override
        public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
            connection.commitTransaction();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FetchRowCommand
    extends Command<SdeRow> {
        private final SeQuery query;
        private final SdeRow holder;

        public FetchRowCommand(SeQuery query, SdeRow holder) {
            this.query = query;
            this.holder = holder;
        }

        @Override
        public SdeRow execute(ISession session, SeConnection connection) throws SeException, IOException {
            SeRow row = this.query.fetch();
            if (row == null) {
                return null;
            }
            this.holder.setRow(row);
            return this.holder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GetLayerCommand
    extends Command<SeLayer> {
        private final SeTable table;

        public GetLayerCommand(SeTable table) {
            this.table = table;
        }

        @Override
        public SeLayer execute(ISession session, SeConnection connection) throws SeException, IOException {
            String shapeColumn = this.getShapeColumn(this.table);
            if (shapeColumn == null) {
                return null;
            }
            String layerName = this.table.getQualifiedName();
            SeLayer layer = new SeLayer(connection, layerName, shapeColumn);
            return layer;
        }

        private String getShapeColumn(SeTable table) throws ArcSdeException {
            try {
                for (SeColumnDefinition aDef : table.describe()) {
                    if (aDef.getType() != SeColumnDefinition.TYPE_SHAPE) continue;
                    return aDef.getName();
                }
            }
            catch (SeException e) {
                throw new ArcSdeException("Exception describing table " + table.getName(), e);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GetTableCommand
    extends Command<SeTable> {
        private final String tableName;

        public GetTableCommand(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public SeTable execute(ISession session, SeConnection connection) throws SeException, IOException {
            SeTable table = new SeTable(connection, this.tableName);
            try {
                table.describe();
            }
            catch (SeException e) {
                throw new IOException("Table does not exist: " + this.tableName);
            }
            return table;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GetVersionCommand
    extends Command<SeVersion> {
        private String versionName;

        public GetVersionCommand(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public SeVersion execute(ISession session, SeConnection connection) throws SeException, IOException {
            SeVersion version;
            try {
                version = new SeVersion(connection, this.versionName);
            }
            catch (SeException cause) {
                if (cause.getSeError().getSdeError() == -126) {
                    ArrayList<String> available = new ArrayList<String>();
                    try {
                        SeVersion[] versionList;
                        for (SeVersion v : versionList = connection.getVersionList(null)) {
                            available.add(v.getName());
                        }
                        throw new ArcSdeException("Specified ArcSDE version does not exist: " + this.versionName + ". Available versions are: " + available, cause);
                    }
                    catch (SeException ignorable) {
                        throw new ArcSdeException("Specified ArcSDE version does not exist: " + this.versionName, cause);
                    }
                }
                throw cause;
            }
            version.getInfo();
            return version;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateSeTableCommand
    extends Command<SeTable> {
        private final String qualifiedName;

        public CreateSeTableCommand(String qualifiedName) {
            this.qualifiedName = qualifiedName;
        }

        @Override
        public SeTable execute(ISession session, SeConnection connection) throws SeException, IOException {
            return new SeTable(connection, this.qualifiedName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescribeTableCommand
    extends Command<SeColumnDefinition[]> {
        private final SeTable table;

        public DescribeTableCommand(SeTable table) {
            this.table = table;
        }

        @Override
        public SeColumnDefinition[] execute(ISession session, SeConnection connection) throws SeException, IOException {
            return this.table.describe();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CloseStateCommand
    extends Command<Object> {
        private final SeState state;

        public CloseStateCommand(SeState state) {
            this.state = state;
        }

        @Override
        public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
            this.state.close();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CloseStreamCommand
    extends Command<Object> {
        private final SeStreamOp stream;

        public CloseStreamCommand(SeStreamOp stream) {
            this.stream = stream;
        }

        @Override
        public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
            this.stream.close();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CreateSeStateCommand
    extends Command<SeState> {
        private final SeObjectId stateId;

        public CreateSeStateCommand(SeObjectId stateId) {
            this.stateId = stateId;
        }

        @Override
        public SeState execute(ISession session, SeConnection connection) throws SeException, IOException {
            return new SeState(connection, this.stateId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CreateAndExecuteQueryCommand
    extends Command<SeQuery> {
        private final String[] propertyNames;
        private final SeSqlConstruct sql;

        public CreateAndExecuteQueryCommand(String[] propertyNames, SeSqlConstruct sql) {
            this.propertyNames = propertyNames;
            this.sql = sql;
        }

        @Override
        public SeQuery execute(ISession session, SeConnection connection) throws SeException, IOException {
            SeQuery query = new SeQuery(connection, this.propertyNames, this.sql);
            query.prepareQuery();
            query.execute();
            return query;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CreateVersionStateCommand
    extends Command<SeState> {
        private final long parentStateId;

        public CreateVersionStateCommand(long parentStateId) {
            this.parentStateId = parentStateId;
        }

        @Override
        public SeState execute(ISession session, SeConnection connection) throws SeException, IOException {
            SeState parentState = new SeState(connection, new SeObjectId(this.parentStateId));
            SeState realParent = null;
            boolean mergeParentToRealParent = false;
            if (parentState.isOpen()) {
                try {
                    parentState.close();
                    realParent = parentState;
                }
                catch (SeException e) {
                    int errorCode = e.getSeError().getSdeError();
                    if (SeError.SE_STATE_INUSE == errorCode || SeError.SE_NO_PERMISSIONS == errorCode) {
                        realParent = new SeState(connection, parentState.getParentId());
                        mergeParentToRealParent = true;
                    }
                    throw e;
                }
            } else {
                realParent = parentState;
            }
            SeState newState = new SeState(connection);
            newState.create(realParent.getId());
            if (mergeParentToRealParent) {
                newState.merge(realParent.getId(), parentState.getId());
            }
            return newState;
        }
    }
}

