/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeCoordinateReference;
import com.esri.sde.sdk.client.SeDefs;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeExtent;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeQueryInfo;
import com.esri.sde.sdk.client.SeRegistration;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeShape;
import com.esri.sde.sdk.client.SeTable;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.data.ArcSDEGeometryBuilder;
import org.geotools.arcsde.data.FIDReader;
import org.geotools.arcsde.data.FeatureTypeInfo;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.ISession;
import org.geotools.data.DataSourceException;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.Identifier;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArcSDEAdapter {
    private static final Logger LOGGER = Logging.getLogger((String)ArcSDEAdapter.class.getName());
    private static final Map<Integer, Class<?>> sde2JavaTypes = new HashMap();
    private static final Map<Class<?>, SdeTypeDef> java2SDETypes = new HashMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int guessShapeTypes(GeometryDescriptor attribute) {
        if (attribute == null) {
            throw new NullPointerException("a GeometryAttributeType must be provided, got null");
        }
        Class geometryClass = attribute.getType().getBinding();
        int shapeTypes = 0;
        if (attribute.isNillable()) {
            shapeTypes |= SeLayer.SE_NIL_TYPE_MASK;
        }
        if (GeometryCollection.class.isAssignableFrom(geometryClass)) {
            shapeTypes |= SeLayer.SE_MULTIPART_TYPE_MASK;
            if (geometryClass == MultiPoint.class) {
                shapeTypes |= SeLayer.SE_POINT_TYPE_MASK;
                return shapeTypes;
            } else if (geometryClass == MultiLineString.class) {
                shapeTypes |= SeLayer.SE_LINE_TYPE_MASK;
                return shapeTypes;
            } else {
                if (geometryClass != MultiPolygon.class) throw new IllegalArgumentException("no SDE geometry mapping for " + geometryClass);
                shapeTypes |= SeLayer.SE_AREA_TYPE_MASK;
            }
            return shapeTypes;
        } else if (geometryClass == Point.class) {
            shapeTypes |= SeLayer.SE_POINT_TYPE_MASK;
            return shapeTypes;
        } else if (geometryClass == LineString.class) {
            shapeTypes |= SeLayer.SE_LINE_TYPE_MASK;
            return shapeTypes;
        } else if (geometryClass == Polygon.class) {
            shapeTypes |= SeLayer.SE_AREA_TYPE_MASK;
            return shapeTypes;
        } else {
            if (geometryClass != Geometry.class) throw new IllegalArgumentException("no SDE geometry mapping for " + geometryClass);
            LOGGER.fine("Creating SeShape types for all types of geometries.");
            shapeTypes |= SeLayer.SE_MULTIPART_TYPE_MASK | SeLayer.SE_POINT_TYPE_MASK | SeLayer.SE_LINE_TYPE_MASK | SeLayer.SE_AREA_TYPE_MASK;
        }
        return shapeTypes;
    }

    public static SeColumnDefinition createSeColumnDefinition(AttributeDescriptor type) throws SeException {
        SeColumnDefinition colDef = null;
        String colName = type.getLocalName();
        boolean nillable = type.isNillable();
        SdeTypeDef def = ArcSDEAdapter.getSdeType(type.getType().getBinding());
        int sdeColType = def.colDefType;
        int fieldLength = def.size;
        int fieldScale = def.scale;
        colDef = new SeColumnDefinition(colName, sdeColType, fieldLength, fieldScale, nillable);
        return colDef;
    }

    private static SdeTypeDef getSdeType(Class<?> attClass) throws IllegalArgumentException {
        SdeTypeDef sdeType = java2SDETypes.get(attClass);
        if (sdeType == null) {
            throw new IllegalArgumentException("No SDE type mapping for " + attClass.getName());
        }
        return sdeType;
    }

    public static FeatureTypeInfo fetchSchema(String typeName, String namespace, ISession session) throws IOException {
        boolean canDoTransactions;
        SeColumnDefinition[] seColumns;
        final SeTable table = session.getTable(typeName);
        SeLayer layer = null;
        for (SeColumnDefinition col : seColumns = session.describe(typeName)) {
            if (col.getType() != SeColumnDefinition.TYPE_SHAPE) continue;
            layer = session.getLayer(typeName);
            break;
        }
        List<AttributeDescriptor> properties = ArcSDEAdapter.createAttributeDescriptors(layer, namespace, seColumns);
        SimpleFeatureType featureType = ArcSDEAdapter.createSchema(typeName, namespace, properties);
        SeRegistration registration = session.createSeRegistration(typeName);
        boolean isMultiVersioned = registration.isMultiVersion();
        boolean isView = registration.isView();
        FIDReader fidStrategy = FIDReader.getFidReader(session, table, layer, registration);
        Integer permMask = (Integer)session.issue((Command)new Command<Integer>(){

            public Integer execute(ISession session, SeConnection connection) throws SeException, IOException {
                return new Integer(table.getPermissions());
            }
        });
        boolean hasWritePermissions = ArcSDEAdapter.userHasWritePermissions(permMask);
        boolean bl = canDoTransactions = hasWritePermissions && (fidStrategy instanceof FIDReader.SdeManagedFidReader || fidStrategy instanceof FIDReader.UserManagedFidReader) && !ArcSDEAdapter.hasReadOnlyColumn(seColumns);
        if (hasWritePermissions && !canDoTransactions) {
            LOGGER.fine(typeName + " is writable bu has no primary key, thus we're using it " + "read-only as can't get a propper feature id out of it");
        }
        FeatureTypeInfo typeInfo = new FeatureTypeInfo(featureType, fidStrategy, canDoTransactions, isMultiVersioned, isView);
        return typeInfo;
    }

    private static boolean hasReadOnlyColumn(SeColumnDefinition[] seColumns) {
        for (SeColumnDefinition col : seColumns) {
            if (col.getType() != SeColumnDefinition.TYPE_CLOB && col.getType() != SeColumnDefinition.TYPE_NCLOB) continue;
            return true;
        }
        return false;
    }

    private static boolean userHasWritePermissions(int permissions) throws ArcSdeException {
        int insertMask = SeDefs.SE_INSERT_PRIVILEGE;
        int updateMask = SeDefs.SE_UPDATE_PRIVILEGE;
        int deleteMask = SeDefs.SE_DELETE_PRIVILEGE;
        boolean canWrite = false;
        if ((insertMask & permissions) == insertMask && (updateMask & permissions) == updateMask && (deleteMask & permissions) == deleteMask) {
            canWrite = true;
        }
        return canWrite;
    }

    public static FeatureTypeInfo createInprocessViewSchema(ISession session, String typeName, String namespace, PlainSelect qualifiedSelect, final SeQueryInfo queryInfo) throws IOException {
        String mainTable;
        try {
            mainTable = queryInfo.getConstruct().getTables()[0];
        }
        catch (SeException e) {
            throw new ArcSdeException(e);
        }
        SeLayer layer = null;
        try {
            layer = session.getLayer(mainTable);
        }
        catch (NoSuchElementException e) {
            LOGGER.info(mainTable + " is not an SeLayer, so no CRS info will be parsed");
        }
        LOGGER.fine("testing query");
        Command<SeColumnDefinition[]> testQueryCmd = new Command<SeColumnDefinition[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SeColumnDefinition[] execute(ISession session, SeConnection connection) throws SeException, IOException {
                SeQuery testQuery = new SeQuery(connection);
                try {
                    SeColumnDefinition[] colDefs;
                    testQuery.prepareQueryInfo(queryInfo);
                    testQuery.execute();
                    LOGGER.fine("definition query executed successfully");
                    LOGGER.fine("fetching row to obtain view's types");
                    SeRow testRow = testQuery.fetch();
                    SeColumnDefinition[] seColumnDefinitionArray = colDefs = testRow.getColumns();
                    return seColumnDefinitionArray;
                }
                finally {
                    try {
                        testQuery.close();
                    }
                    catch (SeException e) {
                        throw new ArcSdeException(e);
                    }
                }
            }
        };
        SeColumnDefinition[] colDefs = (SeColumnDefinition[])session.issue((Command)testQueryCmd);
        List<AttributeDescriptor> attributeDescriptors = ArcSDEAdapter.createAttributeDescriptors(layer, namespace, colDefs);
        SimpleFeatureType type = ArcSDEAdapter.createSchema(typeName, namespace, attributeDescriptors);
        FIDReader fidStrategy = FIDReader.NULL_READER;
        FeatureTypeInfo typeInfo = new FeatureTypeInfo(type, fidStrategy, qualifiedSelect, queryInfo);
        return typeInfo;
    }

    private static List<AttributeDescriptor> createAttributeDescriptors(SeLayer sdeLayer, String namespace, SeColumnDefinition[] seColumns) throws DataSourceException {
        CoordinateReferenceSystem metadata = null;
        int nCols = seColumns.length;
        ArrayList<AttributeDescriptor> attDescriptors = new ArrayList<AttributeDescriptor>(nCols);
        Class<Object> typeClass = null;
        for (int i = 0; i < nCols; ++i) {
            SeColumnDefinition colDef = seColumns[i];
            String attName = colDef.getName();
            boolean isNilable = colDef.allowsNulls();
            Geometry defValue = null;
            int fieldLen = colDef.getSize();
            Integer sdeType = colDef.getType();
            if (sdeType == SeColumnDefinition.TYPE_SHAPE) {
                CoordinateReferenceSystem crs = null;
                metadata = crs = ArcSDEAdapter.parseCRS(sdeLayer);
                int seShapeType = sdeLayer.getShapeTypes();
                typeClass = ArcSDEAdapter.getGeometryTypeFromLayerMask(seShapeType);
                isNilable = (seShapeType & SeLayer.SE_NIL_TYPE_MASK) == SeLayer.SE_NIL_TYPE_MASK;
                defValue = isNilable ? null : ArcSDEGeometryBuilder.defaultValueFor(typeClass);
            } else {
                typeClass = ArcSDEAdapter.getJavaBinding(sdeType);
                if (typeClass == null) {
                    LOGGER.info("Found an unsupported ArcSDE data type: " + sdeType + " for column " + attName + ". Ignoring it.");
                    continue;
                }
            }
            short rowIdType = colDef.getRowIdType();
            if (rowIdType == SeRegistration.SE_REGISTRATION_ROW_ID_COLUMN_TYPE_SDE) continue;
            AttributeTypeBuilder b = new AttributeTypeBuilder();
            b.setDefaultValue(defValue);
            b.setBinding(typeClass);
            b.setName(attName);
            b.setNillable(isNilable);
            if (fieldLen > 0) {
                b.setLength(fieldLen);
            }
            if (Geometry.class.isAssignableFrom(typeClass)) {
                b.setCRS(metadata);
            }
            AttributeDescriptor buildDescriptor = b.buildDescriptor(attName);
            attDescriptors.add(buildDescriptor);
        }
        return attDescriptors;
    }

    public static Class<?> getJavaBinding(Integer sdeType) {
        Class<?> javaClass = sde2JavaTypes.get(sdeType);
        return javaClass;
    }

    private static SimpleFeatureType createSchema(String typeName, String namespace, List<AttributeDescriptor> properties) throws IOException {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(typeName);
        builder.setNamespaceURI(namespace);
        for (AttributeDescriptor attType : properties) {
            builder.add(attType);
        }
        return builder.buildFeatureType();
    }

    private static CoordinateReferenceSystem parseCRS(SeLayer sdeLayer) throws DataSourceException {
        CoordinateReferenceSystem crs = null;
        SeCoordinateReference seCRS = sdeLayer.getCoordRef();
        String WKT = seCRS.getProjectionDescription();
        LOGGER.finer("About to parse CRS for layer " + sdeLayer.getName() + ": " + WKT);
        try {
            LOGGER.fine(sdeLayer.getName() + " has CRS envelope: " + seCRS.getXYEnvelope());
        }
        catch (SeException e1) {
            // empty catch block
        }
        if ("UNKNOWN".equalsIgnoreCase(WKT)) {
            LOGGER.fine("ArcSDE layer " + sdeLayer.getName() + " does not provides a Coordinate Reference System");
        } else {
            try {
                CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
                crs = crsFactory.createFromWKT(WKT);
                LOGGER.fine("ArcSDE CRS correctly parsed from layer " + sdeLayer.getName());
            }
            catch (FactoryException e) {
                String msg = "CRS factory does not knows how to parse the CRS for layer " + sdeLayer.getName() + ": " + WKT;
                LOGGER.log(Level.CONFIG, msg, e);
            }
        }
        return crs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class<? extends Geometry> getGeometryTypeFromLayerMask(int seShapeType) {
        int isPolygon;
        Class<Geometry> clazz = Geometry.class;
        int MULTIPART_MASK = SeLayer.SE_MULTIPART_TYPE_MASK;
        int POINT_MASK = SeLayer.SE_POINT_TYPE_MASK;
        int SIMPLE_LINE_MASK = SeLayer.SE_SIMPLE_LINE_TYPE_MASK;
        int LINESTRING_MASK = SeLayer.SE_LINE_TYPE_MASK;
        int AREA_MASK = SeLayer.SE_AREA_TYPE_MASK;
        int isCollection = (seShapeType & MULTIPART_MASK) == MULTIPART_MASK ? 1 : 0;
        int isPoint = (seShapeType & POINT_MASK) == POINT_MASK ? 1 : 0;
        int isLineString = (seShapeType & SIMPLE_LINE_MASK) == SIMPLE_LINE_MASK || (seShapeType & LINESTRING_MASK) == LINESTRING_MASK ? 1 : 0;
        int n = isPolygon = (seShapeType & AREA_MASK) == AREA_MASK ? 1 : 0;
        if (isPoint + isLineString + isPolygon > 1) {
            clazz = Geometry.class;
            if (4 < isCollection + isPoint + isLineString + isPolygon) {
                LOGGER.warning("Be careful!! we're mapping an ArcSDE Shape type to the generic Geometry class, but the shape type does not really allows all geometry types!: isCollection=" + isCollection + ", isPoint=" + isPoint + ", isLineString=" + isLineString + ", isPolygon=" + isPolygon);
                return clazz;
            } else {
                LOGGER.fine("safely mapping SeShapeType to abstract Geometry");
            }
            return clazz;
        } else {
            if (isCollection == 1) {
                if (isPoint == 1) {
                    return MultiPoint.class;
                }
                if (isLineString == 1) {
                    return MultiLineString.class;
                }
                if (isPolygon != 1) throw new IllegalStateException("this shouldn't happen!");
                return MultiPolygon.class;
            }
            if (isPoint == 1) {
                return Point.class;
            }
            if (isLineString == 1) {
                return LineString.class;
            }
            if (isPolygon != 1) throw new IllegalStateException("this shouldn't happen!");
            return Polygon.class;
        }
    }

    public static Class<? extends Geometry> getGeometryTypeFromSeShape(SeShape shape) throws SeException {
        Class<LineString> clazz;
        int seShapeType = shape.getType();
        if (seShapeType == SeShape.TYPE_LINE || seShapeType == SeShape.TYPE_SIMPLE_LINE) {
            clazz = LineString.class;
        } else if (seShapeType == SeShape.TYPE_MULTI_LINE || seShapeType == SeShape.TYPE_MULTI_SIMPLE_LINE) {
            clazz = MultiLineString.class;
        } else if (seShapeType == SeShape.TYPE_MULTI_POINT) {
            clazz = MultiPoint.class;
        } else if (seShapeType == SeShape.TYPE_MULTI_POLYGON) {
            clazz = MultiPolygon.class;
        } else if (seShapeType == SeShape.TYPE_POINT) {
            clazz = Point.class;
        } else if (seShapeType == SeShape.TYPE_POLYGON) {
            clazz = Polygon.class;
        } else {
            throw new IllegalArgumentException("Cannot map the shape type '" + seShapeType + "' to any known SeShape.TYPE_*");
        }
        return clazz;
    }

    public static long getNumericFid(Identifier id) throws IllegalArgumentException {
        if (!(id instanceof FeatureId)) {
            throw new IllegalArgumentException("Only FeatureIds are supported when encoding id filters to SDE.  Not " + id.getClass());
        }
        String fid = ((FeatureId)id).getID();
        return ArcSDEAdapter.getNumericFid(fid);
    }

    public static long getNumericFid(String fid) throws IllegalArgumentException {
        int dotIndex = fid.lastIndexOf(46);
        try {
            return Long.decode(fid.substring(++dotIndex));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("FeatureID " + fid + " does not seems as a valid ArcSDE FID");
        }
    }

    public static long[] getNumericFids(Set<Identifier> identifiers) throws IllegalArgumentException {
        int nfids = identifiers.size();
        long[] fids = new long[nfids];
        Iterator<Identifier> ids = identifiers.iterator();
        for (int i = 0; i < nfids; ++i) {
            fids[i] = ArcSDEAdapter.getNumericFid(ids.next());
        }
        return fids;
    }

    public static void createSchema(final SimpleFeatureType featureType, final Map<String, String> hints, ISession session) throws IOException, IllegalArgumentException {
        if (featureType == null) {
            throw new NullPointerException("You have to provide a FeatureType instance");
        }
        Command<Void> createSchemaCmd = new Command<Void>(){

            public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                String[] typeNameParts = featureType.getTypeName().split("\\.");
                String unqualifiedTypeName = typeNameParts[typeNameParts.length - 1];
                SeTable table = null;
                SeLayer layer = null;
                boolean tableCreated = false;
                int rowIdType = SeRegistration.SE_REGISTRATION_ROW_ID_COLUMN_TYPE_NONE;
                String rowIdColumn = null;
                String configKeyword = "DEFAULTS";
                if (hints.containsKey("configuration.keyword")) {
                    configKeyword = String.valueOf(hints.get("configuration.keyword"));
                }
                if (hints.get("rowid.column.type") instanceof String) {
                    String rowIdStr = (String)hints.get("rowid.column.type");
                    if (rowIdStr.equalsIgnoreCase("NONE")) {
                        rowIdType = SeRegistration.SE_REGISTRATION_ROW_ID_COLUMN_TYPE_NONE;
                    } else if (rowIdStr.equalsIgnoreCase("USER")) {
                        rowIdType = SeRegistration.SE_REGISTRATION_ROW_ID_COLUMN_TYPE_USER;
                    } else if (rowIdStr.equalsIgnoreCase("SDE")) {
                        rowIdType = SeRegistration.SE_REGISTRATION_ROW_ID_COLUMN_TYPE_SDE;
                    } else {
                        throw new DataSourceException("createSchema hint 'rowid.column.type' must be one of 'NONE', 'USER' or 'SDE'");
                    }
                }
                if (hints.get("rowid.column.name") instanceof String) {
                    rowIdColumn = (String)hints.get("rowid.column.name");
                }
                Object error = null;
                try {
                    String qualifiedName = null;
                    if (unqualifiedTypeName.indexOf(46) == -1) {
                        qualifiedName = connection.getUser() + "." + unqualifiedTypeName;
                        LOGGER.finer("new full qualified type name: " + qualifiedName);
                    } else {
                        qualifiedName = unqualifiedTypeName;
                        LOGGER.finer("full qualified type name provided by user: " + qualifiedName);
                    }
                    layer = new SeLayer(connection);
                    layer.setTableName(qualifiedName);
                    layer.setCreationKeyword(configKeyword);
                    String HACK_COL_NAME = "gt_workaround_col_";
                    table = ArcSDEAdapter.createSeTable(connection, qualifiedName, "gt_workaround_col_", configKeyword);
                    tableCreated = true;
                    List atts = featureType.getAttributeDescriptors();
                    for (AttributeDescriptor currAtt : atts) {
                        if (currAtt instanceof GeometryDescriptor) {
                            GeometryDescriptor geometryAtt = (GeometryDescriptor)currAtt;
                            ArcSDEAdapter.createSeLayer(layer, qualifiedName, geometryAtt);
                            continue;
                        }
                        LOGGER.fine("Creating column definition for " + currAtt);
                        SeColumnDefinition newCol = ArcSDEAdapter.createSeColumnDefinition(currAtt);
                        newCol = new SeColumnDefinition(newCol.getName(), newCol.getType(), newCol.getSize(), (int)newCol.getScale(), true);
                        LOGGER.fine("Adding column " + newCol.getName() + " to the actual table.");
                        table.addColumn(newCol);
                    }
                    LOGGER.fine("deleting the 'workaround' column...");
                    table.dropColumn("gt_workaround_col_");
                    LOGGER.fine("setting up table registration with ArcSDE...");
                    SeRegistration reg = new SeRegistration(connection, table.getName());
                    if (rowIdColumn != null) {
                        LOGGER.fine("setting rowIdColumnName to " + rowIdColumn + " in table " + reg.getTableName());
                        reg.setRowIdColumnName(rowIdColumn);
                        reg.setRowIdColumnType(rowIdType);
                        reg.alter();
                        reg = null;
                    }
                    LOGGER.fine("Schema correctly created: " + featureType);
                }
                catch (SeException e) {
                    LOGGER.log(Level.WARNING, e.getSeError().getErrDesc(), e);
                    throw e;
                }
                finally {
                    if (error == null || tableCreated) {
                        // empty if block
                    }
                }
                return null;
            }
        };
        session.issue((Command)createSchemaCmd);
    }

    private static SeTable createSeTable(SeConnection connection, String qualifiedName, String hackColName, String configKeyword) throws SeException {
        SeColumnDefinition[] tmpCol = new SeColumnDefinition[]{new SeColumnDefinition(hackColName, SeColumnDefinition.TYPE_STRING, 4, 0, true)};
        SeTable table = new SeTable(connection, qualifiedName);
        LOGGER.info("creating table " + qualifiedName);
        table.create(tmpCol, configKeyword);
        LOGGER.info("table " + qualifiedName + " created...");
        return table;
    }

    private static void createSeLayer(SeLayer layer, String qualifiedName, GeometryDescriptor geometryAtt) throws SeException {
        String spatialColName = geometryAtt.getLocalName();
        LOGGER.info("setting spatial column name: " + spatialColName);
        layer.setSpatialColumnName(spatialColName);
        int seShapeTypes = ArcSDEAdapter.guessShapeTypes(geometryAtt);
        layer.setShapeTypes(seShapeTypes);
        layer.setGridSizes(1100.0, 0.0, 0.0);
        layer.setDescription("Created with GeoTools");
        CoordinateReferenceSystem crs = geometryAtt.getCoordinateReferenceSystem();
        SeCoordinateReference coordref = ArcSDEAdapter.getGenericCoordRef();
        String WKT = null;
        if (crs == null) {
            LOGGER.warning("Creating feature type " + qualifiedName + ": the geometry attribute does not supply a coordinate reference system");
        } else {
            LOGGER.info("Creating the SeCoordRef object for CRS " + crs);
            WKT = crs.toWKT();
            coordref.setCoordSysByDescription(WKT);
        }
        SeExtent validCoordRange = null;
        validCoordRange = WKT != null && WKT.indexOf("GEOGCS") != -1 ? new SeExtent(-180.0, -90.0, 180.0, 90.0) : coordref.getXYEnvelope();
        layer.setExtent(validCoordRange);
        LOGGER.info("Applying CRS " + coordref.getCoordSysDescription());
        layer.setCoordRef(coordref);
        LOGGER.info("CRS applyed to the new layer.");
        int estInitFeatCount = 4;
        int estAvgPointsPerFeature = 4;
        LOGGER.info("Creating the layer...");
        layer.create(estInitFeatCount, estAvgPointsPerFeature);
        LOGGER.info("ArcSDE layer created.");
    }

    private static SeCoordinateReference getGenericCoordRef() throws SeException {
        SeCoordinateReference seCRS = new SeCoordinateReference();
        int shift = 600000;
        SeExtent validRange = new SeExtent((double)(-shift), (double)(-shift), (double)shift, (double)shift);
        seCRS.setXYByEnvelope(validRange);
        LOGGER.info("CRS: " + seCRS.getXYEnvelope());
        return seCRS;
    }

    static {
        sde2JavaTypes.put(SeColumnDefinition.TYPE_NSTRING, String.class);
        sde2JavaTypes.put(SeColumnDefinition.TYPE_STRING, String.class);
        sde2JavaTypes.put(SeColumnDefinition.TYPE_INT16, Short.class);
        sde2JavaTypes.put(SeColumnDefinition.TYPE_INT32, Integer.class);
        sde2JavaTypes.put(SeColumnDefinition.TYPE_INT64, Long.class);
        sde2JavaTypes.put(SeColumnDefinition.TYPE_FLOAT32, Float.class);
        sde2JavaTypes.put(SeColumnDefinition.TYPE_FLOAT64, Double.class);
        sde2JavaTypes.put(SeColumnDefinition.TYPE_DATE, Date.class);
        sde2JavaTypes.put(SeColumnDefinition.TYPE_CLOB, String.class);
        sde2JavaTypes.put(SeColumnDefinition.TYPE_NCLOB, String.class);
        sde2JavaTypes.put(SeColumnDefinition.TYPE_UUID, String.class);
        sde2JavaTypes.put(SeColumnDefinition.TYPE_SMALLINT, Short.class);
        sde2JavaTypes.put(SeColumnDefinition.TYPE_INTEGER, Integer.class);
        sde2JavaTypes.put(SeColumnDefinition.TYPE_FLOAT, Float.class);
        sde2JavaTypes.put(SeColumnDefinition.TYPE_DOUBLE, Double.class);
        java2SDETypes.put(String.class, new SdeTypeDef(SeColumnDefinition.TYPE_STRING, 255, 0));
        java2SDETypes.put(Short.class, new SdeTypeDef(SeColumnDefinition.TYPE_SMALLINT, 4, 0));
        java2SDETypes.put(Integer.class, new SdeTypeDef(SeColumnDefinition.TYPE_INTEGER, 10, 0));
        java2SDETypes.put(Float.class, new SdeTypeDef(SeColumnDefinition.TYPE_FLOAT, 5, 2));
        java2SDETypes.put(Double.class, new SdeTypeDef(SeColumnDefinition.TYPE_DOUBLE, 25, 4));
        java2SDETypes.put(Date.class, new SdeTypeDef(SeColumnDefinition.TYPE_DATE, 1, 0));
        java2SDETypes.put(Long.class, new SdeTypeDef(SeColumnDefinition.TYPE_INTEGER, 10, 0));
        java2SDETypes.put(Number.class, new SdeTypeDef(SeColumnDefinition.TYPE_DOUBLE, 25, 4));
    }

    private static class SdeTypeDef {
        final int colDefType;
        final int size;
        final int scale;

        public SdeTypeDef(int colDefType, int size, int scale) {
            this.colDefType = colDefType;
            this.size = size;
            this.scale = scale;
        }

        public String toString() {
            return "SdeTypeDef[colDefType=" + this.colDefType + ", size=" + this.size + ", scale=" + this.scale + "]";
        }
    }
}

